/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.template_questionnaire.services;

import com.geosegbar.entities.QuestionEntity;
import com.geosegbar.entities.TemplateQuestionnaireEntity;
import com.geosegbar.entities.TemplateQuestionnaireQuestionEntity;
import com.geosegbar.exceptions.NotFoundException;
import com.geosegbar.infra.checklist.services.ChecklistService;
import com.geosegbar.infra.question.persistence.jpa.QuestionRepository;
import com.geosegbar.infra.template_questionnaire.dtos.TemplateQuestionDTO;
import com.geosegbar.infra.template_questionnaire.dtos.TemplateQuestionnaireCreationDTO;
import com.geosegbar.infra.template_questionnaire.persistence.jpa.TemplateQuestionnaireRepository;
import jakarta.transaction.Transactional;
import java.util.HashSet;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class TemplateQuestionnaireService {
    private final TemplateQuestionnaireRepository templateQuestionnaireRepository;
    private final ChecklistService checklistService;
    private final QuestionRepository questionRepository;

    @Transactional
    public void deleteById(Long id) {
        this.templateQuestionnaireRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("Template n\u00e3o encontrado para exclus\u00e3o!"));
        this.templateQuestionnaireRepository.deleteById((Object)id);
    }

    @Transactional
    public TemplateQuestionnaireEntity save(TemplateQuestionnaireEntity template) {
        return (TemplateQuestionnaireEntity)this.templateQuestionnaireRepository.save((Object)template);
    }

    @Transactional
    public TemplateQuestionnaireEntity update(TemplateQuestionnaireEntity template) {
        this.templateQuestionnaireRepository.findById((Object)template.getId()).orElseThrow(() -> new NotFoundException("Template n\u00e3o encontrado para atualiza\u00e7\u00e3o!"));
        return (TemplateQuestionnaireEntity)this.templateQuestionnaireRepository.save((Object)template);
    }

    @Transactional
    public TemplateQuestionnaireEntity createWithQuestions(TemplateQuestionnaireCreationDTO dto) {
        TemplateQuestionnaireEntity template = new TemplateQuestionnaireEntity();
        template.setName(dto.getName());
        template.setTemplateQuestions(new HashSet());
        template = (TemplateQuestionnaireEntity)this.templateQuestionnaireRepository.save((Object)template);
        for (TemplateQuestionDTO questionDto : dto.getQuestions()) {
            QuestionEntity question = (QuestionEntity)this.questionRepository.findById((Object)questionDto.getQuestionId()).orElseThrow(() -> new NotFoundException("Quest\u00e3o n\u00e3o encontrada com ID: " + questionDto.getQuestionId()));
            TemplateQuestionnaireQuestionEntity templateQuestion = new TemplateQuestionnaireQuestionEntity();
            templateQuestion.setTemplateQuestionnaire(template);
            templateQuestion.setQuestion(question);
            templateQuestion.setOrderIndex(questionDto.getOrderIndex());
            template.getTemplateQuestions().add(templateQuestion);
        }
        return (TemplateQuestionnaireEntity)this.templateQuestionnaireRepository.save((Object)template);
    }

    public TemplateQuestionnaireEntity findById(Long id) {
        return (TemplateQuestionnaireEntity)this.templateQuestionnaireRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("Template n\u00e3o encontrado!"));
    }

    public List<TemplateQuestionnaireEntity> findAll() {
        return this.templateQuestionnaireRepository.findAll();
    }

    public List<TemplateQuestionnaireEntity> findByChecklistId(Long checklistId) {
        this.checklistService.findById(checklistId);
        List templates = this.templateQuestionnaireRepository.findByChecklistsId(checklistId);
        return templates;
    }

    @Generated
    public TemplateQuestionnaireService(TemplateQuestionnaireRepository templateQuestionnaireRepository, ChecklistService checklistService, QuestionRepository questionRepository) {
        this.templateQuestionnaireRepository = templateQuestionnaireRepository;
        this.checklistService = checklistService;
        this.questionRepository = questionRepository;
    }
}

