/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.security_level.web;

import com.geosegbar.common.response.WebResponseEntity;
import com.geosegbar.entities.SecurityLevelEntity;
import com.geosegbar.infra.security_level.services.SecurityLevelService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/security-levels"})
public class SecurityLevelController {
    private final SecurityLevelService securityLevelService;

    @GetMapping
    public ResponseEntity<WebResponseEntity<List<SecurityLevelEntity>>> getAllSecurityLevels() {
        List securityLevels = this.securityLevelService.findAll();
        WebResponseEntity response = WebResponseEntity.success((Object)securityLevels, (String)"N\u00edveis de seguran\u00e7a obtidos com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<SecurityLevelEntity>> getSecurityLevelById(@PathVariable Long id) {
        SecurityLevelEntity securityLevel = this.securityLevelService.findById(id);
        WebResponseEntity response = WebResponseEntity.success((Object)securityLevel, (String)"N\u00edvel de seguran\u00e7a obtido com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @PostMapping
    public ResponseEntity<WebResponseEntity<SecurityLevelEntity>> createSecurityLevel(@Valid @RequestBody SecurityLevelEntity securityLevel) {
        SecurityLevelEntity createdSecurityLevel = this.securityLevelService.save(securityLevel);
        WebResponseEntity response = WebResponseEntity.success((Object)createdSecurityLevel, (String)"N\u00edvel de seguran\u00e7a criado com sucesso!");
        return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.CREATED);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<SecurityLevelEntity>> updateSecurityLevel(@PathVariable Long id, @Valid @RequestBody SecurityLevelEntity securityLevel) {
        securityLevel.setId(id);
        SecurityLevelEntity updatedSecurityLevel = this.securityLevelService.update(securityLevel);
        WebResponseEntity response = WebResponseEntity.success((Object)updatedSecurityLevel, (String)"N\u00edvel de seguran\u00e7a atualizado com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<Void>> deleteSecurityLevel(@PathVariable Long id) {
        this.securityLevelService.deleteById(id);
        WebResponseEntity response = WebResponseEntity.success(null, (String)"N\u00edvel de seguran\u00e7a exclu\u00eddo com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @Generated
    public SecurityLevelController(SecurityLevelService securityLevelService) {
        this.securityLevelService = securityLevelService;
    }
}

