/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.permissions.dam_permissions.services;

import com.geosegbar.entities.ClientEntity;
import com.geosegbar.entities.DamEntity;
import com.geosegbar.entities.DamPermissionEntity;
import com.geosegbar.entities.UserEntity;
import com.geosegbar.exceptions.InvalidInputException;
import com.geosegbar.exceptions.NotFoundException;
import com.geosegbar.infra.client.persistence.jpa.ClientRepository;
import com.geosegbar.infra.dam.persistence.jpa.DamRepository;
import com.geosegbar.infra.permissions.dam_permissions.dtos.DamPermissionDTO;
import com.geosegbar.infra.permissions.dam_permissions.dtos.UserDamPermissionsRequestDTO;
import com.geosegbar.infra.permissions.dam_permissions.persistence.DamPermissionRepository;
import com.geosegbar.infra.user.persistence.jpa.UserRepository;
import java.lang.invoke.CallSite;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DamPermissionService {
    private final DamPermissionRepository damPermissionRepository;
    private final UserRepository userRepository;
    private final DamRepository damRepository;
    private final ClientRepository clientRepository;

    public List<DamPermissionEntity> findAllDamPermissionsForUserClients(Long userId) {
        UserEntity user = (UserEntity)this.userRepository.findById((Object)userId).orElseThrow(() -> new NotFoundException("Usu\u00e1rio n\u00e3o encontrado com ID: " + userId));
        Set userClients = user.getClients();
        if (userClients.isEmpty()) {
            return new ArrayList<DamPermissionEntity>();
        }
        ArrayList<DamPermissionEntity> allPermissions = new ArrayList<DamPermissionEntity>();
        for (ClientEntity client : userClients) {
            List clientDams = this.damRepository.findByClient(client);
            for (DamEntity dam : clientDams) {
                Optional permission = this.damPermissionRepository.findByUserAndDamAndClient(user, dam, client);
                if (permission.isPresent()) {
                    allPermissions.add((DamPermissionEntity)permission.get());
                    continue;
                }
                DamPermissionEntity newPermission = new DamPermissionEntity();
                newPermission.setUser(user);
                newPermission.setDam(dam);
                newPermission.setClient(client);
                newPermission.setHasAccess(Boolean.valueOf(false));
                newPermission.setCreatedAt(LocalDateTime.now());
                DamPermissionEntity savedPermission = (DamPermissionEntity)this.damPermissionRepository.save((Object)newPermission);
                allPermissions.add(savedPermission);
            }
        }
        return allPermissions;
    }

    @Transactional
    public List<DamPermissionEntity> setupPermissionsForUser(Long userId, UserDamPermissionsRequestDTO requestDTO) {
        UserEntity user = (UserEntity)this.userRepository.findById((Object)userId).orElseThrow(() -> new NotFoundException("Usu\u00e1rio n\u00e3o encontrado com ID: " + userId));
        ArrayList<DamPermissionEntity> createdPermissions = new ArrayList<DamPermissionEntity>();
        HashSet<CallSite> processedKeys = new HashSet<CallSite>();
        for (DamPermissionDTO permissionDTO : requestDTO.getPermissions()) {
            DamPermissionEntity permission;
            permissionDTO.setUserId(userId);
            DamEntity dam = (DamEntity)this.damRepository.findById((Object)permissionDTO.getDamId()).orElseThrow(() -> new NotFoundException("Barragem n\u00e3o encontrada com ID: " + permissionDTO.getDamId()));
            ClientEntity client = (ClientEntity)this.clientRepository.findById((Object)permissionDTO.getClientId()).orElseThrow(() -> new NotFoundException("Cliente n\u00e3o encontrado com ID: " + permissionDTO.getClientId()));
            if (!user.getClients().contains(client)) {
                throw new InvalidInputException("O cliente " + client.getName() + " n\u00e3o est\u00e1 associado ao usu\u00e1rio " + user.getName() + "!");
            }
            if (dam.getClient() == null || !dam.getClient().getId().equals(client.getId())) {
                throw new InvalidInputException("A barragem " + dam.getName() + " n\u00e3o est\u00e1 associada ao cliente " + client.getName() + "!");
            }
            String key = userId + "-" + permissionDTO.getDamId() + "-" + permissionDTO.getClientId();
            if (processedKeys.contains(key)) continue;
            processedKeys.add((CallSite)((Object)key));
            Optional existingPermission = this.damPermissionRepository.findByUserAndDamAndClient(user, dam, client);
            if (existingPermission.isPresent()) {
                permission = (DamPermissionEntity)existingPermission.get();
                permission.setHasAccess(permissionDTO.getHasAccess());
                permission.setUpdatedAt(LocalDateTime.now());
                createdPermissions.add((DamPermissionEntity)this.damPermissionRepository.save((Object)permission));
                continue;
            }
            permission = new DamPermissionEntity();
            permission.setUser(user);
            permission.setDam(dam);
            permission.setClient(client);
            permission.setHasAccess(permissionDTO.getHasAccess());
            permission.setCreatedAt(LocalDateTime.now());
            createdPermissions.add((DamPermissionEntity)this.damPermissionRepository.save((Object)permission));
        }
        return createdPermissions;
    }

    @Transactional
    public List<DamPermissionEntity> updatePermissionsForUser(Long userId, UserDamPermissionsRequestDTO requestDTO) {
        UserEntity user = (UserEntity)this.userRepository.findById((Object)userId).orElseThrow(() -> new NotFoundException("Usu\u00e1rio n\u00e3o encontrado com ID: " + userId));
        ArrayList<DamPermissionEntity> updatedPermissions = new ArrayList<DamPermissionEntity>();
        HashSet<CallSite> processedKeys = new HashSet<CallSite>();
        List currentPermissions = this.findAllDamPermissionsForUserClients(userId);
        HashSet<Long> updatedPermissionIds = new HashSet<Long>();
        for (DamPermissionDTO permissionDTO : requestDTO.getPermissions()) {
            DamPermissionEntity permission;
            permissionDTO.setUserId(userId);
            DamEntity dam = (DamEntity)this.damRepository.findById((Object)permissionDTO.getDamId()).orElseThrow(() -> new NotFoundException("Barragem n\u00e3o encontrada com ID: " + permissionDTO.getDamId()));
            ClientEntity client = (ClientEntity)this.clientRepository.findById((Object)permissionDTO.getClientId()).orElseThrow(() -> new NotFoundException("Cliente n\u00e3o encontrado com ID: " + permissionDTO.getClientId()));
            if (!user.getClients().contains(client)) {
                throw new InvalidInputException("O cliente " + client.getName() + " n\u00e3o est\u00e1 associado ao usu\u00e1rio " + user.getName() + "!");
            }
            if (dam.getClient() == null || !dam.getClient().getId().equals(client.getId())) {
                throw new InvalidInputException("A barragem " + dam.getName() + " n\u00e3o est\u00e1 associada ao cliente " + client.getName() + "!");
            }
            String key = userId + "-" + permissionDTO.getDamId() + "-" + permissionDTO.getClientId();
            if (processedKeys.contains(key)) continue;
            processedKeys.add((CallSite)((Object)key));
            Optional existingPermission = this.damPermissionRepository.findByUserAndDamAndClient(user, dam, client);
            if (existingPermission.isPresent()) {
                permission = (DamPermissionEntity)existingPermission.get();
                permission.setHasAccess(permissionDTO.getHasAccess());
                permission.setUpdatedAt(LocalDateTime.now());
                DamPermissionEntity updatedPermission = (DamPermissionEntity)this.damPermissionRepository.save((Object)permission);
                updatedPermissions.add(updatedPermission);
                updatedPermissionIds.add(updatedPermission.getId());
                continue;
            }
            permission = new DamPermissionEntity();
            permission.setUser(user);
            permission.setDam(dam);
            permission.setClient(client);
            permission.setHasAccess(permissionDTO.getHasAccess());
            permission.setCreatedAt(LocalDateTime.now());
            DamPermissionEntity savedPermission = (DamPermissionEntity)this.damPermissionRepository.save((Object)permission);
            updatedPermissions.add(savedPermission);
            updatedPermissionIds.add(savedPermission.getId());
        }
        for (DamPermissionEntity currentPermission : currentPermissions) {
            if (updatedPermissionIds.contains(currentPermission.getId())) continue;
            currentPermission.setHasAccess(Boolean.valueOf(false));
            currentPermission.setUpdatedAt(LocalDateTime.now());
            updatedPermissions.add((DamPermissionEntity)this.damPermissionRepository.save((Object)currentPermission));
        }
        return updatedPermissions;
    }

    @Transactional
    public void delete(Long id) {
        if (!this.damPermissionRepository.existsById((Object)id)) {
            throw new NotFoundException("Permiss\u00e3o de barragem n\u00e3o encontrada com ID: " + id);
        }
        this.damPermissionRepository.deleteById((Object)id);
    }

    public boolean checkUserHasAccessToDam(Long userId, Long damId) {
        UserEntity user = (UserEntity)this.userRepository.findById((Object)userId).orElseThrow(() -> new NotFoundException("Usu\u00e1rio n\u00e3o encontrado com ID: " + userId));
        DamEntity dam = (DamEntity)this.damRepository.findById((Object)damId).orElseThrow(() -> new NotFoundException("Barragem n\u00e3o encontrada com ID: " + damId));
        ClientEntity client = dam.getClient();
        if (client == null) {
            throw new NotFoundException("Barragem n\u00e3o est\u00e1 associada a nenhum cliente");
        }
        if (!user.getClients().contains(client)) {
            return false;
        }
        Optional permission = this.damPermissionRepository.findByUserAndDamAndClient(user, dam, client);
        if (permission.isPresent()) {
            return ((DamPermissionEntity)permission.get()).getHasAccess();
        }
        return user.getRole() != null && "ADMIN".equals(user.getRole().getName().name());
    }

    @Generated
    public DamPermissionService(DamPermissionRepository damPermissionRepository, UserRepository userRepository, DamRepository damRepository, ClientRepository clientRepository) {
        this.damPermissionRepository = damPermissionRepository;
        this.userRepository = userRepository;
        this.damRepository = damRepository;
        this.clientRepository = clientRepository;
    }
}

