/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.instrument.services;

import com.geosegbar.entities.DamEntity;
import com.geosegbar.entities.InstrumentTypeEntity;
import com.geosegbar.entities.MeasurementUnitEntity;
import com.geosegbar.entities.SectionEntity;
import com.geosegbar.exceptions.DuplicateResourceException;
import com.geosegbar.exceptions.InvalidInputException;
import com.geosegbar.infra.dam.services.DamService;
import com.geosegbar.infra.instrument.dtos.ConstantDTO;
import com.geosegbar.infra.instrument.dtos.CreateInstrumentRequest;
import com.geosegbar.infra.instrument.dtos.DeterministicLimitDTO;
import com.geosegbar.infra.instrument.dtos.ImportInstrumentsRequest;
import com.geosegbar.infra.instrument.dtos.InputDTO;
import com.geosegbar.infra.instrument.dtos.OutputDTO;
import com.geosegbar.infra.instrument.dtos.StatisticalLimitDTO;
import com.geosegbar.infra.instrument.services.BulkInstrumentImportService;
import com.geosegbar.infra.instrument.services.InstrumentService;
import com.geosegbar.infra.instrument_type.persistence.jpa.InstrumentTypeRepository;
import com.geosegbar.infra.measurement_unit.persistence.jpa.MeasurementUnitRepository;
import com.geosegbar.infra.section.persistence.jpa.SectionRepository;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class BulkInstrumentImportService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BulkInstrumentImportService.class);
    private final InstrumentService instrumentService;
    private final DamService damService;
    private final MeasurementUnitRepository muRepository;
    private final SectionRepository sectionRepository;
    private final InstrumentTypeRepository instrumentTypeRepository;

    public ImportResult importFromExcel(ImportInstrumentsRequest meta, MultipartFile file) {
        ImportResult result = new ImportResult();
        if (file == null || file.isEmpty()) {
            throw new InvalidInputException("Nenhum arquivo foi enviado. Por favor, selecione uma planilha Excel v\u00e1lida.");
        }
        String fileName = file.getOriginalFilename();
        if (fileName == null || !fileName.endsWith(".xlsx") && !fileName.endsWith(".xls")) {
            throw new InvalidInputException("Formato de arquivo inv\u00e1lido. Por favor, envie um arquivo Excel (.xlsx ou .xls).");
        }
        Map<String, Long> unitMap = this.muRepository.findAll().stream().collect(Collectors.toMap(MeasurementUnitEntity::getAcronym, MeasurementUnitEntity::getId));
        Map<String, InstrumentTypeEntity> instrumentTypesByName = this.instrumentTypeRepository.findAll().stream().collect(Collectors.toMap(type -> type.getName().toUpperCase(), type -> type));
        Map<String, SectionEntity> sectionsByName = this.sectionRepository.findAllByDamId(meta.getDamId()).stream().collect(Collectors.toMap(SectionEntity::getName, s -> s));
        DamEntity dam = this.damService.findById(meta.getDamId());
        try (InputStream is = file.getInputStream();){
            Workbook wb = WorkbookFactory.create((InputStream)is);
            Sheet instrumentsSheet = wb.getSheet("Instruments");
            if (instrumentsSheet == null) {
                throw new InvalidInputException("Formato de planilha inv\u00e1lido: Aba 'Instruments' n\u00e3o encontrada. Por favor, use o modelo de planilha correto.");
            }
            Sheet inputsSheet = wb.getSheet("Inputs");
            Sheet constantsSheet = wb.getSheet("Constants");
            Sheet outputsSheet = wb.getSheet("Outputs");
            Sheet limitsSheet = wb.getSheet("Limits");
            if (inputsSheet == null || constantsSheet == null || outputsSheet == null || limitsSheet == null) {
                throw new InvalidInputException("Formato de planilha inv\u00e1lido: Uma ou mais abas necess\u00e1rias n\u00e3o foram encontradas. A planilha deve conter as abas: 'Instruments', 'Inputs', 'Constants', 'Outputs' e 'Limits'.");
            }
            Map instruments = this.parseInstrumentSheet(instrumentsSheet);
            Map inputs = this.parseComponent(inputsSheet, unitMap, InputDTO.class);
            Map constants = this.parseComponent(constantsSheet, unitMap, ConstantDTO.class);
            Map outputs = this.parseComponent(outputsSheet, unitMap, OutputDTO.class);
            Map limits = this.parseLimits(limitsSheet);
            result.setTotal(instruments.size());
            if (instruments.isEmpty()) {
                throw new InvalidInputException("A planilha n\u00e3o cont\u00e9m instrumentos para importar. Verifique se a aba 'Instruments' possui dados v\u00e1lidos.");
            }
            for (InstrumentRow ir : instruments.values()) {
                String msg;
                String instrumentTypeName;
                Long sectionId = null;
                if (ir.sectionName != null && !ir.sectionName.isBlank()) {
                    SectionEntity sec = sectionsByName.get(ir.sectionName);
                    if (sec == null) {
                        throw new InvalidInputException(String.format("Se\u00e7\u00e3o '%s' n\u00e3o encontrada para barragem %s!", ir.sectionName, dam.getName()));
                    }
                    sectionId = sec.getId();
                }
                String string = instrumentTypeName = ir.instrumentTypeName != null ? ir.instrumentTypeName.trim().toUpperCase() : null;
                if (instrumentTypeName == null || instrumentTypeName.isBlank()) {
                    throw new InvalidInputException("Tipo de instrumento \u00e9 obrigat\u00f3rio para o instrumento: " + ir.id);
                }
                InstrumentTypeEntity instrumentType = instrumentTypesByName.get(instrumentTypeName);
                if (instrumentType == null) {
                    throw new InvalidInputException("Tipo de instrumento n\u00e3o encontrado: " + ir.instrumentTypeName);
                }
                CreateInstrumentRequest req = ir.toRequest(meta, sectionId);
                req.setInstrumentTypeId(instrumentType.getId());
                req.setInputs(inputs.getOrDefault(ir.id, Collections.emptyList()));
                req.setConstants(constants.getOrDefault(ir.id, Collections.emptyList()));
                List outs = outputs.getOrDefault(ir.id, Collections.emptyList());
                for (OutputDTO o : outs) {
                    LimitData ld = (LimitData)limits.get(new Key(ir.id, o.getAcronym()));
                    if (ld == null || !Boolean.FALSE.equals(req.getNoLimit())) continue;
                    if (ld.isStatistical) {
                        o.setStatisticalLimit(ld.statDTO);
                        continue;
                    }
                    o.setDeterministicLimit(ld.detDTO);
                }
                req.setOutputs(outs);
                try {
                    this.instrumentService.createComplete(req);
                    ++result.success;
                }
                catch (DuplicateResourceException dre) {
                    msg = String.format("Instrument %s (linha %d): %s", ir.id, ir.row, dre.getMessage());
                    ++result.failures;
                    result.errors.add(msg);
                    log.warn("Pulando duplicata: {}", (Object)msg);
                }
                catch (Exception e) {
                    msg = String.format("Instrument %s (linha %d): %s", ir.id, ir.row, e.getMessage());
                    ++result.failures;
                    result.errors.add(msg);
                    log.error("Erro importando {}: {}", (Object)ir.id, (Object)e.getMessage());
                }
            }
        }
        catch (InvalidInputException e) {
            throw e;
        }
        catch (Exception e) {
            String detailedMessage = e.getMessage();
            Object friendlyMessage = "Erro ao processar a planilha Excel. ";
            friendlyMessage = detailedMessage != null && detailedMessage.contains("iterator()") && detailedMessage.contains("null") ? (String)friendlyMessage + "Uma ou mais abas necess\u00e1rias n\u00e3o foram encontradas. Certifique-se de usar o modelo de planilha correto com as abas: 'Instruments', 'Inputs', 'Constants', 'Outputs' e 'Limits'." : (detailedMessage != null && detailedMessage.contains("Invalid header signature") ? (String)friendlyMessage + "O arquivo n\u00e3o \u00e9 uma planilha Excel v\u00e1lida ou est\u00e1 corrompido." : (String)friendlyMessage + "Detalhes: " + detailedMessage);
            throw new InvalidInputException((String)friendlyMessage);
        }
        return result;
    }

    private Map<String, InstrumentRow> parseInstrumentSheet(Sheet sheet) {
        Iterator it = sheet.iterator();
        if (!it.hasNext()) {
            throw new InvalidInputException("A aba 'Instruments' est\u00e1 vazia. Por favor, adicione dados de instrumentos.");
        }
        Row headerRow = (Row)it.next();
        Map idx = this.headerIndex(headerRow);
        List<String> requiredHeaders = List.of("ID", "Nome", "Tipo de Instrumento");
        for (String header : requiredHeaders) {
            if (idx.containsKey(header)) continue;
            throw new InvalidInputException("Cabe\u00e7alho obrigat\u00f3rio '" + header + "' n\u00e3o encontrado na aba 'Instruments'. Verifique se est\u00e1 usando o modelo de planilha correto.");
        }
        LinkedHashMap<String, InstrumentRow> map = new LinkedHashMap<String, InstrumentRow>();
        int rowNum = 1;
        while (it.hasNext()) {
            String codeStr;
            ++rowNum;
            Row r = (Row)it.next();
            String id = this.getString(r, idx, "ID");
            if (id == null || id.isBlank()) continue;
            InstrumentRow ir = new InstrumentRow();
            ir.id = id;
            ir.row = rowNum;
            ir.name = this.getString(r, idx, "Nome");
            ir.location = this.getString(r, idx, "Localiza\u00e7\u00e3o");
            ir.distanceOffset = this.getDouble(r, idx, "Dist\u00e2ncia");
            ir.latitude = this.getDouble(r, idx, "Latitude");
            ir.longitude = this.getDouble(r, idx, "Longitude");
            ir.noLimit = this.getBoolean(r, idx, "Sem Limites");
            ir.instrumentTypeName = this.getString(r, idx, "Tipo de Instrumento");
            ir.sectionName = this.getString(r, idx, "Se\u00e7\u00e3o");
            ir.isLinimetricRuler = this.getBoolean(r, idx, "R\u00e9gua Linim\u00e9trica");
            Long code = this.getLong(r, idx, "C\u00f3digo ANA");
            if (code == null && (codeStr = this.getString(r, idx, "C\u00f3digo ANA")) != null && !codeStr.isBlank()) {
                try {
                    code = Long.parseLong(codeStr.trim());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            ir.linimetricRulerCode = code;
            if (ir.name == null || ir.name.isBlank()) {
                throw new InvalidInputException("Campo 'Nome' \u00e9 obrigat\u00f3rio para o instrumento ID: " + id + " (linha " + rowNum + ")");
            }
            if (ir.instrumentTypeName == null || ir.instrumentTypeName.isBlank()) {
                throw new InvalidInputException("Campo 'Tipo de Instrumento' \u00e9 obrigat\u00f3rio para o instrumento ID: " + id + " (linha " + rowNum + ")");
            }
            map.put(id, ir);
        }
        return map;
    }

    private <T> Map<String, List<T>> parseComponent(Sheet sheet, Map<String, Long> unitMap, Class<T> clz) {
        Iterator it = sheet.iterator();
        if (!it.hasNext()) {
            return Collections.emptyMap();
        }
        Map idx = this.headerIndex((Row)it.next());
        HashMap<String, List<T>> map = new HashMap<String, List<T>>();
        while (it.hasNext()) {
            InputDTO dto;
            Row row = (Row)it.next();
            String id = this.getString(row, idx, "ID");
            if (id == null || id.isBlank()) continue;
            if (clz.equals(InputDTO.class)) {
                d = new InputDTO();
                d.setAcronym(this.getString(row, idx, "Sigla"));
                d.setName(this.getString(row, idx, "Nome"));
                d.setPrecision(this.getInt(row, idx, "Precis\u00e3o"));
                d.setMeasurementUnitId(this.fetchUnit(this.getString(row, idx, "Unidade de Medida"), unitMap));
                dto = d;
            } else if (clz.equals(ConstantDTO.class)) {
                d = new ConstantDTO();
                d.setAcronym(this.getString(row, idx, "Sigla"));
                d.setName(this.getString(row, idx, "Nome"));
                d.setPrecision(this.getInt(row, idx, "Precis\u00e3o"));
                d.setValue(this.getDouble(row, idx, "Valor"));
                d.setMeasurementUnitId(this.fetchUnit(this.getString(row, idx, "Unidade de Medida"), unitMap));
                dto = d;
            } else {
                d = new OutputDTO();
                d.setAcronym(this.getString(row, idx, "Sigla"));
                d.setName(this.getString(row, idx, "Nome"));
                d.setEquation(this.getString(row, idx, "Equa\u00e7\u00e3o"));
                d.setPrecision(this.getInt(row, idx, "Precis\u00e3o"));
                d.setMeasurementUnitId(this.fetchUnit(this.getString(row, idx, "Unidade de Medida"), unitMap));
                dto = d;
            }
            map.computeIfAbsent(id, k -> new ArrayList()).add(dto);
        }
        return map;
    }

    private Map<Key, LimitData> parseLimits(Sheet sheet) {
        Iterator it = sheet.iterator();
        if (!it.hasNext()) {
            return Collections.emptyMap();
        }
        Map idx = this.headerIndex((Row)it.next());
        HashMap<Key, LimitData> map = new HashMap<Key, LimitData>();
        while (it.hasNext()) {
            Row row = (Row)it.next();
            String id = this.getString(row, idx, "ID");
            String out = this.getString(row, idx, "Sigla do Output");
            if (id == null || out == null) continue;
            String type = this.getString(row, idx, "Tipo de Limite");
            LimitData ld = new LimitData();
            if ("Estatistico".equalsIgnoreCase(type)) {
                ld.isStatistical = true;
                ld.statDTO = new StatisticalLimitDTO(null, this.getDouble(row, idx, "Valor Inferior"), this.getDouble(row, idx, "Valor Superior"));
            } else {
                ld.isStatistical = false;
                ld.detDTO = new DeterministicLimitDTO(null, this.getDouble(row, idx, "Valor de Aten\u00e7\u00e3o"), this.getDouble(row, idx, "Valor de Alerta"), this.getDouble(row, idx, "Valor de Emerg\u00eancia"));
            }
            map.put(new Key(id, out), ld);
        }
        return map;
    }

    private Map<String, Integer> headerIndex(Row header) {
        HashMap<String, Integer> idx = new HashMap<String, Integer>();
        for (Cell c : header) {
            idx.put(c.getStringCellValue(), c.getColumnIndex());
        }
        return idx;
    }

    private String getString(Row r, Map<String, Integer> ix, String col) {
        Integer i = ix.get(col);
        if (i == null) {
            return null;
        }
        Cell c = r.getCell(i.intValue());
        if (c == null) {
            return null;
        }
        return switch (1.$SwitchMap$org$apache$poi$ss$usermodel$CellType[c.getCellType().ordinal()]) {
            case 1 -> c.getStringCellValue();
            case 2 -> BigDecimal.valueOf(c.getNumericCellValue()).stripTrailingZeros().toPlainString();
            case 3 -> Boolean.toString(c.getBooleanCellValue());
            case 4 -> {
                if (c.getCachedFormulaResultType() == CellType.STRING) {
                    yield c.getStringCellValue();
                }
                yield String.valueOf(c.getNumericCellValue());
            }
            default -> null;
        };
    }

    private Double getDouble(Row r, Map<String, Integer> ix, String col) {
        Integer i = ix.get(col);
        if (i == null) {
            return null;
        }
        Cell c = r.getCell(i.intValue());
        return c != null && c.getCellType() == CellType.NUMERIC ? Double.valueOf(c.getNumericCellValue()) : null;
    }

    private Long getLong(Row r, Map<String, Integer> ix, String col) {
        Double d = this.getDouble(r, ix, col);
        return d == null ? null : Long.valueOf(d.longValue());
    }

    private Integer getInt(Row r, Map<String, Integer> ix, String col) {
        Double d = this.getDouble(r, ix, col);
        return d == null ? null : Integer.valueOf(d.intValue());
    }

    private Boolean getBoolean(Row r, Map<String, Integer> ix, String col) {
        String v = this.getString(r, ix, col);
        return v == null ? null : Boolean.valueOf(v);
    }

    private Long fetchUnit(String acr, Map<String, Long> unitMap) {
        Long id = unitMap.get(acr);
        if (id == null) {
            throw new InvalidInputException("Unidade n\u00e3o encontrada: " + acr);
        }
        return id;
    }

    @Generated
    public BulkInstrumentImportService(InstrumentService instrumentService, DamService damService, MeasurementUnitRepository muRepository, SectionRepository sectionRepository, InstrumentTypeRepository instrumentTypeRepository) {
        this.instrumentService = instrumentService;
        this.damService = damService;
        this.muRepository = muRepository;
        this.sectionRepository = sectionRepository;
        this.instrumentTypeRepository = instrumentTypeRepository;
    }
}

