/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.input.web;

import com.geosegbar.common.response.WebResponseEntity;
import com.geosegbar.entities.InputEntity;
import com.geosegbar.infra.input.services.InputService;
import java.util.List;
import lombok.Generated;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/inputs"})
public class InputController {
    private final InputService inputService;

    @GetMapping(value={"/instrument/{instrumentId}"})
    public ResponseEntity<WebResponseEntity<List<InputEntity>>> getInputsByInstrument(@PathVariable Long instrumentId) {
        List inputs = this.inputService.findByInstrumentId(instrumentId);
        return ResponseEntity.ok((Object)WebResponseEntity.success((Object)inputs, (String)"Inputs do instrumento obtidos com sucesso!"));
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<InputEntity>> getInputById(@PathVariable Long id) {
        InputEntity input = this.inputService.findById(id);
        return ResponseEntity.ok((Object)WebResponseEntity.success((Object)input, (String)"Input obtido com sucesso!"));
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<Void>> deleteInput(@PathVariable Long id) {
        this.inputService.deleteById(id);
        return ResponseEntity.ok((Object)WebResponseEntity.success(null, (String)"Input exclu\u00eddo com sucesso!"));
    }

    @Generated
    public InputController(InputService inputService) {
        this.inputService = inputService;
    }
}

