/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.classification_dam.web;

import com.geosegbar.common.response.WebResponseEntity;
import com.geosegbar.entities.ClassificationDamEntity;
import com.geosegbar.infra.classification_dam.services.ClassificationDamService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/classification-dams"})
public class ClassificationDamController {
    private final ClassificationDamService classificationDamService;

    @GetMapping
    public ResponseEntity<WebResponseEntity<List<ClassificationDamEntity>>> getAllClassificationDams() {
        List classificationDams = this.classificationDamService.findAll();
        WebResponseEntity response = WebResponseEntity.success((Object)classificationDams, (String)"Classifica\u00e7\u00f5es de barragem obtidas com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<ClassificationDamEntity>> getClassificationDamById(@PathVariable Long id) {
        ClassificationDamEntity classificationDam = this.classificationDamService.findById(id);
        WebResponseEntity response = WebResponseEntity.success((Object)classificationDam, (String)"Classifica\u00e7\u00e3o de barragem obtida com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @PostMapping
    public ResponseEntity<WebResponseEntity<ClassificationDamEntity>> createClassificationDam(@Valid @RequestBody ClassificationDamEntity classificationDam) {
        ClassificationDamEntity createdClassificationDam = this.classificationDamService.save(classificationDam);
        WebResponseEntity response = WebResponseEntity.success((Object)createdClassificationDam, (String)"Classifica\u00e7\u00e3o de barragem criada com sucesso!");
        return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.CREATED);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<ClassificationDamEntity>> updateClassificationDam(@PathVariable Long id, @Valid @RequestBody ClassificationDamEntity classificationDam) {
        classificationDam.setId(id);
        ClassificationDamEntity updatedClassificationDam = this.classificationDamService.update(classificationDam);
        WebResponseEntity response = WebResponseEntity.success((Object)updatedClassificationDam, (String)"Classifica\u00e7\u00e3o de barragem atualizada com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<Void>> deleteClassificationDam(@PathVariable Long id) {
        this.classificationDamService.deleteById(id);
        WebResponseEntity response = WebResponseEntity.success(null, (String)"Classifica\u00e7\u00e3o de barragem exclu\u00edda com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @Generated
    public ClassificationDamController(ClassificationDamService classificationDamService) {
        this.classificationDamService = classificationDamService;
    }
}

