/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.checklist_response.persistence.jpa;

import com.geosegbar.entities.ChecklistResponseEntity;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.EntityGraph;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface ChecklistResponseRepository
extends JpaRepository<ChecklistResponseEntity, Long> {
    @EntityGraph(attributePaths={"user", "dam"})
    public List<ChecklistResponseEntity> findByDamId(Long var1);

    @EntityGraph(attributePaths={"user", "dam"})
    public List<ChecklistResponseEntity> findByUserId(Long var1);

    @EntityGraph(attributePaths={"user", "dam"})
    public List<ChecklistResponseEntity> findByCreatedAtBetween(LocalDateTime var1, LocalDateTime var2);

    @EntityGraph(attributePaths={"user", "dam", "questionnaireResponses", "questionnaireResponses.templateQuestionnaire", "questionnaireResponses.answers", "questionnaireResponses.answers.question", "questionnaireResponses.answers.selectedOptions", "questionnaireResponses.answers.photos"})
    @Query(value="SELECT cr FROM ChecklistResponseEntity cr WHERE cr.id = :id")
    public Optional<ChecklistResponseEntity> findByIdWithFullDetails(@Param(value="id") Long var1);

    @EntityGraph(attributePaths={"user", "dam", "questionnaireResponses", "questionnaireResponses.templateQuestionnaire"})
    @Query(value="SELECT cr FROM ChecklistResponseEntity cr WHERE cr.dam.id = :damId AND cr.checklistId = :checklistId ORDER BY cr.createdAt DESC")
    public List<ChecklistResponseEntity> findByDamIdAndChecklistIdWithDetailsOrderByCreatedAtDesc(@Param(value="damId") Long var1, @Param(value="checklistId") Long var2);

    @EntityGraph(attributePaths={"user", "dam"})
    public Page<ChecklistResponseEntity> findByUserId(Long var1, Pageable var2);

    @EntityGraph(attributePaths={"user", "dam"})
    public Page<ChecklistResponseEntity> findByCreatedAtBetween(LocalDateTime var1, LocalDateTime var2, Pageable var3);

    @EntityGraph(attributePaths={"user", "dam"})
    public Page<ChecklistResponseEntity> findAll(Pageable var1);

    @EntityGraph(attributePaths={"user", "dam"})
    public Page<ChecklistResponseEntity> findByDamIdIn(Collection<Long> var1, Pageable var2);

    @EntityGraph(attributePaths={"user", "dam"})
    public List<ChecklistResponseEntity> findByDamIdOrderByCreatedAtDesc(Long var1);

    @EntityGraph(attributePaths={"user", "dam"})
    @Query(value="SELECT cr FROM ChecklistResponseEntity cr WHERE cr.dam.id = :damId ORDER BY cr.createdAt DESC")
    public Page<ChecklistResponseEntity> findByDamIdOptimized(@Param(value="damId") Long var1, Pageable var2);

    @EntityGraph(attributePaths={"user", "dam"})
    @Query(value="SELECT cr FROM ChecklistResponseEntity cr WHERE cr.dam.id IN :damIds ORDER BY cr.createdAt DESC")
    public Page<ChecklistResponseEntity> findByDamIdsOptimized(@Param(value="damIds") Collection<Long> var1, Pageable var2);

    @EntityGraph(attributePaths={"user", "dam"})
    @Query(value="SELECT cr FROM ChecklistResponseEntity cr WHERE cr.dam.id = :damId ORDER BY cr.createdAt DESC")
    public List<ChecklistResponseEntity> findByDamIdOptimizedList(@Param(value="damId") Long var1);

    @EntityGraph(attributePaths={"user", "dam"})
    @Query(value="SELECT cr FROM ChecklistResponseEntity cr JOIN cr.dam d WHERE d.client.id = :clientId ORDER BY cr.createdAt DESC")
    public Page<ChecklistResponseEntity> findByClientIdOptimized(@Param(value="clientId") Long var1, Pageable var2);

    @Query(value="SELECT cr FROM ChecklistResponseEntity cr WHERE cr.dam.id = :damId AND cr.createdAt = (SELECT MAX(cr2.createdAt) FROM ChecklistResponseEntity cr2 WHERE cr2.dam.id = :damId)")
    @EntityGraph(attributePaths={"user", "dam"})
    public Optional<ChecklistResponseEntity> findLatestByDamId(@Param(value="damId") Long var1);

    @Query(value="SELECT cr FROM ChecklistResponseEntity cr WHERE cr.dam.client.id = :clientId AND cr.dam.id = :damId AND cr.createdAt = (SELECT MAX(cr2.createdAt) FROM ChecklistResponseEntity cr2                    WHERE cr2.dam.client.id = :clientId AND cr2.dam.id = :damId)")
    @EntityGraph(attributePaths={"user", "dam"})
    public Optional<ChecklistResponseEntity> findLatestByClientIdAndDamId(@Param(value="clientId") Long var1, @Param(value="damId") Long var2);

    @Query(value="WITH client_dams AS (\n    SELECT d.id AS dam_id\n    FROM dam d\n    WHERE d.client_id = :clientId\n),\nunique_checklists AS (\n    SELECT DISTINCT cr.checklist_id, cr.checklist_name\n    FROM checklist_responses cr\n    JOIN client_dams cd ON cr.dam_id = cd.dam_id\n),\nlatest_responses AS (\n    SELECT cr.id, cr.checklist_id, cr.checklist_name,\n           ROW_NUMBER() OVER (PARTITION BY cr.checklist_id ORDER BY cr.created_at DESC) as row_num\n    FROM checklist_responses cr\n    JOIN client_dams cd ON cr.dam_id = cd.dam_id\n)\nSELECT id FROM latest_responses\nWHERE row_num <= :limit\nORDER BY checklist_id, row_num\n", nativeQuery=true)
    public List<Long> findLatestChecklistResponseIdsByClientIdAndLimit(@Param(value="clientId") Long var1, @Param(value="limit") int var2);

    @EntityGraph(attributePaths={"user", "dam"})
    public List<ChecklistResponseEntity> findByIdIn(Collection<Long> var1);
}

