/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.answer_photo.services;

import com.geosegbar.entities.AnswerEntity;
import com.geosegbar.entities.AnswerPhotoEntity;
import com.geosegbar.exceptions.NotFoundException;
import com.geosegbar.infra.answer.persistence.jpa.AnswerRepository;
import com.geosegbar.infra.answer_photo.persistence.jpa.AnswerPhotoRepository;
import com.geosegbar.infra.file_storage.FileStorageService;
import jakarta.transaction.Transactional;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class AnswerPhotoService {
    private final AnswerPhotoRepository answerPhotoRepository;
    private final AnswerRepository answerRepository;
    private final FileStorageService fileStorageService;

    @Transactional
    public void deleteById(Long id) {
        AnswerPhotoEntity photo = (AnswerPhotoEntity)this.answerPhotoRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("Foto da resposta n\u00e3o encontrada para exclus\u00e3o!"));
        if (photo.getImagePath() != null) {
            this.fileStorageService.deleteFile(photo.getImagePath());
        }
        this.answerPhotoRepository.deleteById((Object)id);
    }

    @Transactional
    public AnswerPhotoEntity savePhoto(Long answerId, MultipartFile photo) {
        AnswerEntity answer = (AnswerEntity)this.answerRepository.findById((Object)answerId).orElseThrow(() -> new NotFoundException("Resposta n\u00e3o encontrada!"));
        String photoUrl = this.fileStorageService.storeFile(photo, "answer-photos");
        AnswerPhotoEntity answerPhoto = new AnswerPhotoEntity();
        answerPhoto.setAnswer(answer);
        answerPhoto.setImagePath(photoUrl);
        return (AnswerPhotoEntity)this.answerPhotoRepository.save((Object)answerPhoto);
    }

    @Transactional
    public AnswerPhotoEntity update(AnswerPhotoEntity answerPhoto) {
        this.answerPhotoRepository.findById((Object)answerPhoto.getId()).orElseThrow(() -> new NotFoundException("Foto da resposta n\u00e3o encontrada para atualiza\u00e7\u00e3o!"));
        return (AnswerPhotoEntity)this.answerPhotoRepository.save((Object)answerPhoto);
    }

    @Transactional
    public AnswerPhotoEntity updatePhoto(Long photoId, MultipartFile photo) {
        AnswerPhotoEntity answerPhoto = (AnswerPhotoEntity)this.answerPhotoRepository.findById((Object)photoId).orElseThrow(() -> new NotFoundException("Foto da resposta n\u00e3o encontrada para atualiza\u00e7\u00e3o!"));
        if (answerPhoto.getImagePath() != null) {
            this.fileStorageService.deleteFile(answerPhoto.getImagePath());
        }
        String photoUrl = this.fileStorageService.storeFile(photo, "answer-photos");
        answerPhoto.setImagePath(photoUrl);
        return (AnswerPhotoEntity)this.answerPhotoRepository.save((Object)answerPhoto);
    }

    public AnswerPhotoEntity findById(Long id) {
        return (AnswerPhotoEntity)this.answerPhotoRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("Foto da resposta n\u00e3o encontrada!"));
    }

    public List<AnswerPhotoEntity> findAll() {
        return this.answerPhotoRepository.findAll();
    }

    public List<AnswerPhotoEntity> findByAnswerId(Long answerId) {
        return this.answerPhotoRepository.findByAnswerId(answerId);
    }

    @Generated
    public AnswerPhotoService(AnswerPhotoRepository answerPhotoRepository, AnswerRepository answerRepository, FileStorageService fileStorageService) {
        this.answerPhotoRepository = answerPhotoRepository;
        this.answerRepository = answerRepository;
        this.fileStorageService = fileStorageService;
    }
}

