/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.anomaly.web;

import com.geosegbar.common.response.WebResponseEntity;
import com.geosegbar.entities.AnomalyEntity;
import com.geosegbar.infra.anomaly.dtos.AnomalyDTO;
import com.geosegbar.infra.anomaly.services.AnomalyService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/anomalies"})
public class AnomalyController {
    private final AnomalyService anomalyService;

    @GetMapping
    public ResponseEntity<WebResponseEntity<List<AnomalyEntity>>> getAllAnomalies() {
        List anomalies = this.anomalyService.findAll();
        WebResponseEntity response = WebResponseEntity.success((Object)anomalies, (String)"Anomalias recuperadas com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<AnomalyEntity>> getAnomalyById(@PathVariable Long id) {
        AnomalyEntity anomaly = this.anomalyService.findById(id);
        WebResponseEntity response = WebResponseEntity.success((Object)anomaly, (String)"Anomalia recuperada com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/dam/{damId}"})
    public ResponseEntity<WebResponseEntity<List<AnomalyEntity>>> getAnomaliesByDamId(@PathVariable Long damId) {
        List anomalies = this.anomalyService.findByDamId(damId);
        WebResponseEntity response = WebResponseEntity.success((Object)anomalies, (String)"Anomalias recuperadas com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @PostMapping
    public ResponseEntity<WebResponseEntity<AnomalyEntity>> createAnomaly(@Valid @RequestBody AnomalyDTO request) {
        AnomalyEntity anomaly = this.anomalyService.create(request);
        WebResponseEntity response = WebResponseEntity.success((Object)anomaly, (String)"Anomalia criada com sucesso!");
        return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.CREATED);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<AnomalyEntity>> updateAnomaly(@PathVariable Long id, @Valid @RequestBody AnomalyDTO request) {
        AnomalyEntity anomaly = this.anomalyService.update(id, request);
        WebResponseEntity response = WebResponseEntity.success((Object)anomaly, (String)"Anomalia atualizada com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<Void>> deleteAnomaly(@PathVariable Long id) {
        this.anomalyService.delete(id);
        WebResponseEntity response = WebResponseEntity.success(null, (String)"Anomalia exclu\u00edda com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @Generated
    public AnomalyController(AnomalyService anomalyService) {
        this.anomalyService = anomalyService;
    }
}

