/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.user.web;

import com.geosegbar.common.response.WebResponseEntity;
import com.geosegbar.entities.UserEntity;
import com.geosegbar.infra.user.dto.LoginRequestDTO;
import com.geosegbar.infra.user.dto.LoginResponseDTO;
import com.geosegbar.infra.user.dto.UserClientAssociationDTO;
import com.geosegbar.infra.user.dto.UserCreateDTO;
import com.geosegbar.infra.user.dto.UserPasswordUpdateDTO;
import com.geosegbar.infra.user.dto.UserUpdateDTO;
import com.geosegbar.infra.user.service.UserService;
import com.geosegbar.infra.verification_code.dto.ForgotPasswordRequestDTO;
import com.geosegbar.infra.verification_code.dto.ResetPasswordRequestDTO;
import com.geosegbar.infra.verification_code.dto.VerifyCodeRequestDTO;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/user"})
public class UserController {
    private final UserService userService;

    @GetMapping
    public ResponseEntity<WebResponseEntity<List<UserEntity>>> getAllUsers() {
        List<UserEntity> users = this.userService.findAll();
        WebResponseEntity<List<UserEntity>> response = WebResponseEntity.success(users, "Usu\u00e1rios obtidos com sucesso!");
        return ResponseEntity.ok(response);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<UserEntity>> getUserById(@PathVariable Long id) {
        UserEntity user = this.userService.findById(id);
        WebResponseEntity<UserEntity> response = WebResponseEntity.success(user, "Usu\u00e1rio obtido com sucesso!");
        return ResponseEntity.ok(response);
    }

    @GetMapping(value={"/created-by/{createdById}"})
    public ResponseEntity<WebResponseEntity<List<UserEntity>>> getUsersByCreator(@PathVariable Long createdById) {
        List<UserEntity> users = this.userService.findByCreatedBy(createdById);
        WebResponseEntity<List<UserEntity>> response = WebResponseEntity.success(users, "Usu\u00e1rios criados pelo usu\u00e1rio de ID " + createdById + " obtidos com sucesso!");
        return ResponseEntity.ok(response);
    }

    @GetMapping(value={"/filter"})
    public ResponseEntity<WebResponseEntity<List<UserEntity>>> getUsersByRoleAndClient(@RequestParam(required=false) Long roleId, @RequestParam(required=false) Long clientId, @RequestParam(required=false) Long statusId) {
        List<UserEntity> users = this.userService.findByRoleAndClient(roleId, clientId, statusId);
        WebResponseEntity<List<UserEntity>> response = WebResponseEntity.success(users, "Usu\u00e1rios filtrados obtidos com sucesso!");
        return ResponseEntity.ok(response);
    }

    @PostMapping(value={"/register"})
    public ResponseEntity<WebResponseEntity<UserEntity>> createUser(@Valid @RequestBody UserCreateDTO userDTO) {
        UserEntity createdUser = this.userService.save(userDTO);
        WebResponseEntity<UserEntity> response = WebResponseEntity.success(createdUser, "Usu\u00e1rio criado com sucesso!");
        return new ResponseEntity(response, (HttpStatusCode)HttpStatus.CREATED);
    }

    @PostMapping(value={"/login/initiate"})
    public ResponseEntity<WebResponseEntity<?>> initiateLogin(@Valid @RequestBody LoginRequestDTO userDTO) {
        Object result = this.userService.initiateLogin(userDTO);
        if (result instanceof LoginResponseDTO) {
            LoginResponseDTO loginResponse = (LoginResponseDTO)result;
            return ResponseEntity.ok(WebResponseEntity.success(loginResponse, "Usu\u00e1rio autenticado com sucesso!"));
        }
        return ResponseEntity.ok(WebResponseEntity.success(null, "C\u00f3digo de verifica\u00e7\u00e3o enviado para seu email, verifique tamb\u00e9m a caixa de spam!"));
    }

    @PostMapping(value={"/login/verify"})
    public ResponseEntity<WebResponseEntity<LoginResponseDTO>> verifyAndLogin(@Valid @RequestBody VerifyCodeRequestDTO verifyRequest) {
        LoginResponseDTO loggedUser = this.userService.verifyCodeAndLogin(verifyRequest);
        WebResponseEntity<LoginResponseDTO> response = WebResponseEntity.success(loggedUser, "Usu\u00e1rio autenticado com sucesso!");
        return ResponseEntity.ok(response);
    }

    @PostMapping(value={"/forgot-password"})
    public ResponseEntity<WebResponseEntity<Void>> forgotPassword(@Valid @RequestBody ForgotPasswordRequestDTO requestDTO) {
        this.userService.initiatePasswordReset(requestDTO);
        WebResponseEntity<Object> response = WebResponseEntity.success(null, "C\u00f3digo de redefini\u00e7\u00e3o de senha enviado para seu email, verifique tamb\u00e9m a caixa de spam!");
        return ResponseEntity.ok(response);
    }

    @PostMapping(value={"/verify-reset-code"})
    public ResponseEntity<WebResponseEntity<Boolean>> verifyResetCode(@Valid @RequestBody VerifyCodeRequestDTO verifyRequest) {
        boolean valid = this.userService.verifyResetCode(verifyRequest);
        WebResponseEntity<Boolean> response = WebResponseEntity.success(valid, "C\u00f3digo verificado com sucesso!");
        return ResponseEntity.ok(response);
    }

    @PostMapping(value={"/reset-password"})
    public ResponseEntity<WebResponseEntity<Void>> resetPassword(@Valid @RequestBody ResetPasswordRequestDTO requestDTO) {
        this.userService.resetPassword(requestDTO);
        WebResponseEntity<Object> response = WebResponseEntity.success(null, "Senha redefinida com sucesso!");
        return ResponseEntity.ok(response);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<UserEntity>> updateUser(@PathVariable Long id, @Valid @RequestBody UserUpdateDTO user) {
        UserEntity updatedUser = this.userService.update(id, user);
        WebResponseEntity<UserEntity> response = WebResponseEntity.success(updatedUser, "Usu\u00e1rio atualizado com sucesso!");
        return ResponseEntity.ok(response);
    }

    @PutMapping(value={"/{id}/password"})
    public ResponseEntity<WebResponseEntity<UserEntity>> updatePassword(@PathVariable Long id, @Valid @RequestBody UserPasswordUpdateDTO passwordDTO) {
        UserEntity updatedUser = this.userService.updatePassword(id, passwordDTO);
        WebResponseEntity<UserEntity> response = WebResponseEntity.success(updatedUser, "Senha atualizada com sucesso!");
        return ResponseEntity.ok(response);
    }

    @PutMapping(value={"/{id}/clients"})
    public ResponseEntity<WebResponseEntity<UserEntity>> updateUserClients(@PathVariable Long id, @RequestBody UserClientAssociationDTO clientAssociationDTO) {
        UserEntity updatedUser = this.userService.updateUserClients(id, clientAssociationDTO);
        WebResponseEntity<UserEntity> response = WebResponseEntity.success(updatedUser, "Clientes do usu\u00e1rio atualizados com sucesso!");
        return ResponseEntity.ok(response);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<Void>> deleteUser(@PathVariable Long id) {
        this.userService.deleteById(id);
        WebResponseEntity<Object> response = WebResponseEntity.success(null, "Usu\u00e1rio deletado com sucesso!");
        return ResponseEntity.ok(response);
    }

    @Generated
    public UserController(UserService userService) {
        this.userService = userService;
    }
}

