/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.sex.web;

import com.geosegbar.common.response.WebResponseEntity;
import com.geosegbar.entities.SexEntity;
import com.geosegbar.infra.sex.services.SexService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"sex"})
public class SexController {
    private final SexService sexService;

    @GetMapping
    public ResponseEntity<WebResponseEntity<List<SexEntity>>> getAllSexs() {
        List<SexEntity> sexs = this.sexService.findAll();
        WebResponseEntity<List<SexEntity>> response = WebResponseEntity.success(sexs, "Sexos obtidas com sucesso!");
        return ResponseEntity.ok(response);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<SexEntity>> getSexById(@PathVariable Long id) {
        SexEntity sex = this.sexService.findById(id);
        WebResponseEntity<SexEntity> response = WebResponseEntity.success(sex, "Sexo obtido com sucesso!");
        return ResponseEntity.ok(response);
    }

    @PostMapping
    public ResponseEntity<WebResponseEntity<SexEntity>> createSex(@Valid @RequestBody SexEntity sex) {
        SexEntity createdSex = this.sexService.save(sex);
        WebResponseEntity<SexEntity> response = WebResponseEntity.success(createdSex, "Sexo criado com sucesso!");
        return new ResponseEntity(response, (HttpStatusCode)HttpStatus.CREATED);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<SexEntity>> updateDam(@PathVariable Long id, @Valid @RequestBody SexEntity sex) {
        sex.setId(id);
        SexEntity updatedSex = this.sexService.save(sex);
        WebResponseEntity<SexEntity> response = WebResponseEntity.success(updatedSex, "Sexo atualizado com sucesso!");
        return ResponseEntity.ok(response);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<Void>> deleteSex(@PathVariable Long id) {
        this.sexService.deleteById(id);
        WebResponseEntity<Object> response = WebResponseEntity.success(null, "Sexo exclu\u00eddo com sucesso!");
        return ResponseEntity.ok(response);
    }

    @Generated
    public SexController(SexService sexService) {
        this.sexService = sexService;
    }
}

