/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.permissions.permissions_main.services;

import com.geosegbar.common.enums.RoleEnum;
import com.geosegbar.entities.AttributionsPermissionEntity;
import com.geosegbar.entities.ClientEntity;
import com.geosegbar.entities.DamEntity;
import com.geosegbar.entities.DamPermissionEntity;
import com.geosegbar.entities.DocumentationPermissionEntity;
import com.geosegbar.entities.InstrumentationPermissionEntity;
import com.geosegbar.entities.RoutineInspectionPermissionEntity;
import com.geosegbar.entities.UserEntity;
import com.geosegbar.exceptions.NotFoundException;
import com.geosegbar.infra.checklist.services.ChecklistService;
import com.geosegbar.infra.client.persistence.jpa.ClientRepository;
import com.geosegbar.infra.dam.persistence.jpa.DamRepository;
import com.geosegbar.infra.permissions.atributions_permission.persistence.AttributionsPermissionRepository;
import com.geosegbar.infra.permissions.dam_permissions.persistence.DamPermissionRepository;
import com.geosegbar.infra.permissions.documentation_permission.persistence.DocumentationPermissionRepository;
import com.geosegbar.infra.permissions.instrumentation_permission.persistence.InstrumentationPermissionRepository;
import com.geosegbar.infra.permissions.permissions_main.dtos.UserPermissionsDTO;
import com.geosegbar.infra.permissions.permissions_main.dtos.UserPermissionsUpdateDTO;
import com.geosegbar.infra.permissions.routine_inspection_permission.persistence.RoutineInspectionPermissionRepository;
import com.geosegbar.infra.user.persistence.jpa.UserRepository;
import jakarta.transaction.Transactional;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UserPermissionsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserPermissionsService.class);
    private final UserRepository userRepository;
    private final DocumentationPermissionRepository documentationPermissionRepository;
    private final AttributionsPermissionRepository attributionsPermissionRepository;
    private final InstrumentationPermissionRepository instrumentationPermissionRepository;
    private final RoutineInspectionPermissionRepository routineInspectionPermissionRepository;
    private final DamPermissionRepository damPermissionRepository;
    private final DamRepository damRepository;
    private final ClientRepository clientRepository;
    private final ChecklistService checklistService;

    public UserPermissionsDTO getAllPermissionsForUser(Long userId) {
        UserEntity user = (UserEntity)this.userRepository.findById(userId).orElseThrow(() -> new NotFoundException("Usu\u00e1rio n\u00e3o encontrado com ID: " + userId));
        UserPermissionsDTO permissionsDTO = new UserPermissionsDTO();
        Optional<DocumentationPermissionEntity> docPermission = this.documentationPermissionRepository.findByUser(user);
        permissionsDTO.setDocumentationPermission(docPermission.orElse(null));
        Optional<AttributionsPermissionEntity> attrPermission = this.attributionsPermissionRepository.findByUser(user);
        permissionsDTO.setAttributionsPermission(attrPermission.orElse(null));
        Optional<InstrumentationPermissionEntity> instrPermission = this.instrumentationPermissionRepository.findByUser(user);
        permissionsDTO.setInstrumentationPermission(instrPermission.orElse(null));
        Optional<RoutineInspectionPermissionEntity> routinePermission = this.routineInspectionPermissionRepository.findByUser(user);
        permissionsDTO.setRoutineInspectionPermission(routinePermission.orElse(null));
        List<DamPermissionEntity> damPermissions = this.damPermissionRepository.findByUser(user);
        permissionsDTO.setDamPermissions(damPermissions);
        return permissionsDTO;
    }

    @Transactional
    public UserPermissionsDTO updateUserPermissions(UserPermissionsUpdateDTO updateDTO) {
        UserEntity user = (UserEntity)this.userRepository.findById(updateDTO.getUserId()).orElseThrow(() -> new NotFoundException("Usu\u00e1rio n\u00e3o encontrado com ID: " + updateDTO.getUserId()));
        if (updateDTO.getDocumentationPermission() != null) {
            this.updateDocumentationPermission(user, updateDTO.getDocumentationPermission());
        }
        if (updateDTO.getAttributionsPermission() != null) {
            this.updateAttributionsPermission(user, updateDTO.getAttributionsPermission());
        }
        if (updateDTO.getInstrumentationPermission() != null) {
            this.updateInstrumentationPermission(user, updateDTO.getInstrumentationPermission());
        }
        if (updateDTO.getRoutineInspectionPermission() != null) {
            this.updateRoutineInspectionPermission(user, updateDTO.getRoutineInspectionPermission());
        }
        if (updateDTO.getDamIds() != null) {
            this.updateDamPermissions(user, updateDTO.getDamIds());
        }
        return this.getAllPermissionsForUser(user.getId());
    }

    private void updateDocumentationPermission(UserEntity user, UserPermissionsUpdateDTO.DocumentationPermissionUpdateDTO updateDTO) {
        DocumentationPermissionEntity permission;
        Optional<DocumentationPermissionEntity> existingPermission = this.documentationPermissionRepository.findByUser(user);
        if (existingPermission.isPresent()) {
            permission = existingPermission.get();
        } else {
            permission = new DocumentationPermissionEntity();
            permission.setUser(user);
        }
        if (updateDTO.getViewPSB() != null) {
            permission.setViewPSB(updateDTO.getViewPSB());
        }
        if (updateDTO.getEditPSB() != null) {
            permission.setEditPSB(updateDTO.getEditPSB());
        }
        if (updateDTO.getSharePSB() != null) {
            permission.setSharePSB(updateDTO.getSharePSB());
        }
        this.documentationPermissionRepository.save(permission);
    }

    private void updateAttributionsPermission(UserEntity user, UserPermissionsUpdateDTO.AttributionsPermissionUpdateDTO updateDTO) {
        AttributionsPermissionEntity permission;
        Optional<AttributionsPermissionEntity> existingPermission = this.attributionsPermissionRepository.findByUser(user);
        if (existingPermission.isPresent()) {
            permission = existingPermission.get();
        } else {
            permission = new AttributionsPermissionEntity();
            permission.setUser(user);
        }
        if (updateDTO.getEditUser() != null) {
            permission.setEditUser(updateDTO.getEditUser());
        }
        if (updateDTO.getEditDam() != null) {
            permission.setEditDam(updateDTO.getEditDam());
        }
        if (updateDTO.getEditGeralData() != null) {
            permission.setEditGeralData(updateDTO.getEditGeralData());
        }
        this.attributionsPermissionRepository.save(permission);
    }

    private void updateInstrumentationPermission(UserEntity user, UserPermissionsUpdateDTO.InstrumentationPermissionUpdateDTO updateDTO) {
        InstrumentationPermissionEntity permission;
        Optional<InstrumentationPermissionEntity> existingPermission = this.instrumentationPermissionRepository.findByUser(user);
        if (existingPermission.isPresent()) {
            permission = existingPermission.get();
        } else {
            permission = new InstrumentationPermissionEntity();
            permission.setUser(user);
        }
        if (updateDTO.getViewGraphs() != null) {
            permission.setViewGraphs(updateDTO.getViewGraphs());
        }
        if (updateDTO.getEditGraphsLocal() != null) {
            permission.setEditGraphsLocal(updateDTO.getEditGraphsLocal());
        }
        if (updateDTO.getEditGraphsDefault() != null) {
            permission.setEditGraphsDefault(updateDTO.getEditGraphsDefault());
        }
        if (updateDTO.getViewRead() != null) {
            permission.setViewRead(updateDTO.getViewRead());
        }
        if (updateDTO.getEditRead() != null) {
            permission.setEditRead(updateDTO.getEditRead());
        }
        if (updateDTO.getViewSections() != null) {
            permission.setViewSections(updateDTO.getViewSections());
        }
        if (updateDTO.getEditSections() != null) {
            permission.setEditSections(updateDTO.getEditSections());
        }
        this.instrumentationPermissionRepository.save(permission);
        log.info("Updated instrumentation permission for user {}", (Object)user.getId());
    }

    private void updateRoutineInspectionPermission(UserEntity user, UserPermissionsUpdateDTO.RoutineInspectionPermissionUpdateDTO updateDTO) {
        RoutineInspectionPermissionEntity permission;
        Optional<RoutineInspectionPermissionEntity> existingPermission = this.routineInspectionPermissionRepository.findByUser(user);
        if (existingPermission.isPresent()) {
            permission = existingPermission.get();
        } else {
            permission = new RoutineInspectionPermissionEntity();
            permission.setUser(user);
        }
        if (updateDTO.getIsFillWeb() != null) {
            permission.setIsFillWeb(updateDTO.getIsFillWeb());
        }
        if (updateDTO.getIsFillMobile() != null) {
            permission.setIsFillMobile(updateDTO.getIsFillMobile());
        }
        this.routineInspectionPermissionRepository.save(permission);
    }

    private void updateDamPermissions(UserEntity user, List<Long> damIds) {
        try {
            List<DamPermissionEntity> existingPermissions = this.damPermissionRepository.findByUser(user);
            for (DamPermissionEntity existing : existingPermissions) {
                boolean shouldHaveAccess = damIds.contains(existing.getDam().getId());
                if (existing.getHasAccess() == shouldHaveAccess) continue;
                existing.setHasAccess(shouldHaveAccess);
                existing.setUpdatedAt(LocalDateTime.now());
                this.damPermissionRepository.save(existing);
            }
            Set existingDamIds = existingPermissions.stream().map(perm -> perm.getDam().getId()).collect(Collectors.toSet());
            for (Long damId : damIds) {
                if (existingDamIds.contains(damId)) continue;
                DamEntity dam = (DamEntity)this.damRepository.findById(damId).orElseThrow(() -> new NotFoundException("Barragem n\u00e3o encontrada com ID: " + damId));
                if (dam.getClient() == null) {
                    throw new NotFoundException("Barragem n\u00e3o est\u00e1 associada a nenhum cliente: " + damId);
                }
                DamPermissionEntity permission = new DamPermissionEntity();
                permission.setUser(user);
                permission.setDam(dam);
                permission.setClient(dam.getClient());
                permission.setHasAccess(true);
                permission.setCreatedAt(LocalDateTime.now());
                this.damPermissionRepository.save(permission);
            }
            log.info("Updated dam permissions for user {}, dams with access: {}", (Object)user.getId(), (Object)damIds.size());
        }
        catch (Exception e) {
            log.error("Error updating dam permissions for user {}: {}", new Object[]{user.getId(), e.getMessage(), e});
            throw e;
        }
    }

    public String verifyChecklistPermission(Long userId, Long clientId, Long damId, Long checklistId, boolean isMobile) {
        UserEntity user = (UserEntity)this.userRepository.findById(userId).orElseThrow(() -> new NotFoundException("Usu\u00e1rio n\u00e3o encontrado com ID: " + userId));
        ClientEntity client = (ClientEntity)this.clientRepository.findById(clientId).orElseThrow(() -> new NotFoundException("Cliente n\u00e3o encontrado com ID: " + clientId));
        DamEntity dam = (DamEntity)this.damRepository.findById(damId).orElseThrow(() -> new NotFoundException("Barragem n\u00e3o encontrada com ID: " + damId));
        boolean isUserAssociatedWithClient = user.getClients().stream().anyMatch(c -> c.getId().equals(clientId));
        if (!isUserAssociatedWithClient) {
            return "O usu\u00e1rio n\u00e3o est\u00e1 associado ao cliente especificado";
        }
        if (user.getRole() != null && user.getRole().getName() == RoleEnum.ADMIN) {
            return "authorized";
        }
        Optional<DamPermissionEntity> damPermission = this.damPermissionRepository.findByUserAndDamAndClient(user, dam, client);
        if (damPermission.isEmpty() || !damPermission.get().getHasAccess().booleanValue()) {
            return "O usu\u00e1rio n\u00e3o tem permiss\u00e3o de acesso para esta barragem";
        }
        try {
            this.checklistService.findChecklistForDam(damId, checklistId);
        }
        catch (NotFoundException e) {
            return e.getMessage();
        }
        Optional<RoutineInspectionPermissionEntity> routinePermission = this.routineInspectionPermissionRepository.findByUser(user);
        if (routinePermission.isEmpty()) {
            return "O usu\u00e1rio n\u00e3o possui permiss\u00f5es de inspe\u00e7\u00e3o de rotina";
        }
        if (isMobile) {
            if (!routinePermission.get().getIsFillMobile().booleanValue()) {
                return "O usu\u00e1rio n\u00e3o tem permiss\u00e3o para preencher checklists no aplicativo m\u00f3vel";
            }
        } else if (!routinePermission.get().getIsFillWeb().booleanValue()) {
            return "O usu\u00e1rio n\u00e3o tem permiss\u00e3o para preencher checklists na aplica\u00e7\u00e3o web";
        }
        return "authorized";
    }

    @Generated
    public UserPermissionsService(UserRepository userRepository, DocumentationPermissionRepository documentationPermissionRepository, AttributionsPermissionRepository attributionsPermissionRepository, InstrumentationPermissionRepository instrumentationPermissionRepository, RoutineInspectionPermissionRepository routineInspectionPermissionRepository, DamPermissionRepository damPermissionRepository, DamRepository damRepository, ClientRepository clientRepository, ChecklistService checklistService) {
        this.userRepository = userRepository;
        this.documentationPermissionRepository = documentationPermissionRepository;
        this.attributionsPermissionRepository = attributionsPermissionRepository;
        this.instrumentationPermissionRepository = instrumentationPermissionRepository;
        this.routineInspectionPermissionRepository = routineInspectionPermissionRepository;
        this.damPermissionRepository = damPermissionRepository;
        this.damRepository = damRepository;
        this.clientRepository = clientRepository;
        this.checklistService = checklistService;
    }
}

