/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.output.services;

import com.geosegbar.entities.OutputEntity;
import com.geosegbar.exceptions.NotFoundException;
import com.geosegbar.infra.output.persistence.jpa.OutputRepository;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OutputService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OutputService.class);
    private final OutputRepository outputRepository;

    public List<OutputEntity> findByInstrumentId(Long instrumentId) {
        return this.outputRepository.findByInstrumentIdAndActiveTrue(instrumentId);
    }

    public OutputEntity findById(Long id) {
        return (OutputEntity)this.outputRepository.findById(id).orElseThrow(() -> new NotFoundException("Output n\u00e3o encontrado com ID: " + id));
    }

    @Transactional
    public void deleteById(Long id) {
        OutputEntity output = this.findById(id);
        this.outputRepository.delete(output);
    }

    @Generated
    public OutputService(OutputRepository outputRepository) {
        this.outputRepository = outputRepository;
    }
}

