/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.option.web;

import com.geosegbar.common.response.WebResponseEntity;
import com.geosegbar.entities.OptionEntity;
import com.geosegbar.infra.option.services.OptionService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/options"})
public class OptionController {
    private final OptionService optionService;

    @GetMapping
    public ResponseEntity<WebResponseEntity<List<OptionEntity>>> getAllOptions() {
        List<OptionEntity> options = this.optionService.findAll();
        WebResponseEntity<List<OptionEntity>> response = WebResponseEntity.success(options, "Op\u00e7\u00f5es obtidas com sucesso!");
        return ResponseEntity.ok(response);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<OptionEntity>> getOptionById(@PathVariable Long id) {
        OptionEntity option = this.optionService.findById(id);
        WebResponseEntity<OptionEntity> response = WebResponseEntity.success(option, "Op\u00e7\u00e3o obtida com sucesso!");
        return ResponseEntity.ok(response);
    }

    @PostMapping
    public ResponseEntity<WebResponseEntity<OptionEntity>> createOption(@Valid @RequestBody OptionEntity option) {
        OptionEntity created = this.optionService.save(option);
        WebResponseEntity<OptionEntity> response = WebResponseEntity.success(created, "Op\u00e7\u00e3o criada com sucesso!");
        return new ResponseEntity(response, (HttpStatusCode)HttpStatus.CREATED);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<OptionEntity>> updateOption(@PathVariable Long id, @Valid @RequestBody OptionEntity option) {
        option.setId(id);
        OptionEntity updated = this.optionService.update(option);
        WebResponseEntity<OptionEntity> response = WebResponseEntity.success(updated, "Op\u00e7\u00e3o atualizada com sucesso!");
        return ResponseEntity.ok(response);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<Void>> deleteOption(@PathVariable Long id) {
        this.optionService.deleteById(id);
        WebResponseEntity<Object> response = WebResponseEntity.success(null, "Op\u00e7\u00e3o exclu\u00edda com sucesso!");
        return ResponseEntity.ok(response);
    }

    @Generated
    public OptionController(OptionService optionService) {
        this.optionService = optionService;
    }
}

