/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.instrument_tabulate_pattern.web;

import com.geosegbar.common.response.WebResponseEntity;
import com.geosegbar.infra.instrument_tabulate_pattern.dtos.CreateTabulatePatternRequestDTO;
import com.geosegbar.infra.instrument_tabulate_pattern.dtos.TabulatePatternResponseDTO;
import com.geosegbar.infra.instrument_tabulate_pattern.dtos.UpdateTabulatePatternRequestDTO;
import com.geosegbar.infra.instrument_tabulate_pattern.services.InstrumentTabulatePatternService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tabulate-patterns"})
public class InstrumentTabulatePatternController {
    private final InstrumentTabulatePatternService patternService;

    @PostMapping
    public ResponseEntity<WebResponseEntity<TabulatePatternResponseDTO>> createPattern(@Valid @RequestBody CreateTabulatePatternRequestDTO request) {
        TabulatePatternResponseDTO dto = this.patternService.create(request);
        return new ResponseEntity(WebResponseEntity.success(dto, "Padr\u00e3o de tabela criado com sucesso!"), (HttpStatusCode)HttpStatus.CREATED);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<Void>> deletePattern(@PathVariable Long id) {
        this.patternService.delete(id);
        return ResponseEntity.ok(WebResponseEntity.success(null, "Padr\u00e3o de tabela exclu\u00eddo com sucesso!"));
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<TabulatePatternResponseDTO>> updatePattern(@PathVariable Long id, @Valid @RequestBody UpdateTabulatePatternRequestDTO request) {
        TabulatePatternResponseDTO dto = this.patternService.update(id, request);
        return ResponseEntity.ok(WebResponseEntity.success(dto, "Padr\u00e3o de tabela atualizado com sucesso!"));
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<TabulatePatternResponseDTO>> getPatternById(@PathVariable Long id) {
        TabulatePatternResponseDTO dto = this.patternService.findById(id);
        return ResponseEntity.ok(WebResponseEntity.success(dto, "Padr\u00e3o de tabela obtido com sucesso!"));
    }

    @GetMapping(value={"/dam/{damId}"})
    public ResponseEntity<WebResponseEntity<List<TabulatePatternResponseDTO>>> getPatternsByDam(@PathVariable Long damId) {
        List<TabulatePatternResponseDTO> dto = this.patternService.findByDamId(damId);
        return ResponseEntity.ok(WebResponseEntity.success(dto, "Padr\u00f5es de tabela da barragem obtidos com sucesso!"));
    }

    @GetMapping(value={"/folder/{folderId}"})
    public ResponseEntity<WebResponseEntity<List<TabulatePatternResponseDTO>>> getPatternsByFolder(@PathVariable Long folderId) {
        List<TabulatePatternResponseDTO> dto = this.patternService.findByFolderId(folderId);
        return ResponseEntity.ok(WebResponseEntity.success(dto, "Padr\u00f5es de tabela da pasta obtidos com sucesso!"));
    }

    @Generated
    public InstrumentTabulatePatternController(InstrumentTabulatePatternService patternService) {
        this.patternService = patternService;
    }
}

