/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.instrument.web;

import com.geosegbar.common.response.WebResponseEntity;
import com.geosegbar.exceptions.InvalidInputException;
import com.geosegbar.infra.instrument.dtos.ImportInstrumentsRequest;
import com.geosegbar.infra.instrument.services.BulkInstrumentImportService;
import jakarta.validation.Valid;
import lombok.Generated;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/instruments-massive"})
public class InstrumentImportController {
    private final BulkInstrumentImportService importService;

    @PostMapping
    public ResponseEntity<WebResponseEntity<BulkInstrumentImportService.ImportResult>> importExcel(@Valid @RequestPart(value="metadata", required=true) ImportInstrumentsRequest metadata, @RequestPart(value="file", required=true) MultipartFile file) {
        if (file.isEmpty()) {
            throw new InvalidInputException("O arquivo enviado est\u00e1 vazio. Por favor, selecione uma planilha Excel v\u00e1lida.");
        }
        String fileName = file.getOriginalFilename();
        if (fileName == null || !fileName.endsWith(".xlsx") && !fileName.endsWith(".xls")) {
            throw new InvalidInputException("Formato de arquivo inv\u00e1lido. Por favor, envie um arquivo Excel (.xlsx ou .xls).");
        }
        BulkInstrumentImportService.ImportResult result = this.importService.importFromExcel(metadata, file);
        return ResponseEntity.ok(WebResponseEntity.success(result, "Importa\u00e7\u00e3o conclu\u00edda"));
    }

    @Generated
    public InstrumentImportController(BulkInstrumentImportService importService) {
        this.importService = importService;
    }
}

