/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.instrument.services;

import com.geosegbar.common.utils.ExpressionEvaluator;
import com.geosegbar.entities.ConstantEntity;
import com.geosegbar.entities.DamEntity;
import com.geosegbar.entities.DeterministicLimitEntity;
import com.geosegbar.entities.InputEntity;
import com.geosegbar.entities.InstrumentEntity;
import com.geosegbar.entities.InstrumentTypeEntity;
import com.geosegbar.entities.MeasurementUnitEntity;
import com.geosegbar.entities.OutputEntity;
import com.geosegbar.entities.SectionEntity;
import com.geosegbar.entities.StatisticalLimitEntity;
import com.geosegbar.exceptions.DuplicateResourceException;
import com.geosegbar.exceptions.InvalidInputException;
import com.geosegbar.exceptions.NotFoundException;
import com.geosegbar.infra.constant.persistence.jpa.ConstantRepository;
import com.geosegbar.infra.dam.persistence.jpa.DamRepository;
import com.geosegbar.infra.deterministic_limit.persistence.jpa.DeterministicLimitRepository;
import com.geosegbar.infra.input.persistence.jpa.InputRepository;
import com.geosegbar.infra.instrument.dtos.ConstantDTO;
import com.geosegbar.infra.instrument.dtos.CreateInstrumentRequest;
import com.geosegbar.infra.instrument.dtos.DeterministicLimitDTO;
import com.geosegbar.infra.instrument.dtos.InputDTO;
import com.geosegbar.infra.instrument.dtos.InstrumentResponseDTO;
import com.geosegbar.infra.instrument.dtos.OutputDTO;
import com.geosegbar.infra.instrument.dtos.StatisticalLimitDTO;
import com.geosegbar.infra.instrument.dtos.UpdateInstrumentRequest;
import com.geosegbar.infra.instrument.events.InstrumentCreatedEvent;
import com.geosegbar.infra.instrument.persistence.jpa.InstrumentRepository;
import com.geosegbar.infra.instrument_type.persistence.jpa.InstrumentTypeRepository;
import com.geosegbar.infra.measurement_unit.persistence.jpa.MeasurementUnitRepository;
import com.geosegbar.infra.output.persistence.jpa.OutputRepository;
import com.geosegbar.infra.section.persistence.jpa.SectionRepository;
import com.geosegbar.infra.statistical_limit.persistence.jpa.StatisticalLimitRepository;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InstrumentService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InstrumentService.class);
    private final InstrumentRepository instrumentRepository;
    private final DamRepository damRepository;
    private final SectionRepository sectionRepository;
    private final MeasurementUnitRepository measurementUnitRepository;
    private final StatisticalLimitRepository statisticalLimitRepository;
    private final DeterministicLimitRepository deterministicLimitRepository;
    private final InputRepository inputRepository;
    private final ConstantRepository constantRepository;
    private final OutputRepository outputRepository;
    private final InstrumentTypeRepository instrumentTypeRepository;
    private final ApplicationEventPublisher eventPublisher;

    @Cacheable(value={"allInstruments"}, cacheManager="instrumentCacheManager")
    public List<InstrumentEntity> findAll() {
        return this.instrumentRepository.findAllByOrderByNameAsc();
    }

    @Cacheable(value={"instrumentsByDam"}, key="#damId", cacheManager="instrumentCacheManager")
    public List<InstrumentEntity> findByDamId(Long damId) {
        return this.instrumentRepository.findByDamId(damId);
    }

    @Cacheable(value={"instrumentById"}, key="#id", cacheManager="instrumentCacheManager")
    public InstrumentEntity findById(Long id) {
        return this.instrumentRepository.findByIdWithBasicRelations(id).orElseThrow(() -> new NotFoundException("Instrumento n\u00e3o encontrado com ID: " + id));
    }

    @Cacheable(value={"instrumentWithDetails"}, key="#id", cacheManager="instrumentCacheManager")
    public InstrumentEntity findWithAllDetails(Long id) {
        return this.instrumentRepository.findWithCompleteDetailsById(id).orElseThrow(() -> new NotFoundException("Instrumento n\u00e3o encontrado com ID: " + id));
    }

    @Cacheable(value={"instrumentsByClient"}, key="#clientId + '_' + #active", cacheManager="instrumentCacheManager")
    public List<InstrumentEntity> findByClientId(Long clientId, Boolean active) {
        return this.instrumentRepository.findByClientIdOptimized(clientId, active);
    }

    @Transactional
    @CacheEvict(value={"instrumentById", "instrumentWithDetails", "instrumentsByClient", "instrumentsByFilters", "instrumentsByDam", "allInstruments", "instrumentResponseDTO"}, allEntries=true, cacheManager="instrumentCacheManager")
    public InstrumentEntity createComplete(CreateInstrumentRequest request) {
        if (Boolean.TRUE.equals(request.getIsLinimetricRuler())) {
            request.setNoLimit(true);
            if (request.getLinimetricRulerCode() != null && this.instrumentRepository.findByLinimetricRulerCode(request.getLinimetricRulerCode()).isPresent()) {
                throw new DuplicateResourceException("J\u00e1 existe uma r\u00e9gua linim\u00e9trica com o c\u00f3digo " + request.getLinimetricRulerCode());
            }
        } else {
            this.validateRequest(request);
            this.validateUniqueAcronymsAcrossComponents(request.getInputs(), request.getConstants(), request.getOutputs());
        }
        if (this.instrumentRepository.existsByNameAndDamId(request.getName(), request.getDamId())) {
            throw new DuplicateResourceException("J\u00e1 existe um instrumento com o nome '" + request.getName() + "' na mesma barragem");
        }
        DamEntity dam = (DamEntity)this.damRepository.findById(request.getDamId()).orElseThrow(() -> new NotFoundException("Barragem n\u00e3o encontrada com ID: " + request.getDamId()));
        SectionEntity section = null;
        if (request.getSectionId() != null) {
            section = (SectionEntity)this.sectionRepository.findById(request.getSectionId()).orElseThrow(() -> new NotFoundException("Se\u00e7\u00e3o n\u00e3o encontrada com ID: " + request.getSectionId()));
        }
        InstrumentTypeEntity instrumentType = (InstrumentTypeEntity)this.instrumentTypeRepository.findById(request.getInstrumentTypeId()).orElseThrow(() -> new NotFoundException("Tipo de instrumento n\u00e3o encontrado com ID: " + request.getInstrumentTypeId()));
        InstrumentEntity instrument = new InstrumentEntity();
        instrument.setName(request.getName().toUpperCase());
        instrument.setLocation(request.getLocation());
        instrument.setLastUpdateVariablesDate(LocalDateTime.now());
        instrument.setDistanceOffset(request.getDistanceOffset());
        instrument.setLatitude(request.getLatitude());
        instrument.setLongitude(request.getLongitude());
        instrument.setNoLimit(request.getNoLimit());
        instrument.setInstrumentType(instrumentType);
        instrument.setDam(dam);
        instrument.setSection(section);
        instrument.setActive(true);
        instrument.setActiveForSection(request.getActiveForSection());
        instrument.setIsLinimetricRuler(request.getIsLinimetricRuler());
        instrument.setLinimetricRulerCode(request.getLinimetricRulerCode());
        InstrumentEntity savedInstrument = (InstrumentEntity)this.instrumentRepository.save(instrument);
        if (Boolean.TRUE.equals(request.getIsLinimetricRuler())) {
            this.createLinimetricRulerComponents(savedInstrument);
        } else {
            this.processInputs(savedInstrument, request.getInputs());
            if (request.getConstants() != null && !request.getConstants().isEmpty()) {
                this.processConstants(savedInstrument, request.getConstants());
            }
            this.processOutputs(savedInstrument, request.getOutputs());
        }
        savedInstrument = this.instrumentRepository.findWithActiveOutputsById(savedInstrument.getId()).orElseThrow(() -> new NotFoundException("Instrumento n\u00e3o encontrado ap\u00f3s cria\u00e7\u00e3o"));
        if (Boolean.FALSE.equals(savedInstrument.getIsLinimetricRuler())) {
            this.eventPublisher.publishEvent((Object)new InstrumentCreatedEvent(savedInstrument));
        }
        return savedInstrument;
    }

    private void validateRequest(CreateInstrumentRequest request) {
        if (Boolean.TRUE.equals(request.getIsLinimetricRuler())) {
            return;
        }
        if (request.getInputs() == null || request.getInputs().isEmpty()) {
            throw new InvalidInputException("Pelo menos um input \u00e9 obrigat\u00f3rio para instrumentos normais");
        }
        if (request.getOutputs() == null || request.getOutputs().isEmpty()) {
            throw new InvalidInputException("Pelo menos um output \u00e9 obrigat\u00f3rio para instrumentos normais");
        }
        if (!request.getNoLimit().booleanValue() && request.getOutputs().size() > 1) {
            boolean hasStatistical = request.getOutputs().get(0).getStatisticalLimit() != null;
            String firstLimitType = hasStatistical ? "estat\u00edstico" : "determin\u00edstico";
            for (int i = 1; i < request.getOutputs().size(); ++i) {
                boolean currentHasStatistical;
                OutputDTO output = request.getOutputs().get(i);
                boolean bl = currentHasStatistical = output.getStatisticalLimit() != null;
                if (hasStatistical == currentHasStatistical) continue;
                throw new InvalidInputException("Todos os outputs de um instrumento devem ter o mesmo tipo de limite. O primeiro output usa limite " + firstLimitType + ", mas o output '" + output.getName() + "' usa um tipo diferente.");
            }
        }
        for (OutputDTO outputDTO : request.getOutputs()) {
            this.validateOutputRequest(outputDTO, request.getNoLimit());
        }
    }

    private void validateRequest(UpdateInstrumentRequest request) {
        if (Boolean.TRUE.equals(request.getIsLinimetricRuler())) {
            return;
        }
        if (request.getInputs() == null || request.getInputs().isEmpty()) {
            throw new InvalidInputException("Pelo menos um input \u00e9 obrigat\u00f3rio para instrumentos normais");
        }
        if (request.getOutputs() == null || request.getOutputs().isEmpty()) {
            throw new InvalidInputException("Pelo menos um output \u00e9 obrigat\u00f3rio para instrumentos normais");
        }
        if (!request.getNoLimit().booleanValue() && request.getOutputs().size() > 1) {
            boolean hasStatistical = request.getOutputs().get(0).getStatisticalLimit() != null;
            String firstLimitType = hasStatistical ? "estat\u00edstico" : "determin\u00edstico";
            for (int i = 1; i < request.getOutputs().size(); ++i) {
                boolean currentHasStatistical;
                OutputDTO output = request.getOutputs().get(i);
                boolean bl = currentHasStatistical = output.getStatisticalLimit() != null;
                if (hasStatistical == currentHasStatistical) continue;
                throw new InvalidInputException("Todos os outputs de um instrumento devem ter o mesmo tipo de limite. O primeiro output usa limite " + firstLimitType + ", mas o output '" + output.getName() + "' usa um tipo diferente.");
            }
        }
        for (OutputDTO outputDTO : request.getOutputs()) {
            this.validateOutputRequest(outputDTO, request.getNoLimit());
        }
    }

    private void validateOutputRequest(OutputDTO outputDTO, Boolean instrumentNoLimit) {
        if (Boolean.TRUE.equals(instrumentNoLimit)) {
            if (outputDTO.getStatisticalLimit() != null || outputDTO.getDeterministicLimit() != null) {
                throw new InvalidInputException("Quando o instrumento est\u00e1 marcado como 'Sem Limites', seus outputs n\u00e3o devem ter limites estat\u00edsticos ou determin\u00edsticos");
            }
        } else {
            boolean hasDeterministic;
            boolean hasStatistical = outputDTO.getStatisticalLimit() != null;
            boolean bl = hasDeterministic = outputDTO.getDeterministicLimit() != null;
            if (!hasStatistical && !hasDeterministic) {
                throw new InvalidInputException("Quando o instrumento n\u00e3o est\u00e1 marcado como 'Sem Limites', cada output deve ter um tipo de limite");
            }
            if (hasStatistical && hasDeterministic) {
                throw new InvalidInputException("Apenas um tipo de limite (estat\u00edstico ou determin\u00edstico) deve ser fornecido para um output, n\u00e3o ambos");
            }
        }
    }

    private void processInputs(InstrumentEntity instrument, List<InputDTO> inputDTOs) {
        HashSet<String> acronyms = new HashSet<String>();
        HashSet<String> names = new HashSet<String>();
        for (InputDTO inputDTO : inputDTOs) {
            if (!acronyms.add(inputDTO.getAcronym())) {
                throw new DuplicateResourceException("Sigla de input duplicada: " + inputDTO.getAcronym());
            }
            if (!names.add(inputDTO.getName())) {
                throw new DuplicateResourceException("Nome de input duplicado: " + inputDTO.getName());
            }
            MeasurementUnitEntity measurementUnit = (MeasurementUnitEntity)this.measurementUnitRepository.findById(inputDTO.getMeasurementUnitId()).orElseThrow(() -> new NotFoundException("Unidade de medida n\u00e3o encontrada com ID: " + inputDTO.getMeasurementUnitId()));
            InputEntity input = new InputEntity();
            input.setAcronym(inputDTO.getAcronym().toUpperCase());
            input.setName(inputDTO.getName());
            input.setPrecision(inputDTO.getPrecision());
            input.setMeasurementUnit(measurementUnit);
            input.setInstrument(instrument);
            this.inputRepository.save(input);
            instrument.getInputs().add(input);
        }
    }

    private void processConstants(InstrumentEntity instrument, List<ConstantDTO> constantDTOs) {
        HashSet<String> acronyms = new HashSet<String>();
        HashSet<String> names = new HashSet<String>();
        for (ConstantDTO constantDTO : constantDTOs) {
            if (!acronyms.add(constantDTO.getAcronym())) {
                throw new DuplicateResourceException("Sigla de constante duplicada: " + constantDTO.getAcronym());
            }
            if (!names.add(constantDTO.getName())) {
                throw new DuplicateResourceException("Nome de constante duplicado: " + constantDTO.getName());
            }
            MeasurementUnitEntity measurementUnit = (MeasurementUnitEntity)this.measurementUnitRepository.findById(constantDTO.getMeasurementUnitId()).orElseThrow(() -> new NotFoundException("Unidade de medida n\u00e3o encontrada com ID: " + constantDTO.getMeasurementUnitId()));
            ConstantEntity constant = new ConstantEntity();
            constant.setAcronym(constantDTO.getAcronym().toUpperCase());
            constant.setName(constantDTO.getName());
            constant.setPrecision(constantDTO.getPrecision());
            constant.setValue(constantDTO.getValue());
            constant.setMeasurementUnit(measurementUnit);
            constant.setInstrument(instrument);
            this.constantRepository.save(constant);
            instrument.getConstants().add(constant);
        }
    }

    private void processOutputs(InstrumentEntity instrument, List<OutputDTO> outputDTOs) {
        HashSet<String> acronyms = new HashSet<String>();
        HashSet<String> names = new HashSet<String>();
        Set<String> inputAcronyms = instrument.getInputs().stream().map(InputEntity::getAcronym).collect(Collectors.toSet());
        Set<String> constantAcronyms = instrument.getConstants().stream().map(ConstantEntity::getAcronym).collect(Collectors.toSet());
        for (OutputDTO outputDTO : outputDTOs) {
            if (!acronyms.add(outputDTO.getAcronym())) {
                throw new DuplicateResourceException("Sigla de output duplicada: " + outputDTO.getAcronym());
            }
            if (!names.add(outputDTO.getName())) {
                throw new DuplicateResourceException("Nome de output duplicado: " + outputDTO.getName());
            }
            this.validateEquation(outputDTO.getEquation(), inputAcronyms, constantAcronyms);
            this.validateOutputRequest(outputDTO, instrument.getNoLimit());
            MeasurementUnitEntity measurementUnit = (MeasurementUnitEntity)this.measurementUnitRepository.findById(outputDTO.getMeasurementUnitId()).orElseThrow(() -> new NotFoundException("Unidade de medida n\u00e3o encontrada com ID: " + outputDTO.getMeasurementUnitId()));
            OutputEntity output = new OutputEntity();
            output.setAcronym(outputDTO.getAcronym().toUpperCase());
            output.setName(outputDTO.getName());
            output.setEquation(outputDTO.getEquation());
            output.setPrecision(outputDTO.getPrecision());
            output.setMeasurementUnit(measurementUnit);
            output.setActive(true);
            output.setInstrument(instrument);
            OutputEntity savedOutput = (OutputEntity)this.outputRepository.save(output);
            if (!instrument.getNoLimit().booleanValue()) {
                if (outputDTO.getStatisticalLimit() != null) {
                    StatisticalLimitEntity statisticalLimit = new StatisticalLimitEntity();
                    statisticalLimit.setOutput(savedOutput);
                    statisticalLimit.setLowerValue(outputDTO.getStatisticalLimit().getLowerValue());
                    statisticalLimit.setUpperValue(outputDTO.getStatisticalLimit().getUpperValue());
                    this.statisticalLimitRepository.save(statisticalLimit);
                    savedOutput.setStatisticalLimit(statisticalLimit);
                }
                if (outputDTO.getDeterministicLimit() != null) {
                    DeterministicLimitEntity deterministicLimit = new DeterministicLimitEntity();
                    deterministicLimit.setOutput(savedOutput);
                    deterministicLimit.setAttentionValue(outputDTO.getDeterministicLimit().getAttentionValue());
                    deterministicLimit.setAlertValue(outputDTO.getDeterministicLimit().getAlertValue());
                    deterministicLimit.setEmergencyValue(outputDTO.getDeterministicLimit().getEmergencyValue());
                    this.deterministicLimitRepository.save(deterministicLimit);
                    savedOutput.setDeterministicLimit(deterministicLimit);
                }
            }
            instrument.getOutputs().add(savedOutput);
        }
    }

    @Transactional
    @CacheEvict(value={"instrumentById", "instrumentWithDetails", "instrumentsByClient", "instrumentsByFilters", "instrumentsByDam", "allInstruments", "instrumentResponseDTO"}, allEntries=true, cacheManager="instrumentCacheManager")
    public InstrumentEntity update(Long id, UpdateInstrumentRequest request) {
        InstrumentEntity oldInstrument = this.findById(id);
        if (!oldInstrument.getIsLinimetricRuler().equals(request.getIsLinimetricRuler())) {
            throw new InvalidInputException("N\u00e3o \u00e9 permitido alterar o tipo de instrumento. Uma vez criado como r\u00e9gua linim\u00e9trica ou instrumento normal, este atributo n\u00e3o pode ser modificado.");
        }
        if (Boolean.TRUE.equals(request.getIsLinimetricRuler())) {
            request.setNoLimit(true);
            if (request.getLinimetricRulerCode() != null && this.instrumentRepository.existsByLinimetricRulerCodeAndIdNot(request.getLinimetricRulerCode(), id)) {
                throw new DuplicateResourceException("J\u00e1 existe uma r\u00e9gua linim\u00e9trica com o c\u00f3digo " + request.getLinimetricRulerCode());
            }
        } else {
            this.validateRequest(request);
            this.validateUniqueAcronymsAcrossComponents(request.getInputs(), request.getConstants(), request.getOutputs());
        }
        if (this.instrumentRepository.existsByNameAndDamIdAndIdNot(request.getName(), request.getDamId(), id)) {
            throw new DuplicateResourceException("J\u00e1 existe um instrumento com esse nome nesta barragem");
        }
        if (!Boolean.TRUE.equals(request.getIsLinimetricRuler())) {
            Set<String> newInputAcronyms = request.getInputs().stream().map(InputDTO::getAcronym).collect(Collectors.toSet());
            HashSet<String> newConstantAcronyms = request.getConstants() != null ? request.getConstants().stream().map(ConstantDTO::getAcronym).collect(Collectors.toSet()) : new HashSet<String>();
            for (OutputDTO outputDTO : request.getOutputs()) {
                try {
                    this.validateEquation(outputDTO.getEquation(), newInputAcronyms, newConstantAcronyms);
                }
                catch (InvalidInputException e) {
                    throw new InvalidInputException("Erro na equa\u00e7\u00e3o do output '" + outputDTO.getName() + "': " + e.getMessage());
                }
            }
            Map<String, InputEntity> existingInputsByAcronym = oldInstrument.getInputs().stream().collect(Collectors.toMap(InputEntity::getAcronym, input -> input, (existing, replacement) -> {
                log.warn("Encontrado input duplicado com acr\u00f4nimo: {} (ids: {} e {})", new Object[]{existing.getAcronym(), existing.getId(), replacement.getId()});
                return existing;
            }));
            Map<String, ConstantEntity> existingConstantsByAcronym = oldInstrument.getConstants().stream().collect(Collectors.toMap(ConstantEntity::getAcronym, constant -> constant, (existing, replacement) -> {
                log.warn("Encontrada constante duplicada com acr\u00f4nimo: {} (ids: {} e {})", new Object[]{existing.getAcronym(), existing.getId(), replacement.getId()});
                return existing;
            }));
            Map<String, OutputEntity> existingOutputsByAcronym = oldInstrument.getOutputs().stream().filter(OutputEntity::getActive).collect(Collectors.toMap(OutputEntity::getAcronym, output -> output, (existing, replacement) -> {
                log.warn("Encontrado output duplicado com acr\u00f4nimo: {} (ids: {} e {})", new Object[]{existing.getAcronym(), existing.getId(), replacement.getId()});
                return existing;
            }));
            this.updateInstrumentBasicFields(oldInstrument, request);
            this.processInputsForUpdate(oldInstrument, request.getInputs(), existingInputsByAcronym);
            if (request.getConstants() != null && !request.getConstants().isEmpty()) {
                this.processConstantsForUpdate(oldInstrument, request.getConstants(), existingConstantsByAcronym);
            }
            this.processOutputsForUpdate(oldInstrument, request.getOutputs(), existingOutputsByAcronym);
            this.deleteUnusedComponents(existingInputsByAcronym, existingConstantsByAcronym);
            this.instrumentRepository.save(oldInstrument);
            log.info("Instrumento normal atualizado com sucesso");
            return this.instrumentRepository.findWithActiveOutputsById(id).orElseThrow(() -> new NotFoundException("Instrumento n\u00e3o encontrado ap\u00f3s atualiza\u00e7\u00e3o"));
        }
        this.updateInstrumentBasicFields(oldInstrument, request);
        this.instrumentRepository.save(oldInstrument);
        log.info("Instrumento linim\u00e9trico atualizado com sucesso");
        return this.instrumentRepository.findWithActiveOutputsById(id).orElseThrow(() -> new NotFoundException("Instrumento n\u00e3o encontrado ap\u00f3s atualiza\u00e7\u00e3o"));
    }

    private void validateUniqueAcronymsAcrossComponents(List<InputDTO> inputs, List<ConstantDTO> constants, List<OutputDTO> outputs) {
        String acronym;
        HashMap<String, String> acronymMap = new HashMap<String, String>();
        if (inputs != null) {
            for (InputDTO input : inputs) {
                acronym = input.getAcronym();
                if (acronymMap.containsKey(acronym)) {
                    throw new DuplicateResourceException("Acr\u00f4nimo '" + acronym + "' duplicado: j\u00e1 existe como " + (String)acronymMap.get(acronym));
                }
                acronymMap.put(acronym, "input");
            }
        }
        if (constants != null) {
            for (ConstantDTO constant : constants) {
                acronym = constant.getAcronym();
                if (acronymMap.containsKey(acronym)) {
                    throw new DuplicateResourceException("Acr\u00f4nimo '" + acronym + "' duplicado: j\u00e1 existe como " + (String)acronymMap.get(acronym));
                }
                acronymMap.put(acronym, "constant");
            }
        }
        if (outputs != null) {
            for (OutputDTO output : outputs) {
                acronym = output.getAcronym();
                if (acronymMap.containsKey(acronym)) {
                    throw new DuplicateResourceException("Acr\u00f4nimo '" + acronym + "' duplicado: j\u00e1 existe como " + (String)acronymMap.get(acronym));
                }
                acronymMap.put(acronym, "output");
            }
        }
    }

    private void createLinimetricRulerComponents(InstrumentEntity instrument) {
        MeasurementUnitEntity measurementUnit = (MeasurementUnitEntity)this.measurementUnitRepository.findById(1L).orElseThrow(() -> new NotFoundException("Unidade de medida 'metros' n\u00e3o encontrada com ID: 1"));
        InputEntity input = new InputEntity();
        input.setAcronym("LEI");
        input.setName("Leitura");
        input.setPrecision(6);
        input.setMeasurementUnit(measurementUnit);
        input.setInstrument(instrument);
        this.inputRepository.save(input);
        instrument.getInputs().add(input);
        OutputEntity output = new OutputEntity();
        output.setAcronym("NVL");
        output.setName("Nivel");
        output.setEquation("LEI * 1");
        output.setPrecision(6);
        output.setMeasurementUnit(measurementUnit);
        output.setActive(true);
        output.setInstrument(instrument);
        this.outputRepository.save(output);
        instrument.getOutputs().add(output);
        log.info("Componentes da r\u00e9gua linim\u00e9trica criados com sucesso para o instrumento ID: {}", (Object)instrument.getId());
    }

    private void updateInstrumentBasicFields(InstrumentEntity instrument, UpdateInstrumentRequest request) {
        DamEntity dam = (DamEntity)this.damRepository.findById(request.getDamId()).orElseThrow(() -> new NotFoundException("Barragem n\u00e3o encontrada com ID: " + request.getDamId()));
        SectionEntity section = null;
        if (request.getSectionId() != null) {
            section = (SectionEntity)this.sectionRepository.findById(request.getSectionId()).orElseThrow(() -> new NotFoundException("Se\u00e7\u00e3o n\u00e3o encontrada com ID: " + request.getSectionId()));
        }
        InstrumentTypeEntity instrumentType = (InstrumentTypeEntity)this.instrumentTypeRepository.findById(request.getInstrumentTypeId()).orElseThrow(() -> new NotFoundException("Tipo de instrumento n\u00e3o encontrado com ID: " + request.getInstrumentTypeId()));
        instrument.setName(request.getName().toUpperCase());
        instrument.setLocation(request.getLocation());
        instrument.setDistanceOffset(request.getDistanceOffset());
        instrument.setLatitude(request.getLatitude());
        instrument.setLongitude(request.getLongitude());
        instrument.setNoLimit(request.getNoLimit());
        instrument.setInstrumentType(instrumentType);
        instrument.setDam(dam);
        instrument.setSection(section);
        instrument.setActiveForSection(request.getActiveForSection());
        if (Boolean.TRUE.equals(instrument.getIsLinimetricRuler())) {
            instrument.setLinimetricRulerCode(request.getLinimetricRulerCode());
        }
    }

    @Transactional
    @CacheEvict(value={"instrumentById", "instrumentWithDetails", "instrumentsByClient", "instrumentsByFilters", "instrumentsByDam", "allInstruments", "instrumentResponseDTO"}, allEntries=true, cacheManager="instrumentCacheManager")
    public void delete(Long id) {
        InstrumentEntity instrument = this.findById(id);
        for (OutputEntity output : instrument.getOutputs()) {
            if (output.getStatisticalLimit() != null) {
                this.statisticalLimitRepository.delete(output.getStatisticalLimit());
            }
            if (output.getDeterministicLimit() == null) continue;
            this.deterministicLimitRepository.delete(output.getDeterministicLimit());
        }
        this.inputRepository.deleteByInstrumentId(id);
        this.constantRepository.deleteByInstrumentId(id);
        this.outputRepository.deleteByInstrumentId(id);
        this.instrumentRepository.delete(instrument);
    }

    @Transactional
    @CacheEvict(value={"instrumentById", "instrumentWithDetails", "instrumentsByClient", "instrumentsByFilters", "instrumentsByDam", "allInstruments", "instrumentResponseDTO"}, allEntries=true, cacheManager="instrumentCacheManager")
    public InstrumentEntity toggleActiveInstrument(Long id, Boolean active) {
        InstrumentEntity instrument = this.findById(id);
        instrument.setActive(active);
        return (InstrumentEntity)this.instrumentRepository.save(instrument);
    }

    @Cacheable(value={"instrumentsByFilters"}, key="#damId + '_' + #instrumentTypeId + '_' + #sectionId + '_' + #active + '_' + #clientId", cacheManager="instrumentCacheManager")
    public List<InstrumentEntity> findByFilters(Long damId, Long instrumentTypeId, Long sectionId, Boolean active, Long clientId) {
        log.debug("Cache miss: findByFilters({}, {}, {}, {}, {})", new Object[]{damId, instrumentTypeId, sectionId, active, clientId});
        return this.instrumentRepository.findByFiltersOptimized(damId, instrumentTypeId, sectionId, active, clientId);
    }

    private void validateEquation(String equation, Set<String> inputAcronyms, Set<String> constantAcronyms) {
        String cleanEquation = equation.replaceAll("\\s+", "");
        Pattern pattern = Pattern.compile("[A-Za-z][A-Za-z0-9_]*");
        Matcher matcher = pattern.matcher(cleanEquation);
        HashSet<Object> variablesInEquation = new HashSet<Object>();
        while (matcher.find()) {
            String var = matcher.group();
            if (this.isKnownMathFunction(var)) continue;
            variablesInEquation.add(var);
        }
        for (String string : variablesInEquation) {
            if (inputAcronyms.contains(string) || constantAcronyms.contains(string)) continue;
            throw new InvalidInputException("Vari\u00e1vel '" + string + "' na equa\u00e7\u00e3o n\u00e3o existe como input ou constante. Verifique se voc\u00ea n\u00e3o alterou o acr\u00f4nimo de um input ou constante utilizado nesta equa\u00e7\u00e3o.");
        }
        try {
            ExpressionEvaluator.validateSyntax(cleanEquation);
        }
        catch (Exception e) {
            throw new InvalidInputException("Erro de sintaxe na equa\u00e7\u00e3o: " + e.getMessage());
        }
    }

    private boolean isKnownMathFunction(String name) {
        Set<String> mathFunctions = Set.of("sin", "cos", "tan", "asin", "acos", "atan", "atan2", "sinh", "cosh", "tanh", "exp", "log", "log10", "pow", "sqrt", "cbrt", "abs", "min", "max", "floor", "ceil", "round");
        return mathFunctions.contains(name.toLowerCase());
    }

    private void processInputsForUpdate(InstrumentEntity instrument, List<InputDTO> inputDTOs, Map<String, InputEntity> existingInputsByAcronym) {
        HashSet<String> acronyms = new HashSet<String>();
        HashSet<String> names = new HashSet<String>();
        int updatedCount = 0;
        int createdCount = 0;
        boolean significantChange = false;
        for (InputDTO inputDTO : inputDTOs) {
            if (!acronyms.add(inputDTO.getAcronym())) {
                throw new DuplicateResourceException("Sigla de input duplicada: " + inputDTO.getAcronym());
            }
            if (!names.add(inputDTO.getName())) {
                throw new DuplicateResourceException("Nome de input duplicado: " + inputDTO.getName());
            }
            MeasurementUnitEntity measurementUnit = (MeasurementUnitEntity)this.measurementUnitRepository.findById(inputDTO.getMeasurementUnitId()).orElseThrow(() -> new NotFoundException("Unidade de medida n\u00e3o encontrada com ID: " + inputDTO.getMeasurementUnitId()));
            InputEntity input = existingInputsByAcronym.get(inputDTO.getAcronym());
            if (input != null) {
                boolean unitChanged;
                String originalName = input.getName();
                Integer originalPrecision = input.getPrecision();
                Long originalUnitId = input.getMeasurementUnit().getId();
                input.setName(inputDTO.getName());
                input.setPrecision(inputDTO.getPrecision());
                input.setMeasurementUnit(measurementUnit);
                this.inputRepository.save(input);
                instrument.getInputs().add(input);
                existingInputsByAcronym.remove(inputDTO.getAcronym());
                ++updatedCount;
                boolean nameChanged = !originalName.equals(inputDTO.getName());
                boolean precisionChanged = !originalPrecision.equals(inputDTO.getPrecision());
                boolean bl = unitChanged = !originalUnitId.equals(inputDTO.getMeasurementUnitId());
                if (!nameChanged && !precisionChanged && !unitChanged) continue;
                significantChange = true;
                log.info("Mudan\u00e7a significativa detectada no input '{}': nome={}, precis\u00e3o={}, unidade={}", new Object[]{input.getAcronym(), nameChanged, precisionChanged, unitChanged});
                continue;
            }
            input = new InputEntity();
            input.setAcronym(inputDTO.getAcronym().toUpperCase());
            input.setName(inputDTO.getName());
            input.setPrecision(inputDTO.getPrecision());
            input.setMeasurementUnit(measurementUnit);
            input.setInstrument(instrument);
            this.inputRepository.save(input);
            instrument.getInputs().add(input);
            ++createdCount;
            significantChange = true;
        }
        if (!existingInputsByAcronym.isEmpty()) {
            significantChange = true;
        }
        if (significantChange) {
            instrument.setLastUpdateVariablesDate(LocalDateTime.now());
            log.info("Atualizada data de modifica\u00e7\u00e3o de vari\u00e1veis do instrumento ID: {} devido a mudan\u00e7as nos inputs", (Object)instrument.getId());
        }
        log.info("Inputs processados: {} atualizados, {} criados", (Object)updatedCount, (Object)createdCount);
    }

    private void processConstantsForUpdate(InstrumentEntity instrument, List<ConstantDTO> constantDTOs, Map<String, ConstantEntity> existingConstantsByAcronym) {
        HashSet<String> acronyms = new HashSet<String>();
        HashSet<String> names = new HashSet<String>();
        int updatedCount = 0;
        int createdCount = 0;
        boolean significantChange = false;
        for (ConstantDTO constantDTO : constantDTOs) {
            if (!acronyms.add(constantDTO.getAcronym())) {
                throw new DuplicateResourceException("Sigla de constante duplicada: " + constantDTO.getAcronym());
            }
            if (!names.add(constantDTO.getName())) {
                throw new DuplicateResourceException("Nome de constante duplicado: " + constantDTO.getName());
            }
            MeasurementUnitEntity measurementUnit = (MeasurementUnitEntity)this.measurementUnitRepository.findById(constantDTO.getMeasurementUnitId()).orElseThrow(() -> new NotFoundException("Unidade de medida n\u00e3o encontrada com ID: " + constantDTO.getMeasurementUnitId()));
            ConstantEntity constant = existingConstantsByAcronym.get(constantDTO.getAcronym());
            if (constant != null) {
                boolean unitChanged;
                String originalName = constant.getName();
                Integer originalPrecision = constant.getPrecision();
                Double originalValue = constant.getValue();
                Long originalUnitId = constant.getMeasurementUnit().getId();
                constant.setName(constantDTO.getName());
                constant.setPrecision(constantDTO.getPrecision());
                constant.setValue(constantDTO.getValue());
                constant.setMeasurementUnit(measurementUnit);
                this.constantRepository.save(constant);
                instrument.getConstants().add(constant);
                existingConstantsByAcronym.remove(constantDTO.getAcronym());
                ++updatedCount;
                boolean nameChanged = !originalName.equals(constantDTO.getName());
                boolean precisionChanged = !originalPrecision.equals(constantDTO.getPrecision());
                boolean valueChanged = !originalValue.equals(constantDTO.getValue());
                boolean bl = unitChanged = !originalUnitId.equals(constantDTO.getMeasurementUnitId());
                if (!nameChanged && !precisionChanged && !valueChanged && !unitChanged) continue;
                significantChange = true;
                log.info("Mudan\u00e7a significativa detectada na constant '{}': nome={}, precis\u00e3o={}, valor={}, unidade={}", new Object[]{constant.getAcronym(), nameChanged, precisionChanged, valueChanged, unitChanged});
                continue;
            }
            constant = new ConstantEntity();
            constant.setAcronym(constantDTO.getAcronym().toUpperCase());
            constant.setName(constantDTO.getName());
            constant.setPrecision(constantDTO.getPrecision());
            constant.setValue(constantDTO.getValue());
            constant.setMeasurementUnit(measurementUnit);
            constant.setInstrument(instrument);
            this.constantRepository.save(constant);
            instrument.getConstants().add(constant);
            ++createdCount;
            significantChange = true;
        }
        if (!existingConstantsByAcronym.isEmpty()) {
            significantChange = true;
        }
        if (significantChange) {
            instrument.setLastUpdateVariablesDate(LocalDateTime.now());
        }
        log.info("Constants processadas: {} atualizadas, {} criadas", (Object)updatedCount, (Object)createdCount);
    }

    private void processOutputsForUpdate(InstrumentEntity instrument, List<OutputDTO> outputDTOs, Map<String, OutputEntity> existingOutputsByAcronym) {
        Object output;
        HashSet<String> acronyms = new HashSet<String>();
        HashSet<String> names = new HashSet<String>();
        Set<String> inputAcronyms = instrument.getInputs().stream().map(InputEntity::getAcronym).collect(Collectors.toSet());
        Set<String> constantAcronyms = instrument.getConstants().stream().map(ConstantEntity::getAcronym).collect(Collectors.toSet());
        int updatedCount = 0;
        int createdCount = 0;
        boolean significantChange = false;
        if (!instrument.getNoLimit().booleanValue() && outputDTOs.size() > 1) {
            boolean hasStatistical = outputDTOs.get(0).getStatisticalLimit() != null;
            String firstLimitType = hasStatistical ? "estat\u00edstico" : "determin\u00edstico";
            for (int i = 1; i < outputDTOs.size(); ++i) {
                boolean currentHasStatistical;
                output = outputDTOs.get(i);
                boolean bl = currentHasStatistical = ((OutputDTO)output).getStatisticalLimit() != null;
                if (hasStatistical == currentHasStatistical) continue;
                throw new InvalidInputException("Todos os outputs de um instrumento devem ter o mesmo tipo de limite. O primeiro output usa limite " + firstLimitType + ", mas o output '" + ((OutputDTO)output).getName() + "' usa um tipo diferente.");
            }
        }
        for (OutputDTO outputDTO : outputDTOs) {
            boolean emergencyChanged;
            Object limit;
            boolean unitChanged;
            if (!acronyms.add(outputDTO.getAcronym())) {
                throw new DuplicateResourceException("Sigla de output duplicada: " + outputDTO.getAcronym());
            }
            if (!names.add(outputDTO.getName())) {
                throw new DuplicateResourceException("Nome de output duplicado: " + outputDTO.getName());
            }
            this.validateEquation(outputDTO.getEquation(), inputAcronyms, constantAcronyms);
            this.validateOutputRequest(outputDTO, instrument.getNoLimit());
            MeasurementUnitEntity measurementUnit = (MeasurementUnitEntity)this.measurementUnitRepository.findById(outputDTO.getMeasurementUnitId()).orElseThrow(() -> new NotFoundException("Unidade de medida n\u00e3o encontrada com ID: " + outputDTO.getMeasurementUnitId()));
            output = existingOutputsByAcronym.get(outputDTO.getAcronym());
            if (output == null) {
                significantChange = true;
                output = new OutputEntity();
                ((OutputEntity)output).setAcronym(outputDTO.getAcronym().toUpperCase());
                ((OutputEntity)output).setName(outputDTO.getName());
                ((OutputEntity)output).setEquation(outputDTO.getEquation());
                ((OutputEntity)output).setPrecision(outputDTO.getPrecision());
                ((OutputEntity)output).setMeasurementUnit(measurementUnit);
                ((OutputEntity)output).setActive(true);
                ((OutputEntity)output).setInstrument(instrument);
                OutputEntity savedOutput = (OutputEntity)this.outputRepository.save(output);
                if (!instrument.getNoLimit().booleanValue()) {
                    if (outputDTO.getStatisticalLimit() != null) {
                        StatisticalLimitEntity statisticalLimit = new StatisticalLimitEntity();
                        statisticalLimit.setOutput(savedOutput);
                        statisticalLimit.setLowerValue(outputDTO.getStatisticalLimit().getLowerValue());
                        statisticalLimit.setUpperValue(outputDTO.getStatisticalLimit().getUpperValue());
                        this.statisticalLimitRepository.save(statisticalLimit);
                        savedOutput.setStatisticalLimit(statisticalLimit);
                    }
                    if (outputDTO.getDeterministicLimit() != null) {
                        DeterministicLimitEntity deterministicLimit = new DeterministicLimitEntity();
                        deterministicLimit.setOutput(savedOutput);
                        deterministicLimit.setAttentionValue(outputDTO.getDeterministicLimit().getAttentionValue());
                        deterministicLimit.setAlertValue(outputDTO.getDeterministicLimit().getAlertValue());
                        deterministicLimit.setEmergencyValue(outputDTO.getDeterministicLimit().getEmergencyValue());
                        this.deterministicLimitRepository.save(deterministicLimit);
                        savedOutput.setDeterministicLimit(deterministicLimit);
                    }
                }
                instrument.getOutputs().add(savedOutput);
                ++createdCount;
                continue;
            }
            boolean nameChanged = !((OutputEntity)output).getName().equals(outputDTO.getName());
            boolean equationChanged = !((OutputEntity)output).getEquation().equals(outputDTO.getEquation());
            boolean precisionChanged = !((OutputEntity)output).getPrecision().equals(outputDTO.getPrecision());
            boolean bl = unitChanged = !((OutputEntity)output).getMeasurementUnit().getId().equals(outputDTO.getMeasurementUnitId());
            if (nameChanged || equationChanged || precisionChanged || unitChanged) {
                significantChange = true;
            }
            ((OutputEntity)output).setName(outputDTO.getName());
            ((OutputEntity)output).setEquation(outputDTO.getEquation());
            ((OutputEntity)output).setPrecision(outputDTO.getPrecision());
            ((OutputEntity)output).setMeasurementUnit(measurementUnit);
            ((OutputEntity)output).setActive(true);
            if (instrument.getNoLimit().booleanValue()) {
                if (((OutputEntity)output).getStatisticalLimit() != null) {
                    this.statisticalLimitRepository.delete(((OutputEntity)output).getStatisticalLimit());
                    ((OutputEntity)output).setStatisticalLimit(null);
                }
                if (((OutputEntity)output).getDeterministicLimit() != null) {
                    this.deterministicLimitRepository.delete(((OutputEntity)output).getDeterministicLimit());
                    ((OutputEntity)output).setDeterministicLimit(null);
                }
            } else if (outputDTO.getStatisticalLimit() != null) {
                if (((OutputEntity)output).getDeterministicLimit() != null) {
                    this.deterministicLimitRepository.delete(((OutputEntity)output).getDeterministicLimit());
                    ((OutputEntity)output).setDeterministicLimit(null);
                }
                if (((OutputEntity)output).getStatisticalLimit() != null) {
                    ((OutputEntity)output).getStatisticalLimit().setLowerValue(outputDTO.getStatisticalLimit().getLowerValue());
                    ((OutputEntity)output).getStatisticalLimit().setUpperValue(outputDTO.getStatisticalLimit().getUpperValue());
                } else {
                    StatisticalLimitEntity statisticalLimit = new StatisticalLimitEntity();
                    statisticalLimit.setOutput((OutputEntity)output);
                    statisticalLimit.setLowerValue(outputDTO.getStatisticalLimit().getLowerValue());
                    statisticalLimit.setUpperValue(outputDTO.getStatisticalLimit().getUpperValue());
                    this.statisticalLimitRepository.save(statisticalLimit);
                    ((OutputEntity)output).setStatisticalLimit(statisticalLimit);
                }
            } else if (outputDTO.getDeterministicLimit() != null) {
                if (((OutputEntity)output).getStatisticalLimit() != null) {
                    this.statisticalLimitRepository.delete(((OutputEntity)output).getStatisticalLimit());
                    ((OutputEntity)output).setStatisticalLimit(null);
                }
                if (((OutputEntity)output).getDeterministicLimit() != null) {
                    ((OutputEntity)output).getDeterministicLimit().setAttentionValue(outputDTO.getDeterministicLimit().getAttentionValue());
                    ((OutputEntity)output).getDeterministicLimit().setAlertValue(outputDTO.getDeterministicLimit().getAlertValue());
                    ((OutputEntity)output).getDeterministicLimit().setEmergencyValue(outputDTO.getDeterministicLimit().getEmergencyValue());
                } else {
                    DeterministicLimitEntity deterministicLimit = new DeterministicLimitEntity();
                    deterministicLimit.setOutput((OutputEntity)output);
                    deterministicLimit.setAttentionValue(outputDTO.getDeterministicLimit().getAttentionValue());
                    deterministicLimit.setAlertValue(outputDTO.getDeterministicLimit().getAlertValue());
                    deterministicLimit.setEmergencyValue(outputDTO.getDeterministicLimit().getEmergencyValue());
                    this.deterministicLimitRepository.save(deterministicLimit);
                    ((OutputEntity)output).setDeterministicLimit(deterministicLimit);
                }
            }
            this.outputRepository.save(output);
            existingOutputsByAcronym.remove(((OutputEntity)output).getAcronym());
            ++updatedCount;
            if (((OutputEntity)output).getStatisticalLimit() != null && outputDTO.getStatisticalLimit() != null) {
                boolean upperChanged;
                limit = ((OutputEntity)output).getStatisticalLimit();
                boolean lowerChanged = !((StatisticalLimitEntity)limit).getLowerValue().equals(outputDTO.getStatisticalLimit().getLowerValue());
                boolean bl2 = upperChanged = !((StatisticalLimitEntity)limit).getUpperValue().equals(outputDTO.getStatisticalLimit().getUpperValue());
                if (lowerChanged || upperChanged) {
                    significantChange = true;
                }
            }
            if (((OutputEntity)output).getDeterministicLimit() == null || outputDTO.getDeterministicLimit() == null) continue;
            limit = ((OutputEntity)output).getDeterministicLimit();
            boolean attentionChanged = !((DeterministicLimitEntity)limit).getAttentionValue().equals(outputDTO.getDeterministicLimit().getAttentionValue());
            boolean alertChanged = !((DeterministicLimitEntity)limit).getAlertValue().equals(outputDTO.getDeterministicLimit().getAlertValue());
            boolean bl3 = emergencyChanged = !((DeterministicLimitEntity)limit).getEmergencyValue().equals(outputDTO.getDeterministicLimit().getEmergencyValue());
            if (!attentionChanged && !alertChanged && !emergencyChanged) continue;
            significantChange = true;
        }
        for (OutputEntity unusedOutput : existingOutputsByAcronym.values()) {
            unusedOutput.setActive(false);
            this.outputRepository.save(unusedOutput);
        }
        if (!existingOutputsByAcronym.isEmpty()) {
            significantChange = true;
        }
        if (significantChange) {
            instrument.setLastUpdateVariablesDate(LocalDateTime.now());
            log.info("Atualizada data de modifica\u00e7\u00e3o de vari\u00e1veis do instrumento ID: {} devido a mudan\u00e7as nos outputs", (Object)instrument.getId());
        }
        log.info("Outputs processados: {} atualizados, {} criados, {} desativados", new Object[]{updatedCount, createdCount, existingOutputsByAcronym.size()});
    }

    private void deleteUnusedComponents(Map<String, InputEntity> unusedInputs, Map<String, ConstantEntity> unusedConstants) {
        InstrumentEntity instrument;
        for (InputEntity input : unusedInputs.values()) {
            instrument = input.getInstrument();
            instrument.getInputs().remove(input);
            input.setInstrument(null);
            input.setMeasurementUnit(null);
            this.inputRepository.delete(input);
        }
        for (ConstantEntity constant : unusedConstants.values()) {
            instrument = constant.getInstrument();
            instrument.getConstants().remove(constant);
            constant.setInstrument(null);
            constant.setMeasurementUnit(null);
            this.constantRepository.delete(constant);
        }
    }

    @Transactional
    @CacheEvict(value={"instrumentById", "instrumentWithDetails", "instrumentsByClient", "instrumentsByFilters", "instrumentsByDam", "allInstruments", "instrumentResponseDTO"}, allEntries=true, cacheManager="instrumentCacheManager")
    public InstrumentEntity toggleSectionVisibility(Long id, Boolean active) {
        InstrumentEntity instrument = this.findById(id);
        instrument.setActiveForSection(active);
        return (InstrumentEntity)this.instrumentRepository.save(instrument);
    }

    @Cacheable(value={"instrumentResponseDTO"}, key="#instrument.id", cacheManager="instrumentCacheManager")
    public InstrumentResponseDTO mapToResponseDTO(InstrumentEntity instrument) {
        InstrumentResponseDTO dto = new InstrumentResponseDTO();
        dto.setId(instrument.getId());
        dto.setName(instrument.getName());
        dto.setLocation(instrument.getLocation());
        dto.setDistanceOffset(instrument.getDistanceOffset());
        dto.setLatitude(instrument.getLatitude());
        dto.setLongitude(instrument.getLongitude());
        dto.setNoLimit(instrument.getNoLimit());
        dto.setActive(instrument.getActive());
        dto.setIsLinimetricRuler(instrument.getIsLinimetricRuler());
        dto.setLinimetricRulerCode(instrument.getLinimetricRulerCode());
        dto.setLastUpdateVariablesDate(instrument.getLastUpdateVariablesDate());
        DamEntity dam = instrument.getDam();
        dto.setDamId(dam.getId());
        dto.setDamName(dam.getName());
        InstrumentTypeEntity type = instrument.getInstrumentType();
        dto.setInstrumentTypeId(type.getId());
        dto.setInstrumentType(type.getName());
        SectionEntity section = instrument.getSection();
        if (section != null) {
            dto.setSectionId(section.getId());
            dto.setSectionName(section.getName());
        }
        dto.setActiveForSection(instrument.getActiveForSection());
        ArrayList<InputDTO> inputDTOs = new ArrayList<InputDTO>(instrument.getInputs().size());
        for (InputEntity inputEntity : instrument.getInputs()) {
            InputDTO inputDTO = new InputDTO();
            inputDTO.setId(inputEntity.getId());
            inputDTO.setAcronym(inputEntity.getAcronym());
            inputDTO.setName(inputEntity.getName());
            inputDTO.setPrecision(inputEntity.getPrecision());
            MeasurementUnitEntity unit = inputEntity.getMeasurementUnit();
            inputDTO.setMeasurementUnitId(unit.getId());
            inputDTO.setMeasurementUnitName(unit.getName());
            inputDTO.setMeasurementUnitAcronym(unit.getAcronym());
            inputDTOs.add(inputDTO);
        }
        dto.setInputs(inputDTOs);
        ArrayList<ConstantDTO> constantDTOs = new ArrayList<ConstantDTO>(instrument.getConstants().size());
        for (ConstantEntity constant : instrument.getConstants()) {
            ConstantDTO constantDTO = new ConstantDTO();
            constantDTO.setId(constant.getId());
            constantDTO.setAcronym(constant.getAcronym());
            constantDTO.setName(constant.getName());
            constantDTO.setPrecision(constant.getPrecision());
            constantDTO.setValue(constant.getValue());
            MeasurementUnitEntity unit = constant.getMeasurementUnit();
            constantDTO.setMeasurementUnitId(unit.getId());
            constantDTO.setMeasurementUnitName(unit.getName());
            constantDTO.setMeasurementUnitAcronym(unit.getAcronym());
            constantDTOs.add(constantDTO);
        }
        dto.setConstants(constantDTOs);
        List list = instrument.getOutputs().stream().filter(OutputEntity::getActive).collect(Collectors.toList());
        ArrayList<OutputDTO> outputDTOs = new ArrayList<OutputDTO>(list.size());
        for (OutputEntity output : list) {
            DeterministicLimitEntity detLimit;
            OutputDTO outputDTO = new OutputDTO();
            outputDTO.setId(output.getId());
            outputDTO.setAcronym(output.getAcronym());
            outputDTO.setName(output.getName());
            outputDTO.setEquation(output.getEquation());
            outputDTO.setPrecision(output.getPrecision());
            MeasurementUnitEntity unit = output.getMeasurementUnit();
            outputDTO.setMeasurementUnitId(unit.getId());
            outputDTO.setMeasurementUnitName(unit.getName());
            outputDTO.setMeasurementUnitAcronym(unit.getAcronym());
            StatisticalLimitEntity statLimit = output.getStatisticalLimit();
            if (statLimit != null) {
                StatisticalLimitDTO limitDTO = new StatisticalLimitDTO();
                limitDTO.setId(statLimit.getId());
                limitDTO.setLowerValue(statLimit.getLowerValue());
                limitDTO.setUpperValue(statLimit.getUpperValue());
                outputDTO.setStatisticalLimit(limitDTO);
            }
            if ((detLimit = output.getDeterministicLimit()) != null) {
                DeterministicLimitDTO limitDTO = new DeterministicLimitDTO();
                limitDTO.setId(detLimit.getId());
                limitDTO.setAttentionValue(detLimit.getAttentionValue());
                limitDTO.setAlertValue(detLimit.getAlertValue());
                limitDTO.setEmergencyValue(detLimit.getEmergencyValue());
                outputDTO.setDeterministicLimit(limitDTO);
            }
            outputDTOs.add(outputDTO);
        }
        dto.setOutputs(outputDTOs);
        return dto;
    }

    public List<InstrumentResponseDTO> mapToResponseDTOList(List<InstrumentEntity> instruments) {
        return instruments.stream().map(this::mapToResponseDTO).collect(Collectors.toList());
    }

    @Generated
    public InstrumentService(InstrumentRepository instrumentRepository, DamRepository damRepository, SectionRepository sectionRepository, MeasurementUnitRepository measurementUnitRepository, StatisticalLimitRepository statisticalLimitRepository, DeterministicLimitRepository deterministicLimitRepository, InputRepository inputRepository, ConstantRepository constantRepository, OutputRepository outputRepository, InstrumentTypeRepository instrumentTypeRepository, ApplicationEventPublisher eventPublisher) {
        this.instrumentRepository = instrumentRepository;
        this.damRepository = damRepository;
        this.sectionRepository = sectionRepository;
        this.measurementUnitRepository = measurementUnitRepository;
        this.statisticalLimitRepository = statisticalLimitRepository;
        this.deterministicLimitRepository = deterministicLimitRepository;
        this.inputRepository = inputRepository;
        this.constantRepository = constantRepository;
        this.outputRepository = outputRepository;
        this.instrumentTypeRepository = instrumentTypeRepository;
        this.eventPublisher = eventPublisher;
    }
}

