/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.input.services;

import com.geosegbar.entities.InputEntity;
import com.geosegbar.exceptions.NotFoundException;
import com.geosegbar.infra.input.persistence.jpa.InputRepository;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InputService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InputService.class);
    private final InputRepository inputRepository;

    public List<InputEntity> findByInstrumentId(Long instrumentId) {
        return this.inputRepository.findByInstrumentId(instrumentId);
    }

    public InputEntity findById(Long id) {
        return (InputEntity)this.inputRepository.findById(id).orElseThrow(() -> new NotFoundException("Input n\u00e3o encontrado com ID: " + id));
    }

    @Transactional
    public void deleteById(Long id) {
        InputEntity input = this.findById(id);
        this.inputRepository.delete(input);
        log.info("Input exclu\u00eddo: {}", (Object)input.getName());
    }

    @Generated
    public InputService(InputRepository inputRepository) {
        this.inputRepository = inputRepository;
    }
}

