/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.hydrotelemetric.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.geosegbar.common.response.AnaAuthResponse;
import com.geosegbar.common.response.AnaTelemetryResponse;
import com.geosegbar.exceptions.ExternalApiException;
import java.io.IOException;
import java.time.LocalDate;
import java.util.List;
import lombok.Generated;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

@Service
public class AnaApiService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AnaApiService.class);
    @Value(value="${ana.api.identifier}")
    private String apiIdentifier;
    @Value(value="${ana.api.password}")
    private String apiPassword;
    @Value(value="${ana.api.auth-url}")
    private String authUrl;
    @Value(value="${ana.api.telemetry-url}")
    private String telemetryUrl;
    private final WebClient webClient;
    private final ObjectMapper objectMapper;

    public String getAuthToken() {
        try {
            for (int attempt = 1; attempt <= 3; ++attempt) {
                try {
                    AnaAuthResponse response = (AnaAuthResponse)this.webClient.get().uri(this.authUrl, new Object[0]).header("Identificador", new String[]{this.apiIdentifier}).header("Senha", new String[]{this.apiPassword}).accept(new MediaType[]{MediaType.APPLICATION_JSON}).retrieve().onStatus(status -> status.is4xxClientError() || status.is5xxServerError(), clientResponse -> clientResponse.bodyToMono(String.class).flatMap(errorBody -> Mono.error((Throwable)new ExternalApiException("Erro ao obter token da API da ANA: " + errorBody)))).bodyToMono(AnaAuthResponse.class).block();
                    if (response == null || response.getItems() == null || response.getItems().getTokenautenticacao() == null) {
                        throw new ExternalApiException("Resposta da API da ANA inv\u00e1lida ou sem token");
                    }
                    log.info("Token de autentica\u00e7\u00e3o obtido com sucesso");
                    return response.getItems().getTokenautenticacao();
                }
                catch (Exception e) {
                    if (attempt == 3) {
                        throw e;
                    }
                    log.warn("Tentativa {} falhou, tentando novamente em {} segundos", (Object)attempt, (Object)(attempt * 2));
                    continue;
                }
            }
            throw new ExternalApiException("Todas as tentativas de obter token falharam");
        }
        catch (Exception e) {
            log.error("Erro ao obter token de autentica\u00e7\u00e3o", (Throwable)e);
            throw new ExternalApiException("Falha ao obter token de autentica\u00e7\u00e3o: " + e.getMessage(), e);
        }
    }

    public List<AnaTelemetryResponse.TelemetryItem> getTelemetryData(String stationCode, String authToken) {
        List<AnaTelemetryResponse.TelemetryItem> list;
        block10: {
            CloseableHttpClient httpClient = HttpClients.createDefault();
            try {
                String url = this.telemetryUrl + "?C%C3%B3digo%20da%20Esta%C3%A7%C3%A3o=" + stationCode + "&Tipo%20Filtro%20Data=DATA_LEITURA&Range%20Intervalo%20de%20busca=DIAS_2";
                HttpGet request = new HttpGet(url);
                request.setHeader("Authorization", "Bearer " + authToken);
                request.setHeader("Accept", "*/*");
                request.setHeader("User-Agent", "Mozilla/5.0");
                request.setHeader("Content-Type", "application/json");
                request.setHeader("Host", "www.ana.gov.br");
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
                HttpEntity entity = response.getEntity();
                if (response.getStatusLine().getStatusCode() != 200) {
                    String errorBody = EntityUtils.toString((HttpEntity)entity);
                    log.error("Erro na resposta da API: {} - {}", (Object)response.getStatusLine().getStatusCode(), (Object)errorBody);
                    throw new ExternalApiException("Erro ao obter dados de telemetria: " + errorBody);
                }
                String responseBody = EntityUtils.toString((HttpEntity)entity);
                AnaTelemetryResponse telemetryResponse = (AnaTelemetryResponse)this.objectMapper.readValue(responseBody, AnaTelemetryResponse.class);
                if (telemetryResponse == null || telemetryResponse.getItems() == null) {
                    throw new ExternalApiException("Resposta da API da ANA inv\u00e1lida ou sem itens");
                }
                list = telemetryResponse.getItems();
                if (httpClient == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (httpClient != null) {
                        try {
                            httpClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.error("Erro ao obter dados de telemetria para esta\u00e7\u00e3o: {}", (Object)stationCode, (Object)e);
                    throw new ExternalApiException("Falha ao obter dados de telemetria: " + e.getMessage(), e);
                }
            }
            httpClient.close();
        }
        return list;
    }

    public Double calculateAverageLevel(List<AnaTelemetryResponse.TelemetryItem> items, LocalDate date) {
        if (items == null || items.isEmpty()) {
            return null;
        }
        String dateStr = date.toString();
        return items.stream().filter(item -> item.getDataHoraMedicao() != null && item.getDataHoraMedicao().startsWith(dateStr)).filter(item -> item.getCotaAdotada() != null && !item.getCotaAdotada().isEmpty()).mapToDouble(item -> {
            try {
                return Double.parseDouble(item.getCotaAdotada());
            }
            catch (NumberFormatException e) {
                log.warn("Valor de cota inv\u00e1lido: {}", (Object)item.getCotaAdotada());
                return 0.0;
            }
        }).average().orElse(0.0);
    }

    @Generated
    public AnaApiService(WebClient webClient, ObjectMapper objectMapper) {
        this.webClient = webClient;
        this.objectMapper = objectMapper;
    }
}

