/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.answer_photo.web;

import com.geosegbar.common.response.WebResponseEntity;
import com.geosegbar.entities.AnswerPhotoEntity;
import com.geosegbar.infra.answer_photo.services.AnswerPhotoService;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/answer-photos"})
public class AnswerPhotoController {
    private final AnswerPhotoService answerPhotoService;

    @GetMapping
    public ResponseEntity<WebResponseEntity<List<AnswerPhotoEntity>>> getAllAnswerPhotos() {
        List<AnswerPhotoEntity> photos = this.answerPhotoService.findAll();
        WebResponseEntity<List<AnswerPhotoEntity>> response = WebResponseEntity.success(photos, "Fotos de resposta obtidas com sucesso!");
        return ResponseEntity.ok(response);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<AnswerPhotoEntity>> getAnswerPhotoById(@PathVariable Long id) {
        AnswerPhotoEntity photo = this.answerPhotoService.findById(id);
        WebResponseEntity<AnswerPhotoEntity> response = WebResponseEntity.success(photo, "Foto de resposta obtida com sucesso!");
        return ResponseEntity.ok(response);
    }

    @GetMapping(value={"/answer/{answerId}"})
    public ResponseEntity<WebResponseEntity<List<AnswerPhotoEntity>>> getAnswerPhotosByAnswerId(@PathVariable Long answerId) {
        List<AnswerPhotoEntity> photos = this.answerPhotoService.findByAnswerId(answerId);
        WebResponseEntity<List<AnswerPhotoEntity>> response = WebResponseEntity.success(photos, "Fotos da resposta obtidas com sucesso!");
        return ResponseEntity.ok(response);
    }

    @PostMapping(value={"/upload"}, consumes={"multipart/form-data"})
    public ResponseEntity<WebResponseEntity<AnswerPhotoEntity>> uploadAnswerPhoto(@RequestParam(value="answerId") Long answerId, @RequestParam(value="photo") MultipartFile photo) {
        AnswerPhotoEntity created = this.answerPhotoService.savePhoto(answerId, photo);
        WebResponseEntity<AnswerPhotoEntity> response = WebResponseEntity.success(created, "Foto de resposta criada com sucesso!");
        return new ResponseEntity(response, (HttpStatusCode)HttpStatus.CREATED);
    }

    @PutMapping(value={"/{id}"}, consumes={"multipart/form-data"})
    public ResponseEntity<WebResponseEntity<AnswerPhotoEntity>> updateAnswerPhoto(@PathVariable Long id, @RequestParam(value="photo") MultipartFile photo) {
        AnswerPhotoEntity updated = this.answerPhotoService.updatePhoto(id, photo);
        WebResponseEntity<AnswerPhotoEntity> response = WebResponseEntity.success(updated, "Foto de resposta atualizada com sucesso!");
        return ResponseEntity.ok(response);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<Void>> deleteAnswerPhoto(@PathVariable Long id) {
        this.answerPhotoService.deleteById(id);
        WebResponseEntity<Object> response = WebResponseEntity.success(null, "Foto de resposta exclu\u00edda com sucesso!");
        return ResponseEntity.ok(response);
    }

    @Generated
    public AnswerPhotoController(AnswerPhotoService answerPhotoService) {
        this.answerPhotoService = answerPhotoService;
    }
}

