/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.entities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.geosegbar.common.objects_values.UserCreatorInfo;
import com.geosegbar.entities.AttributionsPermissionEntity;
import com.geosegbar.entities.ClientEntity;
import com.geosegbar.entities.DamPermissionEntity;
import com.geosegbar.entities.DocumentationPermissionEntity;
import com.geosegbar.entities.InstrumentationPermissionEntity;
import com.geosegbar.entities.PSBFileEntity;
import com.geosegbar.entities.PSBFolderEntity;
import com.geosegbar.entities.ReadingEntity;
import com.geosegbar.entities.RoleEntity;
import com.geosegbar.entities.RoutineInspectionPermissionEntity;
import com.geosegbar.entities.SexEntity;
import com.geosegbar.entities.ShareFolderEntity;
import com.geosegbar.entities.StatusEntity;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.validation.constraints.Email;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;

@Entity
@Table(name="users", indexes={@Index(name="idx_user_email", columnList="email", unique=true), @Index(name="idx_user_phone", columnList="phone"), @Index(name="idx_user_email_status", columnList="email, status_id"), @Index(name="idx_user_role_status", columnList="role_id, status_id"), @Index(name="idx_user_created_by", columnList="created_by_id"), @Index(name="idx_user_status", columnList="status_id"), @Index(name="idx_user_role", columnList="role_id"), @Index(name="idx_user_sex", columnList="sex_id"), @Index(name="idx_user_first_access", columnList="is_first_access"), @Index(name="idx_user_token_expiry", columnList="token_expiry_date"), @Index(name="idx_user_id_name", columnList="id, name"), @Index(name="idx_user_status_role", columnList="status_id, role_id"), @Index(name="idx_user_created_by_status", columnList="created_by_id, status_id"), @Index(name="idx_user_first_access_status", columnList="is_first_access, status_id"), @Index(name="idx_user_name_id", columnList="name, id"), @Index(name="idx_user_name_status", columnList="name, status_id")})
public class UserEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @NotBlank(message="Nome \u00e9 obrigat\u00f3rio!")
    @Column(nullable=false)
    private @NotBlank(message="Nome \u00e9 obrigat\u00f3rio!") String name;
    @NotBlank(message="Email \u00e9 obrigat\u00f3rio!")
    @Email(message="Email inv\u00e1lido!")
    @Column(nullable=false, unique=true)
    private @NotBlank(message="Email \u00e9 obrigat\u00f3rio!") @Email(message="Email inv\u00e1lido!") String email;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @NotBlank(message="A senha n\u00e3o pode estar em branco!")
    @Size(min=6, message="A senha deve ter pelo menos 6 caracteres!")
    @Column(nullable=false)
    private @NotBlank(message="A senha n\u00e3o pode estar em branco!") @Size(min=6, message="A senha deve ter pelo menos 6 caracteres!") String password;
    @Column(nullable=true, length=11)
    private String phone;
    @NotNull(message="O sexo deve ser informado!")
    @ManyToOne
    @JoinColumn(name="sex_id", nullable=false)
    private @NotNull(message="O sexo deve ser informado!") SexEntity sex;
    @ManyToOne
    @JoinColumn(name="status_id", nullable=false)
    private StatusEntity status;
    @ManyToOne
    @JoinColumn(name="role_id", nullable=false)
    @NotNull(message="A role deve ser informada!")
    private @NotNull(message="A role deve ser informada!") RoleEntity role;
    @Column(name="is_first_access")
    private Boolean isFirstAccess = false;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @Column(columnDefinition="TEXT")
    private String lastToken;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @Column
    private LocalDateTime tokenExpiryDate;
    @JsonIgnore
    @OneToMany(mappedBy="user", fetch=FetchType.LAZY)
    private Set<ReadingEntity> readings = new HashSet<ReadingEntity>();
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="user_client", joinColumns={@JoinColumn(name="user_id")}, inverseJoinColumns={@JoinColumn(name="client_id")})
    private Set<ClientEntity> clients = new HashSet<ClientEntity>();
    @JsonIgnore
    @OneToMany(mappedBy="user", fetch=FetchType.LAZY)
    private Set<DamPermissionEntity> damPermissions = new HashSet<DamPermissionEntity>();
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="created_by_id")
    private UserEntity createdBy;
    @JsonIgnore
    @OneToMany(mappedBy="createdBy", fetch=FetchType.LAZY)
    private Set<UserEntity> createdUsers = new HashSet<UserEntity>();
    @JsonIgnore
    @OneToMany(mappedBy="createdBy", fetch=FetchType.LAZY)
    private Set<PSBFolderEntity> psbFoldersCreated = new HashSet<PSBFolderEntity>();
    @JsonIgnore
    @OneToMany(mappedBy="uploadedBy", fetch=FetchType.LAZY)
    private Set<PSBFileEntity> psbFilesUploaded = new HashSet<PSBFileEntity>();
    @JsonIgnore
    @OneToMany(mappedBy="sharedBy", fetch=FetchType.LAZY)
    private Set<ShareFolderEntity> sharedFolders = new HashSet<ShareFolderEntity>();
    @OneToOne(mappedBy="user", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JsonIgnoreProperties(value={"user"})
    private AttributionsPermissionEntity attributionsPermission;
    @OneToOne(mappedBy="user", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JsonIgnoreProperties(value={"user"})
    private DocumentationPermissionEntity documentationPermission;
    @OneToOne(mappedBy="user", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JsonIgnoreProperties(value={"user"})
    private InstrumentationPermissionEntity instrumentationPermission;
    @OneToOne(mappedBy="user", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JsonIgnoreProperties(value={"user"})
    private RoutineInspectionPermissionEntity routineInspectionPermission;

    @JsonProperty(value="createdBy")
    public Object getCreatedByInfo() {
        if (this.createdBy == null) {
            return null;
        }
        return new UserCreatorInfo(this.createdBy.getId(), this.createdBy.getName(), this.createdBy.getEmail());
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getPhone() {
        return this.phone;
    }

    @Generated
    public SexEntity getSex() {
        return this.sex;
    }

    @Generated
    public StatusEntity getStatus() {
        return this.status;
    }

    @Generated
    public RoleEntity getRole() {
        return this.role;
    }

    @Generated
    public Boolean getIsFirstAccess() {
        return this.isFirstAccess;
    }

    @Generated
    public String getLastToken() {
        return this.lastToken;
    }

    @Generated
    public LocalDateTime getTokenExpiryDate() {
        return this.tokenExpiryDate;
    }

    @Generated
    public Set<ReadingEntity> getReadings() {
        return this.readings;
    }

    @Generated
    public Set<ClientEntity> getClients() {
        return this.clients;
    }

    @Generated
    public Set<DamPermissionEntity> getDamPermissions() {
        return this.damPermissions;
    }

    @Generated
    public UserEntity getCreatedBy() {
        return this.createdBy;
    }

    @Generated
    public Set<UserEntity> getCreatedUsers() {
        return this.createdUsers;
    }

    @Generated
    public Set<PSBFolderEntity> getPsbFoldersCreated() {
        return this.psbFoldersCreated;
    }

    @Generated
    public Set<PSBFileEntity> getPsbFilesUploaded() {
        return this.psbFilesUploaded;
    }

    @Generated
    public Set<ShareFolderEntity> getSharedFolders() {
        return this.sharedFolders;
    }

    @Generated
    public AttributionsPermissionEntity getAttributionsPermission() {
        return this.attributionsPermission;
    }

    @Generated
    public DocumentationPermissionEntity getDocumentationPermission() {
        return this.documentationPermission;
    }

    @Generated
    public InstrumentationPermissionEntity getInstrumentationPermission() {
        return this.instrumentationPermission;
    }

    @Generated
    public RoutineInspectionPermissionEntity getRoutineInspectionPermission() {
        return this.routineInspectionPermission;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setPhone(String phone) {
        this.phone = phone;
    }

    @Generated
    public void setSex(SexEntity sex) {
        this.sex = sex;
    }

    @Generated
    public void setStatus(StatusEntity status) {
        this.status = status;
    }

    @Generated
    public void setRole(RoleEntity role) {
        this.role = role;
    }

    @Generated
    public void setIsFirstAccess(Boolean isFirstAccess) {
        this.isFirstAccess = isFirstAccess;
    }

    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @Generated
    public void setLastToken(String lastToken) {
        this.lastToken = lastToken;
    }

    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @Generated
    public void setTokenExpiryDate(LocalDateTime tokenExpiryDate) {
        this.tokenExpiryDate = tokenExpiryDate;
    }

    @JsonIgnore
    @Generated
    public void setReadings(Set<ReadingEntity> readings) {
        this.readings = readings;
    }

    @Generated
    public void setClients(Set<ClientEntity> clients) {
        this.clients = clients;
    }

    @JsonIgnore
    @Generated
    public void setDamPermissions(Set<DamPermissionEntity> damPermissions) {
        this.damPermissions = damPermissions;
    }

    @Generated
    public void setCreatedBy(UserEntity createdBy) {
        this.createdBy = createdBy;
    }

    @JsonIgnore
    @Generated
    public void setCreatedUsers(Set<UserEntity> createdUsers) {
        this.createdUsers = createdUsers;
    }

    @JsonIgnore
    @Generated
    public void setPsbFoldersCreated(Set<PSBFolderEntity> psbFoldersCreated) {
        this.psbFoldersCreated = psbFoldersCreated;
    }

    @JsonIgnore
    @Generated
    public void setPsbFilesUploaded(Set<PSBFileEntity> psbFilesUploaded) {
        this.psbFilesUploaded = psbFilesUploaded;
    }

    @JsonIgnore
    @Generated
    public void setSharedFolders(Set<ShareFolderEntity> sharedFolders) {
        this.sharedFolders = sharedFolders;
    }

    @JsonIgnoreProperties(value={"user"})
    @Generated
    public void setAttributionsPermission(AttributionsPermissionEntity attributionsPermission) {
        this.attributionsPermission = attributionsPermission;
    }

    @JsonIgnoreProperties(value={"user"})
    @Generated
    public void setDocumentationPermission(DocumentationPermissionEntity documentationPermission) {
        this.documentationPermission = documentationPermission;
    }

    @JsonIgnoreProperties(value={"user"})
    @Generated
    public void setInstrumentationPermission(InstrumentationPermissionEntity instrumentationPermission) {
        this.instrumentationPermission = instrumentationPermission;
    }

    @JsonIgnoreProperties(value={"user"})
    @Generated
    public void setRoutineInspectionPermission(RoutineInspectionPermissionEntity routineInspectionPermission) {
        this.routineInspectionPermission = routineInspectionPermission;
    }

    @Generated
    public UserEntity() {
    }

    @Generated
    public UserEntity(Long id, String name, String email, String password, String phone, SexEntity sex, StatusEntity status, RoleEntity role, Boolean isFirstAccess, String lastToken, LocalDateTime tokenExpiryDate, Set<ReadingEntity> readings, Set<ClientEntity> clients, Set<DamPermissionEntity> damPermissions, UserEntity createdBy, Set<UserEntity> createdUsers, Set<PSBFolderEntity> psbFoldersCreated, Set<PSBFileEntity> psbFilesUploaded, Set<ShareFolderEntity> sharedFolders, AttributionsPermissionEntity attributionsPermission, DocumentationPermissionEntity documentationPermission, InstrumentationPermissionEntity instrumentationPermission, RoutineInspectionPermissionEntity routineInspectionPermission) {
        this.id = id;
        this.name = name;
        this.email = email;
        this.password = password;
        this.phone = phone;
        this.sex = sex;
        this.status = status;
        this.role = role;
        this.isFirstAccess = isFirstAccess;
        this.lastToken = lastToken;
        this.tokenExpiryDate = tokenExpiryDate;
        this.readings = readings;
        this.clients = clients;
        this.damPermissions = damPermissions;
        this.createdBy = createdBy;
        this.createdUsers = createdUsers;
        this.psbFoldersCreated = psbFoldersCreated;
        this.psbFilesUploaded = psbFilesUploaded;
        this.sharedFolders = sharedFolders;
        this.attributionsPermission = attributionsPermission;
        this.documentationPermission = documentationPermission;
        this.instrumentationPermission = instrumentationPermission;
        this.routineInspectionPermission = routineInspectionPermission;
    }
}

