/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.geosegbar.entities.AnswerEntity;
import com.geosegbar.entities.QuestionEntity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Pattern;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;

@Entity
@Table(name="options", indexes={@Index(name="idx_option_label", columnList="label", unique=true), @Index(name="idx_option_value", columnList="value"), @Index(name="idx_option_order", columnList="order_index")})
public class OptionEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @NotBlank(message="Nome \u00e9 obrigat\u00f3rio!")
    @Column(name="label", nullable=false, unique=true)
    private @NotBlank(message="Nome \u00e9 obrigat\u00f3rio!") String label;
    @NotBlank(message="Nome \u00e9 obrigat\u00f3rio!")
    @Pattern(regexp="^[A-Za-z\u00c0-\u00ff\\s]+$", message="O campo n\u00e3o pode conter n\u00fameros!")
    @Column(name="value", nullable=true)
    private @NotBlank(message="Nome \u00e9 obrigat\u00f3rio!") @Pattern(regexp="^[A-Za-z\u00c0-\u00ff\\s]+$", message="O campo n\u00e3o pode conter n\u00fameros!") String value;
    @Column(name="order_index")
    private Integer orderIndex;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @ManyToMany(mappedBy="selectedOptions", fetch=FetchType.LAZY)
    private Set<AnswerEntity> answers = new HashSet<AnswerEntity>();
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @ManyToMany(mappedBy="options", fetch=FetchType.LAZY)
    private Set<QuestionEntity> questions = new HashSet<QuestionEntity>();

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getLabel() {
        return this.label;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public Integer getOrderIndex() {
        return this.orderIndex;
    }

    @Generated
    public Set<AnswerEntity> getAnswers() {
        return this.answers;
    }

    @Generated
    public Set<QuestionEntity> getQuestions() {
        return this.questions;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setLabel(String label) {
        this.label = label;
    }

    @Generated
    public void setValue(String value) {
        this.value = value;
    }

    @Generated
    public void setOrderIndex(Integer orderIndex) {
        this.orderIndex = orderIndex;
    }

    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @Generated
    public void setAnswers(Set<AnswerEntity> answers) {
        this.answers = answers;
    }

    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @Generated
    public void setQuestions(Set<QuestionEntity> questions) {
        this.questions = questions;
    }

    @Generated
    public OptionEntity() {
    }

    @Generated
    public OptionEntity(Long id, String label, String value, Integer orderIndex, Set<AnswerEntity> answers, Set<QuestionEntity> questions) {
        this.id = id;
        this.label = label;
        this.value = value;
        this.orderIndex = orderIndex;
        this.answers = answers;
        this.questions = questions;
    }
}

