/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.user.service;

import com.geosegbar.common.email.EmailService;
import com.geosegbar.common.enums.RoleEnum;
import com.geosegbar.common.enums.StatusEnum;
import com.geosegbar.common.utils.AuthenticatedUserUtil;
import com.geosegbar.common.utils.GenerateRandomCode;
import com.geosegbar.common.utils.GenerateRandomPassword;
import com.geosegbar.configs.security.TokenService;
import com.geosegbar.entities.AttributionsPermissionEntity;
import com.geosegbar.entities.ClientEntity;
import com.geosegbar.entities.DamEntity;
import com.geosegbar.entities.DamPermissionEntity;
import com.geosegbar.entities.DocumentationPermissionEntity;
import com.geosegbar.entities.InstrumentationPermissionEntity;
import com.geosegbar.entities.RoleEntity;
import com.geosegbar.entities.RoutineInspectionPermissionEntity;
import com.geosegbar.entities.SexEntity;
import com.geosegbar.entities.StatusEntity;
import com.geosegbar.entities.UserEntity;
import com.geosegbar.entities.VerificationCodeEntity;
import com.geosegbar.exceptions.DuplicateResourceException;
import com.geosegbar.exceptions.InvalidInputException;
import com.geosegbar.exceptions.NotFoundException;
import com.geosegbar.exceptions.UnauthorizedException;
import com.geosegbar.infra.client.persistence.jpa.ClientRepository;
import com.geosegbar.infra.dam.persistence.jpa.DamRepository;
import com.geosegbar.infra.permissions.atributions_permission.dtos.AttributionsPermissionDTO;
import com.geosegbar.infra.permissions.atributions_permission.services.AttributionsPermissionService;
import com.geosegbar.infra.permissions.dam_permissions.persistence.DamPermissionRepository;
import com.geosegbar.infra.permissions.documentation_permission.dtos.DocumentationPermissionDTO;
import com.geosegbar.infra.permissions.documentation_permission.services.DocumentationPermissionService;
import com.geosegbar.infra.permissions.instrumentation_permission.dtos.InstrumentationPermissionDTO;
import com.geosegbar.infra.permissions.instrumentation_permission.services.InstrumentationPermissionService;
import com.geosegbar.infra.permissions.routine_inspection_permission.dtos.RoutineInspectionPermissionDTO;
import com.geosegbar.infra.permissions.routine_inspection_permission.services.RoutineInspectionPermissionService;
import com.geosegbar.infra.roles.persistence.RoleRepository;
import com.geosegbar.infra.sex.persistence.jpa.SexRepository;
import com.geosegbar.infra.status.persistence.jpa.StatusRepository;
import com.geosegbar.infra.user.dto.LoginRequestDTO;
import com.geosegbar.infra.user.dto.LoginResponseDTO;
import com.geosegbar.infra.user.dto.UserClientAssociationDTO;
import com.geosegbar.infra.user.dto.UserCreateDTO;
import com.geosegbar.infra.user.dto.UserPasswordUpdateDTO;
import com.geosegbar.infra.user.dto.UserUpdateDTO;
import com.geosegbar.infra.user.persistence.jpa.UserRepository;
import com.geosegbar.infra.verification_code.dto.ForgotPasswordRequestDTO;
import com.geosegbar.infra.verification_code.dto.ResetPasswordRequestDTO;
import com.geosegbar.infra.verification_code.dto.VerifyCodeRequestDTO;
import com.geosegbar.infra.verification_code.persistence.jpa.VerificationCodeRepository;
import jakarta.annotation.PostConstruct;
import jakarta.transaction.Transactional;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.hibernate.Hibernate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class UserService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserService.class);
    private final UserRepository userRepository;
    private final ClientRepository clientRepository;
    private final SexRepository sexRepository;
    private final StatusRepository statusRepository;
    private final RoleRepository roleRepository;
    private final PasswordEncoder passwordEncoder;
    private final TokenService tokenService;
    private final VerificationCodeRepository verificationCodeRepository;
    private final EmailService emailService;
    private final DamRepository damRepository;
    private final DamPermissionRepository damPermissionRepository;
    private final DocumentationPermissionService documentationPermissionService;
    private final AttributionsPermissionService attributionsPermissionService;
    private final InstrumentationPermissionService instrumentationPermissionService;
    private final RoutineInspectionPermissionService routineInspectionPermissionService;

    @PostConstruct
    public void initializeSystemUser() {
        String systemUserEmail = "noreply@geometrisa-prod.com.br";
        String systemUserName = "SISTEMA";
        try {
            Optional existingUser = this.userRepository.findByEmail(systemUserEmail);
            if (existingUser.isPresent()) {
                log.info("Usu\u00e1rio do sistema j\u00e1 existe com ID: {}", (Object)((UserEntity)existingUser.get()).getId());
                return;
            }
            boolean systemNameExists = this.userRepository.existsByName(systemUserName);
            if (systemNameExists) {
                log.warn("J\u00e1 existe um usu\u00e1rio com o nome SISTEMA. N\u00e3o ser\u00e1 criado o usu\u00e1rio do sistema.");
                return;
            }
            UserEntity systemUser = new UserEntity();
            systemUser.setName(systemUserName);
            systemUser.setEmail(systemUserEmail);
            systemUser.setPassword(this.passwordEncoder.encode((CharSequence)"admingeom"));
            StatusEntity activeStatus = (StatusEntity)this.statusRepository.findByStatus(StatusEnum.ACTIVE).orElseThrow(() -> new NotFoundException("Status ACTIVE n\u00e3o encontrado no sistema!"));
            systemUser.setStatus(activeStatus);
            RoleEntity adminRole = (RoleEntity)this.roleRepository.findByName(RoleEnum.ADMIN).orElseThrow(() -> new NotFoundException("Role ADMIN n\u00e3o encontrada no sistema!"));
            systemUser.setRole(adminRole);
            SexEntity maleOrFirstSex = (SexEntity)this.sexRepository.findAll().stream().findFirst().orElseThrow(() -> new NotFoundException("Nenhum sexo encontrado no sistema!"));
            systemUser.setSex(maleOrFirstSex);
            UserEntity savedUser = (UserEntity)this.userRepository.save((Object)systemUser);
            log.info("Usu\u00e1rio do sistema criado com ID: {}", (Object)savedUser.getId());
        }
        catch (Exception e) {
            log.error("Erro ao criar usu\u00e1rio do sistema: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    @Transactional
    @CacheEvict(value={"userById", "allUsers", "usersByRoleAndClient", "usersByCreatedBy", "userExistence"}, allEntries=true, cacheManager="userCacheManager")
    public void deleteById(Long id) {
        UserEntity userLogged;
        if (!AuthenticatedUserUtil.isAdmin() && !(userLogged = AuthenticatedUserUtil.getCurrentUser()).getAttributionsPermission().getEditUser().booleanValue()) {
            throw new UnauthorizedException("Usu\u00e1rio n\u00e3o tem permiss\u00e3o para excluir usu\u00e1rios!");
        }
        UserEntity user = (UserEntity)this.userRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("Usu\u00e1rio n\u00e3o encontrado para exclus\u00e3o!"));
        if (this.isSystemUser(user)) {
            throw new InvalidInputException("O usu\u00e1rio do sistema n\u00e3o pode ser exclu\u00eddo.");
        }
        this.documentationPermissionService.deleteByUserSafely(user.getId());
        this.attributionsPermissionService.deleteByUserSafely(user.getId());
        this.instrumentationPermissionService.deleteByUserSafely(user.getId());
        this.routineInspectionPermissionService.deleteByUserSafely(user.getId());
        List damPermissions = this.damPermissionRepository.findByUser(user);
        if (!damPermissions.isEmpty()) {
            this.damPermissionRepository.deleteAll((Iterable)damPermissions);
        }
        this.userRepository.deleteById((Object)id);
    }

    @Transactional
    @Cacheable(value={"usersByCreatedBy"}, key="#createdById", cacheManager="userCacheManager")
    public List<UserEntity> findByCreatedBy(Long createdById) {
        this.userRepository.findById((Object)createdById).orElseThrow(() -> new NotFoundException("Usu\u00e1rio criador n\u00e3o encontrado com ID: " + createdById));
        List result = this.userRepository.findByCreatedByIdWithDetails(createdById);
        return result;
    }

    @Transactional
    @Cacheable(value={"usersByRoleAndClient"}, key="#roleId + '_' + #clientId + '_' + #statusId", cacheManager="userCacheManager")
    public List<UserEntity> findByRoleAndClient(Long roleId, Long clientId, Long statusId) {
        List result = this.userRepository.findByRoleAndClientWithDetails(roleId, clientId, statusId);
        return result;
    }

    @Transactional
    @CacheEvict(value={"userById", "allUsers", "usersByRoleAndClient", "usersByCreatedBy", "userExistence", "userByEmail"}, allEntries=true, cacheManager="userCacheManager")
    public UserEntity save(UserCreateDTO userDTO) {
        UserEntity userLogged;
        if (!AuthenticatedUserUtil.isAdmin() && !(userLogged = AuthenticatedUserUtil.getCurrentUser()).getAttributionsPermission().getEditUser().booleanValue()) {
            throw new UnauthorizedException("Usu\u00e1rio n\u00e3o tem permiss\u00e3o para editar/criar usu\u00e1rios!");
        }
        UserEntity userEntity = new UserEntity();
        userEntity.setName(userDTO.getName());
        userEntity.setEmail(userDTO.getEmail());
        userEntity.setPhone(userDTO.getPhone());
        userEntity.setSex(userDTO.getSex());
        userEntity.setStatus(userDTO.getStatus());
        userEntity.setRole(userDTO.getRole());
        userEntity.setClients(userDTO.getClients());
        if (userDTO.getCreatedById() != null) {
            UserEntity creator = (UserEntity)this.userRepository.findById((Object)userDTO.getCreatedById()).orElseThrow(() -> new NotFoundException("Usu\u00e1rio criador n\u00e3o encontrado com ID: " + userDTO.getCreatedById()));
            userEntity.setCreatedBy(creator);
        }
        if (this.userRepository.existsByEmail(userEntity.getEmail())) {
            throw new DuplicateResourceException("J\u00e1 existe um usu\u00e1rio com o email informado!");
        }
        if (userEntity.getPhone() != null && this.userRepository.existsByPhone(userEntity.getPhone())) {
            throw new DuplicateResourceException("J\u00e1 existe um usu\u00e1rio com o telefone informado!");
        }
        if (userEntity.getSex() == null || userEntity.getSex().getId() == null) {
            throw new InvalidInputException("Sexo \u00e9 obrigat\u00f3rio!");
        }
        this.sexRepository.findById((Object)userEntity.getSex().getId()).orElseThrow(() -> new NotFoundException("Sexo n\u00e3o encontrado com ID: " + userEntity.getSex().getId()));
        if (userEntity.getStatus() == null) {
            StatusEntity activeStatus = (StatusEntity)this.statusRepository.findByStatus(StatusEnum.ACTIVE).orElseThrow(() -> new NotFoundException("Status ACTIVE n\u00e3o encontrado no sistema!"));
            userEntity.setStatus(activeStatus);
        } else if (userEntity.getStatus().getId() != null) {
            StatusEntity status = (StatusEntity)this.statusRepository.findById((Object)userEntity.getStatus().getId()).orElseThrow(() -> new NotFoundException("Status n\u00e3o encontrado com ID: " + userEntity.getStatus().getId()));
            userEntity.setStatus(status);
        }
        if (userEntity.getRole() == null) {
            RoleEntity defaultRole = (RoleEntity)this.roleRepository.findByName(RoleEnum.COLLABORATOR).orElseThrow(() -> new NotFoundException("Role COLLABORATOR n\u00e3o encontrada no sistema!"));
            userEntity.setRole(defaultRole);
        } else if (userEntity.getRole().getId() != null) {
            RoleEntity role = (RoleEntity)this.roleRepository.findById((Object)userEntity.getRole().getId()).orElseThrow(() -> new NotFoundException("Role n\u00e3o encontrada com ID: " + userEntity.getRole().getId()));
            userEntity.setRole(role);
        }
        String generatedPassword = GenerateRandomPassword.execute();
        userEntity.setPassword(this.passwordEncoder.encode((CharSequence)generatedPassword));
        userEntity.setIsFirstAccess(Boolean.valueOf(true));
        UserEntity savedUser = (UserEntity)this.userRepository.save((Object)userEntity);
        this.emailService.sendFirstAccessPassword(savedUser.getEmail(), generatedPassword, savedUser.getName());
        if (savedUser.getRole().getName() == RoleEnum.COLLABORATOR) {
            if (userDTO.getSourceUserId() != null) {
                this.copyPermissionsFromUser(savedUser, userDTO.getSourceUserId());
            } else {
                if (!savedUser.getClients().isEmpty()) {
                    this.createDefaultDamPermissions(savedUser);
                }
                this.documentationPermissionService.createDefaultPermission(savedUser);
                this.attributionsPermissionService.createDefaultPermission(savedUser);
                this.instrumentationPermissionService.createDefaultPermission(savedUser);
                this.routineInspectionPermissionService.createDefaultPermission(savedUser);
            }
        }
        return savedUser;
    }

    @Transactional
    @CacheEvict(value={"userById", "allUsers", "usersByRoleAndClient", "usersByCreatedBy", "userExistence", "userByEmail"}, allEntries=true, cacheManager="userCacheManager")
    public UserEntity update(Long id, UserUpdateDTO userDTO) {
        RoleEnum oldRole;
        UserEntity userLogged;
        if (!AuthenticatedUserUtil.isAdmin() && (userLogged = AuthenticatedUserUtil.getCurrentUser()).getId().longValue() != id.longValue() && !userLogged.getAttributionsPermission().getEditUser().booleanValue()) {
            throw new UnauthorizedException("Usu\u00e1rio n\u00e3o tem permiss\u00e3o para editar usu\u00e1rios que n\u00e3o sejam ele mesmo!");
        }
        UserEntity existingUser = this.findEntityByIdWithAllDetails(id);
        if (this.isSystemUser(existingUser)) {
            throw new InvalidInputException("O usu\u00e1rio SISTEMA n\u00e3o pode ser modificado.");
        }
        if (this.userRepository.existsByEmailAndIdNot(userDTO.getEmail(), id)) {
            throw new DuplicateResourceException("J\u00e1 existe um usu\u00e1rio com o email informado!");
        }
        if (userDTO.getPhone() != null && this.userRepository.existsByPhoneAndIdNot(userDTO.getPhone(), id)) {
            throw new DuplicateResourceException("J\u00e1 existe um usu\u00e1rio com o telefone informado!");
        }
        if (userDTO.getSex() == null || userDTO.getSex().getId() == null) {
            throw new InvalidInputException("Sexo \u00e9 obrigat\u00f3rio!");
        }
        this.sexRepository.findById((Object)userDTO.getSex().getId()).orElseThrow(() -> new NotFoundException("Sexo n\u00e3o encontrado com ID: " + userDTO.getSex().getId()));
        if (userDTO.getStatus() != null && userDTO.getStatus().getId() != null) {
            StatusEntity status = (StatusEntity)this.statusRepository.findById((Object)userDTO.getStatus().getId()).orElseThrow(() -> new NotFoundException("Status n\u00e3o encontrado com ID: " + userDTO.getStatus().getId()));
            existingUser.setStatus(status);
        }
        boolean roleChanged = false;
        RoleEnum newRole = oldRole = existingUser.getRole().getName();
        if (userDTO.getRole() != null && userDTO.getRole().getId() != null) {
            RoleEntity role = (RoleEntity)this.roleRepository.findById((Object)userDTO.getRole().getId()).orElseThrow(() -> new NotFoundException("Role n\u00e3o encontrada com ID: " + userDTO.getRole().getId()));
            if (!existingUser.getRole().equals(role)) {
                roleChanged = true;
                newRole = role.getName();
            }
            existingUser.setRole(role);
        }
        existingUser.setName(userDTO.getName());
        existingUser.setEmail(userDTO.getEmail());
        existingUser.setPhone(userDTO.getPhone());
        existingUser.setSex(userDTO.getSex());
        UserEntity savedUser = (UserEntity)this.userRepository.save((Object)existingUser);
        if (roleChanged) {
            this.handleRoleChange(savedUser, oldRole, newRole);
        }
        return savedUser;
    }

    @Transactional
    @CacheEvict(value={"userById", "userByEmail"}, allEntries=true, cacheManager="userCacheManager")
    public UserEntity updatePassword(Long id, UserPasswordUpdateDTO passwordDTO) {
        UserEntity userLogged;
        if (!AuthenticatedUserUtil.isAdmin() && (userLogged = AuthenticatedUserUtil.getCurrentUser()).getId().longValue() != id.longValue() && !userLogged.getAttributionsPermission().getEditUser().booleanValue()) {
            throw new UnauthorizedException("Usu\u00e1rio n\u00e3o tem permiss\u00e3o para atualizar a senha de outros usu\u00e1rios!");
        }
        UserEntity existingUser = this.findEntityByIdWithAllDetails(id);
        if (!this.passwordEncoder.matches((CharSequence)passwordDTO.getCurrentPassword(), existingUser.getPassword())) {
            throw new InvalidInputException("Senha atual incorreta!");
        }
        if (passwordDTO.getCurrentPassword().equals(passwordDTO.getNewPassword())) {
            throw new InvalidInputException("A nova senha deve ser diferente da senha atual!");
        }
        existingUser.setPassword(this.passwordEncoder.encode((CharSequence)passwordDTO.getNewPassword()));
        if (existingUser.getIsFirstAccess().booleanValue()) {
            existingUser.setIsFirstAccess(Boolean.valueOf(false));
        }
        UserEntity savedUser = (UserEntity)this.userRepository.save((Object)existingUser);
        return savedUser;
    }

    @Transactional
    @CacheEvict(value={"userById", "allUsers", "usersByRoleAndClient"}, allEntries=true, cacheManager="userCacheManager")
    public UserEntity updateUserClients(Long userId, UserClientAssociationDTO clientAssociationDTO) {
        AuthenticatedUserUtil.checkAdminPermission();
        UserEntity user = this.findEntityByIdWithAllDetails(userId);
        HashSet oldClients = new HashSet(user.getClients());
        HashSet<ClientEntity> newClients = new HashSet<ClientEntity>();
        for (Long clientId : clientAssociationDTO.getClientIds()) {
            ClientEntity client = (ClientEntity)this.clientRepository.findById((Object)clientId).orElseThrow(() -> new NotFoundException("Cliente com ID " + clientId + " n\u00e3o encontrado!"));
            newClients.add(client);
        }
        user.setClients(newClients);
        if (user.getRole() != null && user.getRole().getName() == RoleEnum.COLLABORATOR) {
            HashSet addedClients = new HashSet(newClients);
            addedClients.removeAll(oldClients);
            if (!addedClients.isEmpty()) {
                this.createDamPermissionsForSpecificClients(user, addedClients);
            }
            HashSet removedClients = new HashSet(oldClients);
            removedClients.removeAll(newClients);
            if (!removedClients.isEmpty()) {
                this.deleteDamPermissionsForSpecificClients(user, removedClients);
            }
        }
        UserEntity savedUser = (UserEntity)this.userRepository.save((Object)user);
        return savedUser;
    }

    @Transactional
    @Cacheable(value={"userById"}, key="#id", cacheManager="userCacheManager")
    public UserEntity findById(Long id) {
        UserEntity user = this.findEntityByIdWithAllDetails(id);
        return user;
    }

    @Transactional
    @Cacheable(value={"userByEmail"}, key="#email", cacheManager="userCacheManager")
    public UserEntity findByEmail(String email) {
        UserEntity user = (UserEntity)this.userRepository.findByEmailWithBasicDetails(email).orElseThrow(() -> new NotFoundException("Usu\u00e1rio n\u00e3o encontrado com email: " + email));
        return user;
    }

    @Transactional
    @Cacheable(value={"allUsers"}, key="'all'", cacheManager="userCacheManager")
    public List<UserEntity> findAll() {
        List users = this.userRepository.findAllWithBasicDetails();
        users.forEach(user -> {
            if (!Hibernate.isInitialized((Object)user.getClients())) {
                user.getClients().size();
            }
        });
        return users;
    }

    @Transactional
    @Cacheable(value={"userExistence"}, key="'email_' + #email", cacheManager="userCacheManager")
    public boolean existsByEmail(String email) {
        return this.userRepository.existsByEmail(email);
    }

    @Transactional
    @Cacheable(value={"userExistence"}, key="'emailNot_' + #email + '_' + #id", cacheManager="userCacheManager")
    public boolean existsByEmailAndIdNot(String email, Long id) {
        return this.userRepository.existsByEmailAndIdNot(email, id);
    }

    private UserEntity findEntityByIdWithAllDetails(Long id) {
        UserEntity user = (UserEntity)this.userRepository.findByIdWithAllDetails(id).orElseThrow(() -> new NotFoundException("Usu\u00e1rio n\u00e3o encontrado!"));
        if (!Hibernate.isInitialized((Object)user.getClients())) {
            user.getClients().size();
        }
        return user;
    }

    @Transactional
    public Object initiateLogin(LoginRequestDTO userDTO) {
        UserEntity user = (UserEntity)this.userRepository.findByEmailWithClientsAndDetails(userDTO.email()).orElseThrow(() -> new NotFoundException("Credenciais incorretas!"));
        if (user.getStatus().getStatus() == StatusEnum.DISABLED) {
            throw new UnauthorizedException("Usu\u00e1rio n\u00e3o tem acesso ao sistema!");
        }
        if (!this.passwordEncoder.matches((CharSequence)userDTO.password(), user.getPassword())) {
            throw new InvalidInputException("Credenciais incorretas!");
        }
        if (user.getLastToken() != null && user.getTokenExpiryDate() != null && LocalDateTime.now().isBefore(user.getTokenExpiryDate()) && this.tokenService.isTokenValid(user.getLastToken())) {
            ArrayList clients = new ArrayList(user.getClients());
            return new LoginResponseDTO(user.getId(), user.getName(), user.getEmail(), user.getPhone(), user.getSex(), user.getRole().getName(), user.getIsFirstAccess(), user.getLastToken(), clients);
        }
        if (this.isSystemUser(user)) {
            String token = this.tokenService.generateToken(user);
            user.setLastToken(token);
            user.setTokenExpiryDate(LocalDateTime.now().plusHours(12L));
            this.userRepository.save((Object)user);
            ArrayList clients = new ArrayList(user.getClients());
            return new LoginResponseDTO(user.getId(), user.getName(), user.getEmail(), user.getPhone(), user.getSex(), user.getRole().getName(), user.getIsFirstAccess(), token, clients);
        }
        String verificationCode = GenerateRandomCode.generateRandomCode();
        VerificationCodeEntity codeEntity = new VerificationCodeEntity();
        codeEntity.setCode(verificationCode);
        codeEntity.setUser(user);
        codeEntity.setUsed(false);
        codeEntity.setExpiryDate(LocalDateTime.now().plusMinutes(10L));
        this.verificationCodeRepository.save((Object)codeEntity);
        this.emailService.sendVerificationCode(user.getEmail(), verificationCode);
        return null;
    }

    @Transactional
    public LoginResponseDTO verifyCodeAndLogin(VerifyCodeRequestDTO verifyRequest) {
        UserEntity user = (UserEntity)this.userRepository.findByEmailWithClientsAndDetails(verifyRequest.getEmail()).orElseThrow(() -> new NotFoundException("Usu\u00e1rio n\u00e3o encontrado!"));
        VerificationCodeEntity codeEntity = (VerificationCodeEntity)this.verificationCodeRepository.findLatestActiveByUser(user).orElseThrow(() -> new NotFoundException("C\u00f3digo de verifica\u00e7\u00e3o n\u00e3o encontrado ou expirado!"));
        if (!codeEntity.getCode().equals(verifyRequest.getCode())) {
            throw new InvalidInputException("C\u00f3digo de verifica\u00e7\u00e3o inv\u00e1lido!");
        }
        if (LocalDateTime.now().isAfter(codeEntity.getExpiryDate())) {
            throw new InvalidInputException("C\u00f3digo de verifica\u00e7\u00e3o expirado!");
        }
        codeEntity.setUsed(true);
        this.verificationCodeRepository.save((Object)codeEntity);
        String token = this.tokenService.generateToken(user);
        this.userRepository.save((Object)user);
        ArrayList clients = new ArrayList(user.getClients());
        return new LoginResponseDTO(user.getId(), user.getName(), user.getEmail(), user.getPhone(), user.getSex(), user.getRole().getName(), user.getIsFirstAccess(), token, clients);
    }

    @Transactional
    public void initiatePasswordReset(ForgotPasswordRequestDTO requestDTO) {
        UserEntity user = (UserEntity)this.userRepository.findByEmail(requestDTO.getEmail()).orElseThrow(() -> new NotFoundException("Usu\u00e1rio n\u00e3o encontrado com este email!"));
        List activeCodes = this.verificationCodeRepository.findAllByUserAndUsedFalseOrderByExpiryDateDesc(user);
        for (VerificationCodeEntity code : activeCodes) {
            code.setUsed(true);
            this.verificationCodeRepository.save((Object)code);
        }
        String verificationCode = GenerateRandomCode.generateRandomCode();
        VerificationCodeEntity codeEntity = new VerificationCodeEntity();
        codeEntity.setCode(verificationCode);
        codeEntity.setUser(user);
        codeEntity.setUsed(false);
        codeEntity.setExpiryDate(LocalDateTime.now().plusMinutes(10L));
        this.verificationCodeRepository.save((Object)codeEntity);
        this.emailService.sendPasswordResetCode(user.getEmail(), verificationCode);
    }

    @Transactional
    @CacheEvict(value={"userById", "userByEmail"}, allEntries=true, cacheManager="userCacheManager")
    public void resetPassword(ResetPasswordRequestDTO requestDTO) {
        UserEntity user = (UserEntity)this.userRepository.findByEmail(requestDTO.getEmail()).orElseThrow(() -> new NotFoundException("Usu\u00e1rio n\u00e3o encontrado com este email!"));
        VerificationCodeEntity codeEntity = (VerificationCodeEntity)this.verificationCodeRepository.findLatestActiveByUser(user).orElseThrow(() -> new NotFoundException("C\u00f3digo de verifica\u00e7\u00e3o n\u00e3o encontrado ou expirado!"));
        if (!codeEntity.getCode().equals(requestDTO.getCode())) {
            throw new InvalidInputException("C\u00f3digo de verifica\u00e7\u00e3o inv\u00e1lido!");
        }
        if (LocalDateTime.now().isAfter(codeEntity.getExpiryDate())) {
            throw new InvalidInputException("C\u00f3digo de verifica\u00e7\u00e3o expirado!");
        }
        codeEntity.setUsed(true);
        this.verificationCodeRepository.save((Object)codeEntity);
        user.setPassword(this.passwordEncoder.encode((CharSequence)requestDTO.getNewPassword()));
        this.userRepository.save((Object)user);
    }

    @Transactional
    public boolean verifyResetCode(VerifyCodeRequestDTO verifyRequest) {
        UserEntity user = (UserEntity)this.userRepository.findByEmail(verifyRequest.getEmail()).orElseThrow(() -> new NotFoundException("Usu\u00e1rio n\u00e3o encontrado!"));
        VerificationCodeEntity codeEntity = (VerificationCodeEntity)this.verificationCodeRepository.findLatestActiveByUser(user).orElseThrow(() -> new NotFoundException("C\u00f3digo de verifica\u00e7\u00e3o n\u00e3o encontrado ou expirado!"));
        if (!codeEntity.getCode().equals(verifyRequest.getCode())) {
            throw new InvalidInputException("C\u00f3digo de verifica\u00e7\u00e3o inv\u00e1lido!");
        }
        if (LocalDateTime.now().isAfter(codeEntity.getExpiryDate())) {
            throw new InvalidInputException("C\u00f3digo de verifica\u00e7\u00e3o expirado!");
        }
        return true;
    }

    private void handleRoleChange(UserEntity user, RoleEnum oldRole, RoleEnum newRole) {
        if (oldRole == RoleEnum.ADMIN && newRole == RoleEnum.COLLABORATOR) {
            if (!user.getClients().isEmpty()) {
                this.createDefaultDamPermissions(user);
            }
            this.documentationPermissionService.createDefaultPermission(user);
            this.attributionsPermissionService.createDefaultPermission(user);
            this.instrumentationPermissionService.createDefaultPermission(user);
            this.routineInspectionPermissionService.createDefaultPermission(user);
        }
        if (oldRole == RoleEnum.COLLABORATOR && newRole == RoleEnum.ADMIN) {
            this.deleteAllDamPermissions(user);
            this.documentationPermissionService.deleteByUserSafely(user.getId());
            this.attributionsPermissionService.deleteByUserSafely(user.getId());
            this.instrumentationPermissionService.deleteByUserSafely(user.getId());
            this.routineInspectionPermissionService.deleteByUserSafely(user.getId());
        }
    }

    private void createDefaultDamPermissions(UserEntity user) {
        for (ClientEntity client : user.getClients()) {
            List dams = this.damRepository.findByClient(client);
            for (DamEntity dam : dams) {
                if (this.damPermissionRepository.existsByUserAndDamAndClient(user, dam, client)) continue;
                DamPermissionEntity permission = new DamPermissionEntity();
                permission.setUser(user);
                permission.setDam(dam);
                permission.setClient(client);
                permission.setHasAccess(Boolean.valueOf(false));
                permission.setCreatedAt(LocalDateTime.now());
                this.damPermissionRepository.save((Object)permission);
            }
        }
    }

    private void deleteAllDamPermissions(UserEntity user) {
        List permissions = this.damPermissionRepository.findByUser(user);
        if (!permissions.isEmpty()) {
            this.damPermissionRepository.deleteAll((Iterable)permissions);
        }
    }

    private void createDamPermissionsForSpecificClients(UserEntity user, Set<ClientEntity> clients) {
        for (ClientEntity client : clients) {
            List dams = this.damRepository.findByClient(client);
            for (DamEntity dam : dams) {
                if (this.damPermissionRepository.existsByUserAndDamAndClient(user, dam, client)) continue;
                DamPermissionEntity permission = new DamPermissionEntity();
                permission.setUser(user);
                permission.setDam(dam);
                permission.setClient(client);
                permission.setHasAccess(Boolean.valueOf(false));
                permission.setCreatedAt(LocalDateTime.now());
                this.damPermissionRepository.save((Object)permission);
            }
        }
    }

    private void deleteDamPermissionsForSpecificClients(UserEntity user, Set<ClientEntity> clients) {
        for (ClientEntity client : clients) {
            List permissions = this.damPermissionRepository.findByUserAndClient(user, client);
            if (permissions.isEmpty()) continue;
            this.damPermissionRepository.deleteAll((Iterable)permissions);
        }
    }

    @Transactional
    private void copyPermissionsFromUser(UserEntity targetUser, Long sourceUserId) {
        UserEntity sourceUser = (UserEntity)this.userRepository.findById((Object)sourceUserId).orElseThrow(() -> new NotFoundException("Usu\u00e1rio n\u00e3o encontrado para c\u00f3pia da permiss\u00f5es!"));
        if (sourceUser.getRole().getName() != RoleEnum.COLLABORATOR) {
            throw new InvalidInputException("O usu\u00e1rio fonte deve ser um colaborador para copiar permiss\u00f5es!");
        }
        try {
            DocumentationPermissionEntity sourceDocPermission = this.documentationPermissionService.findByUser(sourceUser.getId());
            DocumentationPermissionDTO docPermissionDTO = new DocumentationPermissionDTO();
            docPermissionDTO.setUserId(targetUser.getId());
            docPermissionDTO.setViewPSB(sourceDocPermission.getViewPSB());
            docPermissionDTO.setEditPSB(sourceDocPermission.getEditPSB());
            docPermissionDTO.setSharePSB(sourceDocPermission.getSharePSB());
            this.documentationPermissionService.createOrUpdate(docPermissionDTO);
        }
        catch (NotFoundException e) {
            this.documentationPermissionService.createDefaultPermission(targetUser);
        }
        try {
            AttributionsPermissionEntity sourceAttrPermission = this.attributionsPermissionService.findByUser(sourceUser.getId());
            AttributionsPermissionDTO attrPermissionDTO = new AttributionsPermissionDTO();
            attrPermissionDTO.setUserId(targetUser.getId());
            attrPermissionDTO.setEditUser(sourceAttrPermission.getEditUser());
            attrPermissionDTO.setEditDam(sourceAttrPermission.getEditDam());
            attrPermissionDTO.setEditGeralData(sourceAttrPermission.getEditGeralData());
            this.attributionsPermissionService.createOrUpdate(attrPermissionDTO);
        }
        catch (NotFoundException e) {
            this.attributionsPermissionService.createDefaultPermission(targetUser);
        }
        try {
            InstrumentationPermissionEntity sourceInstrPermission = this.instrumentationPermissionService.findByUser(sourceUser.getId());
            InstrumentationPermissionDTO instrPermissionDTO = new InstrumentationPermissionDTO();
            instrPermissionDTO.setUserId(targetUser.getId());
            instrPermissionDTO.setViewGraphs(sourceInstrPermission.getViewGraphs());
            instrPermissionDTO.setEditGraphsLocal(sourceInstrPermission.getEditGraphsLocal());
            instrPermissionDTO.setEditGraphsDefault(sourceInstrPermission.getEditGraphsDefault());
            instrPermissionDTO.setViewRead(sourceInstrPermission.getViewRead());
            instrPermissionDTO.setEditRead(sourceInstrPermission.getEditRead());
            instrPermissionDTO.setViewSections(sourceInstrPermission.getViewSections());
            instrPermissionDTO.setEditSections(sourceInstrPermission.getEditSections());
            this.instrumentationPermissionService.createOrUpdate(instrPermissionDTO);
        }
        catch (NotFoundException e) {
            this.instrumentationPermissionService.createDefaultPermission(targetUser);
        }
        try {
            RoutineInspectionPermissionEntity sourceRoutinePermission = this.routineInspectionPermissionService.findByUser(sourceUser.getId());
            RoutineInspectionPermissionDTO routinePermissionDTO = new RoutineInspectionPermissionDTO();
            routinePermissionDTO.setUserId(targetUser.getId());
            routinePermissionDTO.setIsFillWeb(sourceRoutinePermission.getIsFillWeb());
            routinePermissionDTO.setIsFillMobile(sourceRoutinePermission.getIsFillMobile());
            this.routineInspectionPermissionService.createOrUpdate(routinePermissionDTO);
        }
        catch (NotFoundException e) {
            this.routineInspectionPermissionService.createDefaultPermission(targetUser);
        }
        if (!targetUser.getClients().isEmpty()) {
            this.createDefaultDamPermissions(targetUser);
        }
    }

    public boolean isSystemUser(UserEntity user) {
        return user != null && "SISTEMA".equals(user.getName()) && "noreply@geometrisa-prod.com.br".equals(user.getEmail());
    }

    public boolean isSystemUser(Long userId) {
        try {
            UserEntity user = this.findById(userId);
            return this.isSystemUser(user);
        }
        catch (Exception e) {
            return false;
        }
    }

    public Long getSystemUserId() {
        String systemUserEmail = "noreply@geometrisa-prod.com.br";
        UserEntity systemUser = (UserEntity)this.userRepository.findByEmail(systemUserEmail).orElseThrow(() -> new NotFoundException("Usu\u00e1rio do sistema n\u00e3o encontrado!"));
        return systemUser.getId();
    }

    public UserEntity getSystemUser() {
        String systemUserEmail = "noreply@geometrisa-prod.com.br";
        return (UserEntity)this.userRepository.findByEmail(systemUserEmail).orElseThrow(() -> new NotFoundException("Usu\u00e1rio do sistema n\u00e3o encontrado!"));
    }

    @Generated
    public UserService(UserRepository userRepository, ClientRepository clientRepository, SexRepository sexRepository, StatusRepository statusRepository, RoleRepository roleRepository, PasswordEncoder passwordEncoder, TokenService tokenService, VerificationCodeRepository verificationCodeRepository, EmailService emailService, DamRepository damRepository, DamPermissionRepository damPermissionRepository, DocumentationPermissionService documentationPermissionService, AttributionsPermissionService attributionsPermissionService, InstrumentationPermissionService instrumentationPermissionService, RoutineInspectionPermissionService routineInspectionPermissionService) {
        this.userRepository = userRepository;
        this.clientRepository = clientRepository;
        this.sexRepository = sexRepository;
        this.statusRepository = statusRepository;
        this.roleRepository = roleRepository;
        this.passwordEncoder = passwordEncoder;
        this.tokenService = tokenService;
        this.verificationCodeRepository = verificationCodeRepository;
        this.emailService = emailService;
        this.damRepository = damRepository;
        this.damPermissionRepository = damPermissionRepository;
        this.documentationPermissionService = documentationPermissionService;
        this.attributionsPermissionService = attributionsPermissionService;
        this.instrumentationPermissionService = instrumentationPermissionService;
        this.routineInspectionPermissionService = routineInspectionPermissionService;
    }
}

