/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.risk_category.services;

import com.geosegbar.entities.RiskCategoryEntity;
import com.geosegbar.exceptions.DuplicateResourceException;
import com.geosegbar.exceptions.NotFoundException;
import com.geosegbar.infra.risk_category.persistence.RiskCategoryRepository;
import jakarta.annotation.PostConstruct;
import jakarta.transaction.Transactional;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class RiskCategoryService {
    private final RiskCategoryRepository riskCategoryRepository;

    @PostConstruct
    @Transactional
    public void initializeDefaultRiskCategories() {
        this.createIfNotExists("Baixo");
        this.createIfNotExists("M\u00e9dio");
        this.createIfNotExists("Alto");
    }

    private void createIfNotExists(String name) {
        if (!this.riskCategoryRepository.existsByName(name)) {
            RiskCategoryEntity riskCategory = new RiskCategoryEntity();
            riskCategory.setName(name);
            this.riskCategoryRepository.save((Object)riskCategory);
        }
    }

    @Transactional
    public void deleteById(Long id) {
        this.riskCategoryRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("Categoria de risco n\u00e3o encontrada para exclus\u00e3o!"));
        this.riskCategoryRepository.deleteById((Object)id);
    }

    @Transactional
    public RiskCategoryEntity save(RiskCategoryEntity riskCategoryEntity) {
        if (this.riskCategoryRepository.existsByName(riskCategoryEntity.getName())) {
            throw new DuplicateResourceException("J\u00e1 existe uma categoria de risco com este nome!");
        }
        return (RiskCategoryEntity)this.riskCategoryRepository.save((Object)riskCategoryEntity);
    }

    @Transactional
    public RiskCategoryEntity update(RiskCategoryEntity riskCategoryEntity) {
        this.riskCategoryRepository.findById((Object)riskCategoryEntity.getId()).orElseThrow(() -> new NotFoundException("Categoria de risco n\u00e3o encontrada para atualiza\u00e7\u00e3o!"));
        if (this.riskCategoryRepository.existsByNameAndIdNot(riskCategoryEntity.getName(), riskCategoryEntity.getId())) {
            throw new DuplicateResourceException("J\u00e1 existe uma categoria de risco com este nome!");
        }
        return (RiskCategoryEntity)this.riskCategoryRepository.save((Object)riskCategoryEntity);
    }

    public RiskCategoryEntity findById(Long id) {
        return (RiskCategoryEntity)this.riskCategoryRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("Categoria de risco n\u00e3o encontrada!"));
    }

    public List<RiskCategoryEntity> findAll() {
        return this.riskCategoryRepository.findAllByOrderByIdAsc();
    }

    @Generated
    public RiskCategoryService(RiskCategoryRepository riskCategoryRepository) {
        this.riskCategoryRepository = riskCategoryRepository;
    }
}

