/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.regulatory_dam.services;

import com.geosegbar.entities.ClassificationDamEntity;
import com.geosegbar.entities.DamEntity;
import com.geosegbar.entities.PotentialDamageEntity;
import com.geosegbar.entities.RegulatoryDamEntity;
import com.geosegbar.entities.RiskCategoryEntity;
import com.geosegbar.entities.SecurityLevelEntity;
import com.geosegbar.exceptions.DuplicateResourceException;
import com.geosegbar.exceptions.NotFoundException;
import com.geosegbar.exceptions.UnauthorizedException;
import com.geosegbar.infra.classification_dam.peristence.ClassificationDamRepository;
import com.geosegbar.infra.dam.persistence.jpa.DamRepository;
import com.geosegbar.infra.potential_damage.persistence.PotentialDamageRepository;
import com.geosegbar.infra.regulatory_dam.dtos.RegulatoryDamDTO;
import com.geosegbar.infra.regulatory_dam.persistence.RegulatoryDamRepository;
import com.geosegbar.infra.risk_category.persistence.RiskCategoryRepository;
import com.geosegbar.infra.security_level.persistence.SecurityLevelRepository;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RegulatoryDamService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RegulatoryDamService.class);
    private final RegulatoryDamRepository regulatoryDamRepository;
    private final DamRepository damRepository;
    private final SecurityLevelRepository securityLevelRepository;
    private final RiskCategoryRepository riskCategoryRepository;
    private final PotentialDamageRepository potentialDamageRepository;
    private final ClassificationDamRepository classificationDamRepository;

    public RegulatoryDamEntity findById(Long id) {
        return (RegulatoryDamEntity)this.regulatoryDamRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("Informa\u00e7\u00e3o regulat\u00f3ria da barragem n\u00e3o encontrada com ID: " + id));
    }

    public RegulatoryDamEntity findByDamId(Long damId) {
        return (RegulatoryDamEntity)this.regulatoryDamRepository.findByDamId(damId).orElseThrow(() -> new NotFoundException("Informa\u00e7\u00e3o regulat\u00f3ria n\u00e3o encontrada para a barragem com ID: " + damId));
    }

    public List<RegulatoryDamEntity> findAll() {
        return this.regulatoryDamRepository.findAll();
    }

    @Transactional
    public RegulatoryDamEntity createOrUpdate(RegulatoryDamDTO regulatoryDamDTO) {
        RegulatoryDamEntity regulatoryDam;
        DamEntity dam = (DamEntity)this.damRepository.findById((Object)regulatoryDamDTO.getDamId()).orElseThrow(() -> new NotFoundException("Barragem n\u00e3o encontrada com ID: " + regulatoryDamDTO.getDamId()));
        if (regulatoryDamDTO.getId() != null) {
            regulatoryDam = (RegulatoryDamEntity)this.regulatoryDamRepository.findById((Object)regulatoryDamDTO.getId()).orElseThrow(() -> new NotFoundException("Informa\u00e7\u00e3o regulat\u00f3ria da barragem n\u00e3o encontrada com ID: " + regulatoryDamDTO.getId()));
            if (!regulatoryDam.getDam().getId().equals(regulatoryDamDTO.getDamId())) {
                throw new UnauthorizedException("N\u00e3o \u00e9 permitido mudar a barragem associada \u00e0 informa\u00e7\u00e3o regulat\u00f3ria");
            }
        } else {
            if (this.regulatoryDamRepository.existsByDam(dam)) {
                throw new DuplicateResourceException("J\u00e1 existe informa\u00e7\u00e3o regulat\u00f3ria para esta barragem");
            }
            regulatoryDam = new RegulatoryDamEntity();
            regulatoryDam.setDam(dam);
            dam.setRegulatoryDam(regulatoryDam);
        }
        regulatoryDam.setFramePNSB(regulatoryDamDTO.getFramePNSB());
        regulatoryDam.setRepresentativeName(regulatoryDamDTO.getRepresentativeName());
        regulatoryDam.setRepresentativeEmail(regulatoryDamDTO.getRepresentativeEmail());
        regulatoryDam.setRepresentativePhone(regulatoryDamDTO.getRepresentativePhone());
        regulatoryDam.setTechnicalManagerName(regulatoryDamDTO.getTechnicalManagerName());
        regulatoryDam.setTechnicalManagerEmail(regulatoryDamDTO.getTechnicalManagerEmail());
        regulatoryDam.setTechnicalManagerPhone(regulatoryDamDTO.getTechnicalManagerPhone());
        if (regulatoryDamDTO.getSecurityLevelId() != null) {
            SecurityLevelEntity securityLevel = (SecurityLevelEntity)this.securityLevelRepository.findById((Object)regulatoryDamDTO.getSecurityLevelId()).orElseThrow(() -> new NotFoundException("N\u00edvel de seguran\u00e7a n\u00e3o encontrado com ID: " + regulatoryDamDTO.getSecurityLevelId()));
            regulatoryDam.setSecurityLevel(securityLevel);
        } else {
            regulatoryDam.setSecurityLevel(null);
        }
        regulatoryDam.setSupervisoryBodyName(regulatoryDamDTO.getSupervisoryBodyName());
        if (regulatoryDamDTO.getRiskCategoryId() != null) {
            RiskCategoryEntity riskCategory = (RiskCategoryEntity)this.riskCategoryRepository.findById((Object)regulatoryDamDTO.getRiskCategoryId()).orElseThrow(() -> new NotFoundException("Categoria de risco n\u00e3o encontrada com ID: " + regulatoryDamDTO.getRiskCategoryId()));
            regulatoryDam.setRiskCategory(riskCategory);
        } else {
            regulatoryDam.setRiskCategory(null);
        }
        if (regulatoryDamDTO.getPotentialDamageId() != null) {
            PotentialDamageEntity potentialDamage = (PotentialDamageEntity)this.potentialDamageRepository.findById((Object)regulatoryDamDTO.getPotentialDamageId()).orElseThrow(() -> new NotFoundException("Dano potencial n\u00e3o encontrado com ID: " + regulatoryDamDTO.getPotentialDamageId()));
            regulatoryDam.setPotentialDamage(potentialDamage);
        } else {
            regulatoryDam.setPotentialDamage(null);
        }
        if (regulatoryDamDTO.getClassificationDamId() != null) {
            ClassificationDamEntity classificationDam = (ClassificationDamEntity)this.classificationDamRepository.findById((Object)regulatoryDamDTO.getClassificationDamId()).orElseThrow(() -> new NotFoundException("Classifica\u00e7\u00e3o de barragem n\u00e3o encontrada com ID: " + regulatoryDamDTO.getClassificationDamId()));
            regulatoryDam.setClassificationDam(classificationDam);
        } else {
            regulatoryDam.setClassificationDam(null);
        }
        RegulatoryDamEntity savedRegulatoryDam = (RegulatoryDamEntity)this.regulatoryDamRepository.save((Object)regulatoryDam);
        log.info("Informa\u00e7\u00e3o regulat\u00f3ria {} para a barragem {}", (Object)(regulatoryDamDTO.getId() == null ? "criada" : "atualizada"), (Object)dam.getName());
        return savedRegulatoryDam;
    }

    @Transactional
    public void delete(Long id) {
        RegulatoryDamEntity regulatoryDam = (RegulatoryDamEntity)this.regulatoryDamRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("Informa\u00e7\u00e3o regulat\u00f3ria da barragem n\u00e3o encontrada com ID: " + id));
        DamEntity dam = regulatoryDam.getDam();
        if (dam != null) {
            dam.setRegulatoryDam(null);
            this.damRepository.save((Object)dam);
        }
        this.regulatoryDamRepository.delete((Object)regulatoryDam);
        log.info("Informa\u00e7\u00e3o regulat\u00f3ria exclu\u00edda para a barragem {}", (Object)(dam != null ? dam.getName() : "desconhecida"));
    }

    @Generated
    public RegulatoryDamService(RegulatoryDamRepository regulatoryDamRepository, DamRepository damRepository, SecurityLevelRepository securityLevelRepository, RiskCategoryRepository riskCategoryRepository, PotentialDamageRepository potentialDamageRepository, ClassificationDamRepository classificationDamRepository) {
        this.regulatoryDamRepository = regulatoryDamRepository;
        this.damRepository = damRepository;
        this.securityLevelRepository = securityLevelRepository;
        this.riskCategoryRepository = riskCategoryRepository;
        this.potentialDamageRepository = potentialDamageRepository;
        this.classificationDamRepository = classificationDamRepository;
    }
}

