/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.reading.web;

import com.geosegbar.common.enums.LimitStatusEnum;
import com.geosegbar.common.response.WebResponseEntity;
import com.geosegbar.infra.reading.dtos.BulkToggleActiveRequestDTO;
import com.geosegbar.infra.reading.dtos.BulkToggleActiveResponseDTO;
import com.geosegbar.infra.reading.dtos.InstrumentGroupedReadingsDTO;
import com.geosegbar.infra.reading.dtos.InstrumentLimitStatusDTO;
import com.geosegbar.infra.reading.dtos.InstrumentReadingsDTO;
import com.geosegbar.infra.reading.dtos.PagedReadingResponseDTO;
import com.geosegbar.infra.reading.dtos.ReadingRequestDTO;
import com.geosegbar.infra.reading.dtos.ReadingResponseDTO;
import com.geosegbar.infra.reading.dtos.UpdateReadingRequestDTO;
import com.geosegbar.infra.reading.services.ReadingService;
import jakarta.validation.Valid;
import java.time.LocalDate;
import java.util.List;
import lombok.Generated;
import org.springframework.data.domain.Pageable;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/readings"})
public class ReadingController {
    private final ReadingService readingService;

    @GetMapping(value={"/instrument/{instrumentId}"})
    public ResponseEntity<WebResponseEntity<PagedReadingResponseDTO<ReadingResponseDTO>>> getReadingsByInstrument(@PathVariable Long instrumentId, @RequestParam(required=false) Long outputId, @RequestParam(required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate startDate, @RequestParam(required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate endDate, @RequestParam(required=false) LimitStatusEnum limitStatus, @RequestParam(required=false) Boolean active, Pageable pageable) {
        PagedReadingResponseDTO readings = this.readingService.findByFilters(instrumentId, outputId, startDate, endDate, limitStatus, active, pageable);
        return ResponseEntity.ok((Object)WebResponseEntity.success((Object)readings, (String)"Leituras obtidas com sucesso!"));
    }

    @GetMapping(value={"/instrument/{instrumentId}/grouped"})
    public ResponseEntity<WebResponseEntity<PagedReadingResponseDTO<ReadingResponseDTO>>> getGroupedReadingsByInstrument(@PathVariable Long instrumentId, @RequestParam(required=false) Boolean active, Pageable pageable) {
        PagedReadingResponseDTO result = this.readingService.findGroupedReadingsFlatByInstrument(instrumentId, active, pageable);
        return ResponseEntity.ok((Object)WebResponseEntity.success((Object)result, (String)"Leituras agrupadas obtidas com sucesso!"));
    }

    @GetMapping(value={"/output/{outputId}"})
    public ResponseEntity<WebResponseEntity<List<ReadingResponseDTO>>> getReadingsByOutput(@PathVariable Long outputId) {
        List readings = this.readingService.findByOutputId(outputId);
        return ResponseEntity.ok((Object)WebResponseEntity.success((Object)readings, (String)"Leituras obtidas com sucesso!"));
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<ReadingResponseDTO>> getReadingById(@PathVariable Long id) {
        ReadingResponseDTO reading = this.readingService.mapToResponseDTO(this.readingService.findById(id));
        return ResponseEntity.ok((Object)WebResponseEntity.success((Object)reading, (String)"Leitura obtida com sucesso!"));
    }

    @GetMapping(value={"/instrument/{instrumentId}/limit-status"})
    public ResponseEntity<WebResponseEntity<InstrumentLimitStatusDTO>> getInstrumentLimitStatus(@PathVariable Long instrumentId, @RequestParam(defaultValue="10") int limit) {
        InstrumentLimitStatusDTO status = this.readingService.getInstrumentLimitStatus(instrumentId, limit);
        return ResponseEntity.ok((Object)WebResponseEntity.success((Object)status, (String)"Status do limite do instrumento obtido com sucesso!"));
    }

    @GetMapping(value={"/client/{clientId}/instruments-limit-status"})
    public ResponseEntity<WebResponseEntity<List<InstrumentLimitStatusDTO>>> getAllInstrumentLimitStatusesByClientId(@PathVariable Long clientId, @RequestParam(defaultValue="10") int limit) {
        List statuses = this.readingService.getAllInstrumentLimitStatusesByClientId(clientId, limit);
        return ResponseEntity.ok((Object)WebResponseEntity.success((Object)statuses, (String)"Status dos limites dos instrumentos do cliente obtidos com sucesso!"));
    }

    @GetMapping(value={"/instruments"})
    public ResponseEntity<WebResponseEntity<PagedReadingResponseDTO<ReadingResponseDTO>>> getReadingsByMultipleInstruments(@RequestParam List<Long> instrumentIds, @RequestParam(required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate startDate, @RequestParam(required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate endDate, @RequestParam(required=false) LimitStatusEnum limitStatus, @RequestParam(required=false) Boolean active, Pageable pageable) {
        PagedReadingResponseDTO readings = this.readingService.findByMultipleInstruments(instrumentIds, startDate, endDate, limitStatus, active, pageable);
        return ResponseEntity.ok((Object)WebResponseEntity.success((Object)readings, (String)"Leituras obtidas com sucesso!"));
    }

    @GetMapping(value={"/instruments/grouped"})
    public ResponseEntity<WebResponseEntity<PagedReadingResponseDTO<ReadingResponseDTO>>> getGroupedReadingsByMultipleInstruments(@RequestParam List<Long> instrumentIds, Pageable pageable) {
        PagedReadingResponseDTO result = this.readingService.findGroupedReadingsFlatByMultipleInstruments(instrumentIds, pageable);
        return ResponseEntity.ok((Object)WebResponseEntity.success((Object)result, (String)"Leituras agrupadas obtidas com sucesso!"));
    }

    @GetMapping(value={"/client/{clientId}/latest-grouped"})
    public ResponseEntity<WebResponseEntity<List<InstrumentGroupedReadingsDTO>>> getLatestGroupedReadingsByClientId(@PathVariable Long clientId, @RequestParam(defaultValue="3") int limit) {
        if (limit <= 0 || limit > 10) {
            return ResponseEntity.badRequest().body((Object)WebResponseEntity.error((String)"O n\u00famero de leituras por instrumento deve estar entre 1 e 10"));
        }
        List result = this.readingService.findLatestGroupedReadingsByClientId(clientId, limit);
        return ResponseEntity.ok((Object)WebResponseEntity.success((Object)result, (String)String.format("\u00daltimas %d leituras agrupadas obtidas com sucesso para os instrumentos do cliente", limit)));
    }

    @GetMapping(value={"/latest"})
    public ResponseEntity<WebResponseEntity<InstrumentReadingsDTO.MultiInstrumentReadingsResponseDTO>> getLatestReadingsForMultipleInstruments(@RequestParam(required=false) List<Long> instrumentIds, @RequestParam(required=false) List<Long> outputIds, @RequestParam(required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate startDate, @RequestParam(required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate endDate, @RequestParam(defaultValue="10") int pageSize) {
        String message;
        if ((instrumentIds == null || instrumentIds.isEmpty()) && (outputIds == null || outputIds.isEmpty())) {
            return ResponseEntity.badRequest().body((Object)WebResponseEntity.error((String)"Pelo menos um instrumentId ou outputId deve ser fornecido"));
        }
        if (pageSize > 100) {
            pageSize = 100;
        }
        InstrumentReadingsDTO.MultiInstrumentReadingsResponseDTO result = this.readingService.findLatestReadingsForMultipleInstruments(instrumentIds, outputIds, startDate, endDate, pageSize);
        if (startDate != null || endDate != null) {
            String dateRange = "";
            dateRange = startDate != null && endDate != null ? String.format(" no per\u00edodo de %s a %s", startDate, endDate) : (startDate != null ? String.format(" a partir de %s", startDate) : String.format(" at\u00e9 %s", endDate));
            message = String.format("\u00daltimas %d leituras obtidas para %d instrumentos%s", pageSize, result.getInstrumentsReadings().size(), dateRange);
        } else {
            message = String.format("\u00daltimas %d leituras obtidas para %d instrumentos", pageSize, result.getInstrumentsReadings().size());
        }
        return ResponseEntity.ok((Object)WebResponseEntity.success((Object)result, (String)message));
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<ReadingResponseDTO>> updateReading(@PathVariable Long id, @Valid @RequestBody UpdateReadingRequestDTO request) {
        ReadingResponseDTO updated = this.readingService.updateReading(id, request);
        StringBuilder message = new StringBuilder("Leitura atualizada com sucesso");
        boolean hasChanges = false;
        if (request.getDate() != null || request.getHour() != null) {
            message.append(" (data/hora alterada)");
            hasChanges = true;
        }
        if (request.getUserId() != null) {
            if (hasChanges) {
                message.append(" e");
            }
            message.append(" (usu\u00e1rio alterado)");
            hasChanges = true;
        }
        if (request.getInputValues() != null && !request.getInputValues().isEmpty()) {
            if (hasChanges) {
                message.append(" e");
            }
            message.append(" (valores de input e c\u00e1lculos atualizados)");
            hasChanges = true;
        }
        if (request.getComment() != null) {
            if (hasChanges) {
                message.append(" e");
            }
            String commentAction = request.getComment().trim().isEmpty() ? "removido" : "atualizado";
            message.append(" (coment\u00e1rio ").append(commentAction).append(")");
        }
        message.append("!");
        return ResponseEntity.ok((Object)WebResponseEntity.success((Object)updated, (String)message.toString()));
    }

    @PatchMapping(value={"/bulk-toggle-active"})
    public ResponseEntity<WebResponseEntity<BulkToggleActiveResponseDTO>> bulkToggleActive(@Valid @RequestBody BulkToggleActiveRequestDTO request) {
        String action;
        BulkToggleActiveResponseDTO result = this.readingService.bulkToggleActive(request.getActive(), request.getReadingIds());
        String string = action = request.getActive() != false ? "ativa\u00e7\u00e3o" : "desativa\u00e7\u00e3o";
        String message = result.getFailureCount() == 0 ? String.format("Todas as %d leituras foram %s com sucesso!", result.getSuccessCount(), request.getActive() != false ? "ativadas" : "desativadas") : (result.getSuccessCount() == 0 ? String.format("Falha na %s de todas as %d leituras!", action, result.getTotalProcessed()) : String.format("Opera\u00e7\u00e3o de %s conclu\u00edda: %d sucessos, %d falhas de %d total", action, result.getSuccessCount(), result.getFailureCount(), result.getTotalProcessed()));
        return ResponseEntity.ok((Object)WebResponseEntity.success((Object)result, (String)message));
    }

    @PostMapping(value={"/instrument/{instrumentId}"})
    public ResponseEntity<WebResponseEntity<List<ReadingResponseDTO>>> createReading(@PathVariable Long instrumentId, @Valid @RequestBody ReadingRequestDTO request) {
        List created = this.readingService.create(instrumentId, request, false);
        return new ResponseEntity((Object)WebResponseEntity.success((Object)created, (String)"Leituras registradas com sucesso!"), (HttpStatusCode)HttpStatus.CREATED);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<Void>> deleteReading(@PathVariable Long id) {
        this.readingService.delete(id);
        return ResponseEntity.ok((Object)WebResponseEntity.success(null, (String)"Leitura exclu\u00edda com sucesso!"));
    }

    @Generated
    public ReadingController(ReadingService readingService) {
        this.readingService = readingService;
    }
}

