/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.reading.services;

import com.geosegbar.common.enums.LimitStatusEnum;
import com.geosegbar.common.utils.AuthenticatedUserUtil;
import com.geosegbar.common.utils.DateFormatter;
import com.geosegbar.entities.DeterministicLimitEntity;
import com.geosegbar.entities.InputEntity;
import com.geosegbar.entities.InstrumentEntity;
import com.geosegbar.entities.OutputEntity;
import com.geosegbar.entities.ReadingEntity;
import com.geosegbar.entities.ReadingInputValueEntity;
import com.geosegbar.entities.StatisticalLimitEntity;
import com.geosegbar.entities.UserEntity;
import com.geosegbar.exceptions.InvalidInputException;
import com.geosegbar.exceptions.NotFoundException;
import com.geosegbar.exceptions.UnauthorizedException;
import com.geosegbar.infra.client.persistence.jpa.ClientRepository;
import com.geosegbar.infra.instrument.persistence.jpa.InstrumentRepository;
import com.geosegbar.infra.reading.dtos.BulkToggleActiveResponseDTO;
import com.geosegbar.infra.reading.dtos.InstrumentGroupedReadingsDTO;
import com.geosegbar.infra.reading.dtos.InstrumentLimitStatusDTO;
import com.geosegbar.infra.reading.dtos.InstrumentReadingsDTO;
import com.geosegbar.infra.reading.dtos.PagedReadingResponseDTO;
import com.geosegbar.infra.reading.dtos.ReadingRequestDTO;
import com.geosegbar.infra.reading.dtos.ReadingResponseDTO;
import com.geosegbar.infra.reading.dtos.UpdateReadingRequestDTO;
import com.geosegbar.infra.reading.persistence.jpa.ReadingRepository;
import com.geosegbar.infra.reading.services.OutputCalculationService;
import com.geosegbar.infra.reading_input_value.dtos.ReadingInputValueDTO;
import com.geosegbar.infra.reading_input_value.persistence.jpa.ReadingInputValueRepository;
import com.geosegbar.infra.user.persistence.jpa.UserRepository;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.Time;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ReadingService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReadingService.class);
    private final ReadingRepository readingRepository;
    private final ReadingInputValueRepository readingInputValueRepository;
    private final InstrumentRepository instrumentRepository;
    private final OutputCalculationService outputCalculationService;
    private final ClientRepository clientRepository;
    private final UserRepository userRepository;

    @Cacheable(value={"readingsByInstrument"}, key="#instrumentId", cacheManager="readingCacheManager")
    public List<ReadingResponseDTO> findByInstrumentId(Long instrumentId) {
        UserEntity userLogged;
        if (!AuthenticatedUserUtil.isAdmin() && !(userLogged = AuthenticatedUserUtil.getCurrentUser()).getInstrumentationPermission().getViewRead().booleanValue()) {
            throw new UnauthorizedException("Usu\u00e1rio n\u00e3o tem permiss\u00e3o para visualizar leituras!");
        }
        List readings = this.readingRepository.findByInstrumentIdOptimized(instrumentId);
        return readings.stream().map(arg_0 -> this.mapToResponseDTOOptimized(arg_0)).collect(Collectors.toList());
    }

    @Cacheable(value={"readingExists"}, key="#instrumentId + '_' + #date", cacheManager="readingCacheManager")
    public boolean existsByInstrumentAndDate(Long instrumentId, LocalDate date) {
        return this.readingRepository.existsByInstrumentIdAndDate(instrumentId, date);
    }

    @Cacheable(value={"instrumentLimitStatus"}, key="#instrumentId + '_' + #limit", cacheManager="readingCacheManager")
    public InstrumentLimitStatusDTO getInstrumentLimitStatus(Long instrumentId, int limit) {
        List readingsOfMostRecentDate;
        LocalTime mostRecentHour;
        InstrumentEntity instrument = (InstrumentEntity)this.instrumentRepository.findById((Object)instrumentId).orElseThrow(() -> new NotFoundException("Instrumento n\u00e3o encontrado com ID: " + instrumentId));
        PageRequest pageable = PageRequest.of((int)0, (int)limit);
        List recentReadings = this.readingRepository.findTopNByInstrumentIdOptimized(instrumentId, (Pageable)pageable);
        if (recentReadings.isEmpty()) {
            return this.createInstrumentLimitStatusDTO(instrument, LimitStatusEnum.NORMAL, null);
        }
        LocalDate mostRecentDate = recentReadings.stream().map(ReadingEntity::getDate).max(LocalDate::compareTo).orElse(null);
        if (mostRecentDate != null && (mostRecentHour = (LocalTime)(readingsOfMostRecentDate = recentReadings.stream().filter(r -> r.getDate().equals(mostRecentDate)).collect(Collectors.toList())).stream().map(ReadingEntity::getHour).max(LocalTime::compareTo).orElse(null)) != null) {
            List mostRecentReadings = readingsOfMostRecentDate.stream().filter(r -> r.getHour().equals(mostRecentHour)).collect(Collectors.toList());
            LimitStatusEnum mostCriticalStatus = this.findMostCriticalStatus(mostRecentReadings);
            String formattedDateTime = String.valueOf(mostRecentDate) + " " + String.valueOf(mostRecentHour);
            return this.createInstrumentLimitStatusDTO(instrument, mostCriticalStatus, formattedDateTime);
        }
        ReadingEntity firstReading = (ReadingEntity)recentReadings.get(0);
        return this.createInstrumentLimitStatusDTO(instrument, firstReading.getLimitStatus(), String.valueOf(firstReading.getDate()) + " " + String.valueOf(firstReading.getHour()));
    }

    @Transactional(readOnly=true)
    public PagedReadingResponseDTO<ReadingResponseDTO> findByMultipleInstruments(List<Long> instrumentIds, LocalDate startDate, LocalDate endDate, LimitStatusEnum limitStatus, Boolean active, Pageable pageable) {
        UserEntity userLogged;
        if (!AuthenticatedUserUtil.isAdmin() && !(userLogged = AuthenticatedUserUtil.getCurrentUser()).getInstrumentationPermission().getViewRead().booleanValue()) {
            throw new UnauthorizedException("Usu\u00e1rio n\u00e3o tem permiss\u00e3o para visualizar leituras!");
        }
        if (instrumentIds == null || instrumentIds.isEmpty()) {
            throw new InvalidInputException("\u00c9 necess\u00e1rio fornecer pelo menos um ID de instrumento!");
        }
        if (pageable.getSort().isUnsorted()) {
            pageable = PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"date", "hour"}));
        }
        Boolean activeFilter = active != null ? active : true;
        Page readings = this.readingRepository.findByMultipleInstrumentsWithFilters(instrumentIds, startDate, endDate, limitStatus, activeFilter, pageable);
        Page dtoPage = readings.map(arg_0 -> this.mapToResponseDTOOptimized(arg_0));
        return new PagedReadingResponseDTO(dtoPage.getContent(), dtoPage.getNumber(), dtoPage.getSize(), dtoPage.getTotalElements(), dtoPage.getTotalPages(), dtoPage.isLast(), dtoPage.isFirst());
    }

    @Transactional(readOnly=true)
    public PagedReadingResponseDTO<ReadingResponseDTO> findGroupedReadingsFlatByMultipleInstruments(List<Long> instrumentIds, Pageable pageable) {
        UserEntity userLogged;
        if (!AuthenticatedUserUtil.isAdmin() && !(userLogged = AuthenticatedUserUtil.getCurrentUser()).getInstrumentationPermission().getViewRead().booleanValue()) {
            throw new UnauthorizedException("Usu\u00e1rio n\u00e3o tem permiss\u00e3o para visualizar leituras");
        }
        if (instrumentIds == null || instrumentIds.isEmpty()) {
            throw new InvalidInputException("\u00c9 necess\u00e1rio fornecer pelo menos um ID de instrumento");
        }
        Page dateHourPage = this.readingRepository.findDistinctDateHourByMultipleInstrumentIds(instrumentIds, pageable);
        ArrayList allReadings = new ArrayList();
        for (Object[] dh : dateHourPage.getContent()) {
            LocalDate date = (LocalDate)dh[0];
            LocalTime hour = (LocalTime)dh[1];
            List readings = this.readingRepository.findByMultipleInstrumentIdsAndDateAndHourAndActiveTrue(instrumentIds, date, hour);
            List dtos = readings.stream().map(arg_0 -> this.mapToResponseDTOOptimized(arg_0)).collect(Collectors.toList());
            allReadings.addAll(dtos);
        }
        return new PagedReadingResponseDTO(allReadings, dateHourPage.getNumber(), dateHourPage.getSize(), dateHourPage.getTotalElements(), dateHourPage.getTotalPages(), dateHourPage.isLast(), dateHourPage.isFirst());
    }

    @Cacheable(value={"clientInstrumentLimitStatuses"}, key="#clientId + '_' + #limit", cacheManager="readingCacheManager")
    public List<InstrumentLimitStatusDTO> getAllInstrumentLimitStatusesByClientId(Long clientId, int limit) {
        this.clientRepository.findById((Object)clientId).orElseThrow(() -> new NotFoundException("Cliente n\u00e3o encontrado com ID: " + clientId));
        ArrayList<InstrumentLimitStatusDTO> results = new ArrayList<InstrumentLimitStatusDTO>();
        List activeInstruments = this.instrumentRepository.findByFiltersOptimized(null, null, null, Boolean.valueOf(true), clientId);
        for (InstrumentEntity instrument : activeInstruments) {
            List readingsOfMostRecentDate;
            LocalTime mostRecentHour;
            PageRequest pageable = PageRequest.of((int)0, (int)limit);
            List recentReadings = this.readingRepository.findTopNByInstrumentIdOrderByDateDescHourDesc(instrument.getId(), (Pageable)pageable);
            if (recentReadings.isEmpty()) {
                results.add(this.createInstrumentLimitStatusDTO(instrument, LimitStatusEnum.NORMAL, null));
                continue;
            }
            LocalDate mostRecentDate = recentReadings.stream().map(ReadingEntity::getDate).max(LocalDate::compareTo).orElse(null);
            if (mostRecentDate == null || (mostRecentHour = (LocalTime)(readingsOfMostRecentDate = recentReadings.stream().filter(r -> r.getDate().equals(mostRecentDate)).collect(Collectors.toList())).stream().map(ReadingEntity::getHour).max(LocalTime::compareTo).orElse(null)) == null) continue;
            List mostRecentReadings = readingsOfMostRecentDate.stream().filter(r -> r.getHour().equals(mostRecentHour)).collect(Collectors.toList());
            LimitStatusEnum mostCriticalStatus = this.findMostCriticalStatus(mostRecentReadings);
            String formattedDateTime = String.valueOf(mostRecentDate) + " " + String.valueOf(mostRecentHour);
            results.add(this.createInstrumentLimitStatusDTO(instrument, mostCriticalStatus, formattedDateTime));
        }
        return results;
    }

    private LimitStatusEnum findMostCriticalStatus(List<ReadingEntity> readings) {
        if (readings.stream().anyMatch(r -> r.getLimitStatus() == LimitStatusEnum.EMERGENCIA)) {
            return LimitStatusEnum.EMERGENCIA;
        }
        if (readings.stream().anyMatch(r -> r.getLimitStatus() == LimitStatusEnum.ALERTA)) {
            return LimitStatusEnum.ALERTA;
        }
        if (readings.stream().anyMatch(r -> r.getLimitStatus() == LimitStatusEnum.ATENCAO)) {
            return LimitStatusEnum.ATENCAO;
        }
        if (readings.stream().anyMatch(r -> r.getLimitStatus() == LimitStatusEnum.INFERIOR)) {
            return LimitStatusEnum.INFERIOR;
        }
        if (readings.stream().anyMatch(r -> r.getLimitStatus() == LimitStatusEnum.SUPERIOR)) {
            return LimitStatusEnum.SUPERIOR;
        }
        return LimitStatusEnum.NORMAL;
    }

    private InstrumentLimitStatusDTO createInstrumentLimitStatusDTO(InstrumentEntity instrument, LimitStatusEnum status, String lastReadingDate) {
        InstrumentLimitStatusDTO dto = new InstrumentLimitStatusDTO();
        dto.setInstrumentId(instrument.getId());
        dto.setInstrumentName(instrument.getName());
        dto.setInstrumentType(instrument.getInstrumentType().getName());
        dto.setDamId(instrument.getDam().getId());
        dto.setDamName(instrument.getDam().getName());
        dto.setClientId(instrument.getDam().getClient().getId());
        dto.setClientName(instrument.getDam().getClient().getName());
        dto.setLimitStatus(status);
        dto.setLastReadingDate(lastReadingDate);
        return dto;
    }

    public PagedReadingResponseDTO<ReadingResponseDTO> findByInstrumentId(Long instrumentId, Pageable pageable) {
        if (pageable.getSort().isUnsorted()) {
            pageable = PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"date", "hour"}));
        }
        Page readings = this.readingRepository.findByInstrumentIdOptimized(instrumentId, pageable);
        Page dtoPage = readings.map(arg_0 -> this.mapToResponseDTOOptimized(arg_0));
        return new PagedReadingResponseDTO(dtoPage.getContent(), dtoPage.getNumber(), dtoPage.getSize(), dtoPage.getTotalElements(), dtoPage.getTotalPages(), dtoPage.isLast(), dtoPage.isFirst());
    }

    @Cacheable(value={"readingsByOutput"}, key="#outputId", cacheManager="readingCacheManager")
    public List<ReadingResponseDTO> findByOutputId(Long outputId) {
        UserEntity userLogged;
        if (!AuthenticatedUserUtil.isAdmin() && !(userLogged = AuthenticatedUserUtil.getCurrentUser()).getInstrumentationPermission().getViewRead().booleanValue()) {
            throw new UnauthorizedException("Usu\u00e1rio n\u00e3o autorizado a visualizar leituras!");
        }
        List readings = this.readingRepository.findByOutputIdOptimized(outputId);
        return readings.stream().map(arg_0 -> this.mapToResponseDTOOptimized(arg_0)).collect(Collectors.toList());
    }

    @Cacheable(value={"readingsByFilters"}, key="#instrumentId + '_' + #outputId + '_' + #startDate + '_' + #endDate + '_' + #limitStatus + '_' + #active + '_' + #pageable.pageNumber + '_' + #pageable.pageSize", cacheManager="readingCacheManager")
    public PagedReadingResponseDTO<ReadingResponseDTO> findByFilters(Long instrumentId, Long outputId, LocalDate startDate, LocalDate endDate, LimitStatusEnum limitStatus, Boolean active, Pageable pageable) {
        UserEntity userLogged;
        if (!AuthenticatedUserUtil.isAdmin() && !(userLogged = AuthenticatedUserUtil.getCurrentUser()).getInstrumentationPermission().getViewRead().booleanValue()) {
            throw new UnauthorizedException("Usu\u00e1rio n\u00e3o autorizado a visualizar leituras!");
        }
        if (pageable.getSort().isUnsorted()) {
            pageable = PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"date", "hour"}));
        }
        Boolean activeFilter = active != null ? active : true;
        Page readings = this.readingRepository.findByFiltersOptimized(instrumentId, outputId, startDate, endDate, limitStatus, activeFilter, pageable);
        Page dtoPage = readings.map(arg_0 -> this.mapToResponseDTOOptimized(arg_0));
        return new PagedReadingResponseDTO(dtoPage.getContent(), dtoPage.getNumber(), dtoPage.getSize(), dtoPage.getTotalElements(), dtoPage.getTotalPages(), dtoPage.isLast(), dtoPage.isFirst());
    }

    @Cacheable(value={"readingById"}, key="#id", cacheManager="readingCacheManager")
    public ReadingEntity findById(Long id) {
        UserEntity userLogged;
        if (!AuthenticatedUserUtil.isAdmin() && !(userLogged = AuthenticatedUserUtil.getCurrentUser()).getInstrumentationPermission().getViewRead().booleanValue()) {
            throw new UnauthorizedException("Usu\u00e1rio n\u00e3o autorizado a visualizar leituras!");
        }
        ReadingEntity reading = (ReadingEntity)this.readingRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("Leitura n\u00e3o encontrada com ID: " + id));
        List inputValues = this.readingInputValueRepository.findByReadingId(id);
        reading.setInputValues(new HashSet(inputValues));
        return reading;
    }

    @Transactional
    @CacheEvict(value={"readingsByInstrument", "instrumentLimitStatus", "clientInstrumentLimitStatuses", "latestReadings", "readingExists", "multiInstrumentReadings", "groupedReadings"}, allEntries=true, cacheManager="readingCacheManager")
    public List<ReadingResponseDTO> create(Long instrumentId, ReadingRequestDTO request, boolean skipPermissionCheck) {
        UserEntity currentUser;
        LocalDateTime now;
        LocalTime truncatedHour = request.getHour().withNano(0);
        LocalDateTime readingDateTime = LocalDateTime.of(request.getDate(), truncatedHour);
        if (readingDateTime.isAfter(now = LocalDateTime.now())) {
            throw new InvalidInputException("N\u00e3o \u00e9 poss\u00edvel criar leituras com data e hora futura. Data/hora informada: " + DateFormatter.formatDateTime((LocalDateTime)readingDateTime) + ", Data/hora atual: " + DateFormatter.formatDateTime((LocalDateTime)now));
        }
        if (this.readingRepository.existsByInstrumentIdAndDateAndHourAndActive(instrumentId, request.getDate(), truncatedHour, Boolean.valueOf(true))) {
            throw new InvalidInputException("J\u00e1 existe leitura registrada para este instrumento na mesma data e hora (" + String.valueOf(request.getDate()) + " " + String.valueOf(truncatedHour) + ")");
        }
        request.setHour(truncatedHour);
        if (skipPermissionCheck) {
            String systemUserEmail = "noreply@geometrisa-prod.com.br";
            currentUser = (UserEntity)this.userRepository.findByEmail(systemUserEmail).orElseThrow(() -> new NotFoundException("Usu\u00e1rio do sistema n\u00e3o encontrado!"));
        } else {
            currentUser = AuthenticatedUserUtil.getCurrentUser();
            if (!AuthenticatedUserUtil.isAdmin() && !currentUser.getInstrumentationPermission().getEditRead().booleanValue()) {
                throw new UnauthorizedException("Usu\u00e1rio n\u00e3o autorizado a criar leituras!");
            }
        }
        InstrumentEntity instrument = (InstrumentEntity)this.instrumentRepository.findWithActiveOutputsById(instrumentId).orElseThrow(() -> new NotFoundException("Instrumento n\u00e3o encontrado com ID: " + instrumentId));
        List activeOutputs = instrument.getOutputs().stream().filter(OutputEntity::getActive).collect(Collectors.toList());
        if (activeOutputs.isEmpty()) {
            throw new NotFoundException("O instrumento n\u00e3o possui outputs ativos para calcular leituras");
        }
        this.validateInputValues(instrument, request.getInputValues());
        HashMap<String, Double> formattedInputValues = new HashMap<String, Double>();
        for (InputEntity input : instrument.getInputs()) {
            Double inputValue = (Double)request.getInputValues().get(input.getAcronym());
            if (inputValue == null) continue;
            Double d = this.formatToSpecificPrecision(inputValue, input.getPrecision());
            formattedInputValues.put(input.getAcronym(), d);
        }
        HashSet<ReadingInputValueEntity> sharedInputValues = new HashSet<ReadingInputValueEntity>();
        Map<String, String> inputNames = instrument.getInputs().stream().collect(Collectors.toMap(InputEntity::getAcronym, InputEntity::getName));
        for (Map.Entry entry : formattedInputValues.entrySet()) {
            ReadingInputValueEntity inputValue = new ReadingInputValueEntity();
            inputValue.setInputAcronym((String)entry.getKey());
            inputValue.setInputName(inputNames.get(entry.getKey()));
            inputValue.setValue((Double)entry.getValue());
            ReadingInputValueEntity savedInputValue = (ReadingInputValueEntity)this.readingInputValueRepository.save((Object)inputValue);
            sharedInputValues.add(savedInputValue);
        }
        ArrayList<ReadingEntity> createdReadings = new ArrayList<ReadingEntity>();
        for (OutputEntity output : activeOutputs) {
            Double calculatedValue = this.outputCalculationService.calculateOutput(output, request, formattedInputValues);
            ReadingEntity reading = new ReadingEntity();
            reading.setDate(request.getDate());
            reading.setHour(request.getHour());
            reading.setCalculatedValue(calculatedValue);
            reading.setInstrument(instrument);
            reading.setOutput(output);
            reading.setUser(currentUser);
            reading.setActive(Boolean.valueOf(true));
            reading.setComment(request.getComment());
            LimitStatusEnum limitStatus = this.determineLimitStatus(instrument, calculatedValue, output);
            reading.setLimitStatus(limitStatus);
            reading.setInputValues(sharedInputValues);
            ReadingEntity savedReading = (ReadingEntity)this.readingRepository.save((Object)reading);
            createdReadings.add(savedReading);
        }
        return createdReadings.stream().map(arg_0 -> this.mapToResponseDTO(arg_0)).collect(Collectors.toList());
    }

    @Cacheable(value={"multiInstrumentReadings"}, key="T(org.springframework.util.StringUtils).collectionToDelimitedString(#instrumentIds, '_') + '_' + T(org.springframework.util.StringUtils).collectionToDelimitedString(#outputIds, '_') + '_' + #startDate + '_' + #endDate + '_' + #pageSize", cacheManager="readingCacheManager")
    @Transactional(readOnly=true)
    public InstrumentReadingsDTO.MultiInstrumentReadingsResponseDTO findLatestReadingsForMultipleInstruments(List<Long> instrumentIds, List<Long> outputIds, LocalDate startDate, LocalDate endDate, int pageSize) {
        HashSet<Long> uniqueInstrumentIds = new HashSet<Long>();
        if (instrumentIds != null && !instrumentIds.isEmpty()) {
            uniqueInstrumentIds.addAll(instrumentIds);
        }
        if (outputIds != null && !outputIds.isEmpty()) {
            Set instrumentIdsFromOutputs = this.readingRepository.findInstrumentIdsByOutputIds(outputIds);
            uniqueInstrumentIds.addAll(instrumentIdsFromOutputs);
        }
        if (uniqueInstrumentIds.isEmpty()) {
            return new InstrumentReadingsDTO.MultiInstrumentReadingsResponseDTO(List.of(), pageSize, 0L);
        }
        List instruments = this.instrumentRepository.findAllById(uniqueInstrumentIds);
        ArrayList<InstrumentReadingsDTO> result = new ArrayList<InstrumentReadingsDTO>();
        for (InstrumentEntity instrument : instruments) {
            List readingIds = startDate != null && endDate != null ? this.readingRepository.findLatestReadingIdsByInstrumentIdAndDateRange(instrument.getId(), startDate, endDate, pageSize) : (startDate != null ? this.readingRepository.findLatestReadingIdsByInstrumentIdAndStartDate(instrument.getId(), startDate, pageSize) : (endDate != null ? this.readingRepository.findLatestReadingIdsByInstrumentIdAndEndDate(instrument.getId(), endDate, pageSize) : this.readingRepository.findLatestReadingIdsByInstrumentId(instrument.getId(), pageSize)));
            if (readingIds.isEmpty()) {
                result.add(new InstrumentReadingsDTO(instrument.getId(), instrument.getName(), instrument.getInstrumentType().getName(), List.of()));
                continue;
            }
            List readings = this.readingRepository.findByIdIn(readingIds);
            List readingDTOs = readings.stream().map(arg_0 -> this.mapToResponseDTOOptimized(arg_0)).collect(Collectors.toList());
            result.add(new InstrumentReadingsDTO(instrument.getId(), instrument.getName(), instrument.getInstrumentType().getName(), readingDTOs));
        }
        return new InstrumentReadingsDTO.MultiInstrumentReadingsResponseDTO(result, pageSize, (long)uniqueInstrumentIds.size());
    }

    private void validateInputValues(InstrumentEntity instrument, Map<String, Double> inputValues) {
        if (inputValues == null || inputValues.isEmpty()) {
            throw new InvalidInputException("\u00c9 necess\u00e1rio fornecer valores para os inputs");
        }
        Set requiredInputs = instrument.getInputs().stream().map(InputEntity::getAcronym).collect(Collectors.toSet());
        for (String inputAcronym : requiredInputs) {
            if (inputValues.containsKey(inputAcronym)) continue;
            throw new InvalidInputException("Valor n\u00e3o fornecido para o input '" + inputAcronym + "'");
        }
        for (String providedInput : inputValues.keySet()) {
            if (requiredInputs.contains(providedInput)) continue;
            throw new InvalidInputException("Input '" + providedInput + "' n\u00e3o existe neste instrumento");
        }
    }

    private List<ReadingInputValueDTO> getInputValuesForReading(ReadingEntity reading) {
        List inputValues = this.readingInputValueRepository.findByReadingId(reading.getId());
        return inputValues.stream().map(arg_0 -> this.mapToInputValueDTO(arg_0)).collect(Collectors.toList());
    }

    @Transactional
    @CacheEvict(value={"readingById", "readingResponseDTO", "readingsByInstrument", "readingsByOutput", "readingsByFilters", "instrumentLimitStatus", "clientInstrumentLimitStatuses", "latestReadings", "groupedReadings", "multiInstrumentReadings"}, allEntries=true, cacheManager="readingCacheManager")
    public ReadingResponseDTO updateReading(Long id, UpdateReadingRequestDTO request) {
        boolean isDateTimeChanged;
        LocalTime newHour;
        boolean isUpdatingInputValues;
        UserEntity userLogged;
        if (!AuthenticatedUserUtil.isAdmin() && !(userLogged = AuthenticatedUserUtil.getCurrentUser()).getInstrumentationPermission().getEditRead().booleanValue()) {
            throw new UnauthorizedException("Usu\u00e1rio n\u00e3o autorizado a editar leituras!");
        }
        ReadingEntity reading = (ReadingEntity)this.readingRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("Leitura n\u00e3o encontrada com ID: " + id));
        if (!reading.getActive().booleanValue()) {
            throw new InvalidInputException("N\u00e3o \u00e9 poss\u00edvel editar uma leitura inativa");
        }
        InstrumentEntity instrument = reading.getInstrument();
        boolean bl = isUpdatingInputValues = request.getInputValues() != null && !request.getInputValues().isEmpty();
        if (isUpdatingInputValues) {
            LocalDateTime readingDateTime = LocalDateTime.of(reading.getDate(), reading.getHour());
            if (instrument.getLastUpdateVariablesDate() != null && instrument.getLastUpdateVariablesDate().isAfter(readingDateTime)) {
                throw new InvalidInputException("N\u00e3o \u00e9 poss\u00edvel editar os valores desta leitura pois as vari\u00e1veis do instrumento foram alteradas ap\u00f3s o registro.");
            }
        }
        LocalDate originalDate = reading.getDate();
        LocalTime originalHour = reading.getHour();
        Long instrumentId = instrument.getId();
        LocalDate newDate = request.getDate() != null ? request.getDate() : originalDate;
        LocalTime localTime = newHour = request.getHour() != null ? request.getHour() : originalHour;
        if (newHour != null) {
            newHour = newHour.withNano(0);
        }
        boolean bl2 = isDateTimeChanged = request.getDate() != null && !Objects.equals(newDate, originalDate) || request.getHour() != null && !Objects.equals(newHour, originalHour);
        if (isDateTimeChanged) {
            LocalDateTime now;
            LocalDateTime newDateTime = LocalDateTime.of(newDate, newHour);
            if (newDateTime.isAfter(now = LocalDateTime.now())) {
                throw new InvalidInputException("N\u00e3o \u00e9 poss\u00edvel atualizar leituras para data e hora futura. Data/hora informada: " + DateFormatter.formatDateTime((LocalDateTime)newDateTime) + ", Data/hora atual: " + DateFormatter.formatDateTime((LocalDateTime)now));
            }
            List existingReadings = originalDate == null || originalHour == null ? this.readingRepository.findByInstrumentIdAndDateAndHourActiveTrue(instrumentId, newDate, newHour) : this.readingRepository.findByInstrumentIdAndDateAndHourExcludingSpecific(instrumentId, newDate, newHour, originalDate, originalHour);
            if (!existingReadings.isEmpty()) {
                throw new InvalidInputException("J\u00e1 existe leitura registrada para este instrumento na mesma data e hora (" + String.valueOf(newDate) + " " + String.valueOf(newHour) + ")");
            }
        }
        UserEntity newUser = null;
        if (request.getUserId() != null) {
            newUser = (UserEntity)this.userRepository.findById((Object)request.getUserId()).orElseThrow(() -> new NotFoundException("Usu\u00e1rio n\u00e3o encontrado com ID: " + request.getUserId()));
        }
        if (isUpdatingInputValues) {
            this.updateInputValues(instrumentId, originalDate, originalHour, request.getInputValues());
        }
        List groupReadings = this.readingRepository.findAllReadingsInGroup(instrumentId, originalDate, originalHour);
        boolean isUpdatingComment = request.getComment() != null;
        for (ReadingEntity groupReading : groupReadings) {
            boolean changed = false;
            if (isDateTimeChanged) {
                groupReading.setDate(newDate);
                groupReading.setHour(newHour);
                changed = true;
            }
            if (newUser != null) {
                groupReading.setUser(newUser);
                changed = true;
            }
            if (isUpdatingComment) {
                groupReading.setComment(request.getComment());
                changed = true;
            }
            if (!changed) continue;
            this.readingRepository.save((Object)groupReading);
            log.info("Atualizada reading {} com data/hora/usu\u00e1rio/coment\u00e1rio", (Object)groupReading.getId());
        }
        ReadingEntity updatedReading = (ReadingEntity)this.readingRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("Leitura n\u00e3o encontrada ap\u00f3s atualiza\u00e7\u00e3o"));
        return this.mapToResponseDTO(updatedReading);
    }

    private void updateInputValues(Long instrumentId, LocalDate date, LocalTime hour, Map<String, Double> newInputValues) {
        List groupReadings = this.readingRepository.findAllReadingsInGroup(instrumentId, date, hour);
        if (groupReadings.isEmpty()) {
            throw new NotFoundException("N\u00e3o foram encontradas leituras para este grupo");
        }
        log.info("Atualizando valores de input para {} leituras do grupo {}/{}", new Object[]{groupReadings.size(), date, hour});
        InstrumentEntity instrument = (InstrumentEntity)this.instrumentRepository.findById((Object)instrumentId).orElseThrow(() -> new NotFoundException("Instrumento n\u00e3o encontrado"));
        Map<String, InputEntity> instrumentInputs = instrument.getInputs().stream().collect(Collectors.toMap(InputEntity::getAcronym, input -> input));
        for (String string : newInputValues.keySet()) {
            if (instrumentInputs.containsKey(string)) continue;
            throw new InvalidInputException("Input com acr\u00f4nimo '" + string + "' n\u00e3o encontrado no instrumento");
        }
        HashSet uniqueInputValues = new HashSet();
        for (ReadingEntity reading : groupReadings) {
            uniqueInputValues.addAll(reading.getInputValues());
        }
        Map<String, ReadingInputValueEntity> map = uniqueInputValues.stream().collect(Collectors.toMap(ReadingInputValueEntity::getInputAcronym, value -> value));
        HashMap<String, Double> calculationInputs = new HashMap<String, Double>();
        for (ReadingInputValueEntity value2 : uniqueInputValues) {
            calculationInputs.put(value2.getInputAcronym(), value2.getValue());
        }
        boolean inputsChanged = false;
        for (Map.Entry<String, Double> entry : newInputValues.entrySet()) {
            String acronym = entry.getKey();
            Double newValue = entry.getValue();
            Double oldValue = (Double)calculationInputs.get(acronym);
            if (Objects.equals(oldValue, newValue)) continue;
            inputsChanged = true;
            calculationInputs.put(acronym, newValue);
            ReadingInputValueEntity inputValue = map.get(acronym);
            if (inputValue == null) continue;
            log.info("Atualizando valor para {}: {} \u2192 {}", new Object[]{acronym, oldValue, newValue});
            inputValue.setValue(newValue);
            this.readingInputValueRepository.save((Object)inputValue);
        }
        if (inputsChanged) {
            log.info("Recalculando valores para todas as {} readings do grupo", (Object)groupReadings.size());
            for (ReadingEntity reading : groupReadings) {
                OutputEntity output = reading.getOutput();
                Double oldValue = reading.getCalculatedValue();
                Double newCalculatedValue = this.outputCalculationService.calculateOutput(output, null, calculationInputs);
                reading.setCalculatedValue(newCalculatedValue);
                LimitStatusEnum newLimitStatus = this.determineLimitStatus(instrument, newCalculatedValue, output);
                reading.setLimitStatus(newLimitStatus);
                log.info("Reading {}: Output {} recalculado: {} \u2192 {}", new Object[]{reading.getId(), output.getAcronym(), oldValue, newCalculatedValue});
                this.readingRepository.save((Object)reading);
            }
        } else {
            log.info("Nenhum valor de input foi alterado, n\u00e3o \u00e9 necess\u00e1rio recalcular");
        }
    }

    private ReadingInputValueDTO mapToInputValueDTO(ReadingInputValueEntity entity) {
        ReadingInputValueDTO dto = new ReadingInputValueDTO();
        dto.setInputAcronym(entity.getInputAcronym());
        dto.setInputName(entity.getInputName());
        dto.setValue(entity.getValue());
        return dto;
    }

    @Transactional
    @CacheEvict(value={"readingById", "readingResponseDTO", "readingsByInstrument", "readingsByOutput", "readingsByFilters", "instrumentLimitStatus", "clientInstrumentLimitStatuses", "latestReadings", "groupedReadings", "multiInstrumentReadings"}, allEntries=true, cacheManager="readingCacheManager")
    public BulkToggleActiveResponseDTO bulkToggleActive(Boolean active, List<Long> readingIds) {
        UserEntity userLogged;
        if (!AuthenticatedUserUtil.isAdmin() && !(userLogged = AuthenticatedUserUtil.getCurrentUser()).getInstrumentationPermission().getEditRead().booleanValue()) {
            throw new UnauthorizedException("Usu\u00e1rio n\u00e3o autorizado a alterar status de leituras!");
        }
        ArrayList<Long> successfulIds = new ArrayList<Long>();
        ArrayList<BulkToggleActiveResponseDTO.FailedOperation> failedOperations = new ArrayList<BulkToggleActiveResponseDTO.FailedOperation>();
        for (Long readingId : readingIds) {
            try {
                ReadingEntity reading = (ReadingEntity)this.readingRepository.findById((Object)readingId).orElseThrow(() -> new NotFoundException("Leitura n\u00e3o encontrada com ID: " + readingId));
                reading.setActive(active);
                this.readingRepository.save((Object)reading);
                successfulIds.add(readingId);
            }
            catch (Exception e) {
                String errorMessage = e.getMessage();
                if (errorMessage == null || errorMessage.isEmpty()) {
                    errorMessage = "Erro interno do servidor";
                }
                failedOperations.add(new BulkToggleActiveResponseDTO.FailedOperation(readingId, errorMessage));
            }
        }
        BulkToggleActiveResponseDTO response = new BulkToggleActiveResponseDTO();
        response.setSuccessfulIds(successfulIds);
        response.setFailedOperations(failedOperations);
        response.setTotalProcessed(readingIds.size());
        response.setSuccessCount(successfulIds.size());
        response.setFailureCount(failedOperations.size());
        return response;
    }

    @Transactional
    @CacheEvict(value={"readingById", "readingResponseDTO", "readingsByInstrument", "readingsByOutput", "readingsByFilters", "instrumentLimitStatus", "clientInstrumentLimitStatuses", "latestReadings", "readingExists", "groupedReadings", "multiInstrumentReadings"}, allEntries=true, cacheManager="readingCacheManager")
    public void delete(Long id) {
        UserEntity userLogged;
        if (!AuthenticatedUserUtil.isAdmin() && !(userLogged = AuthenticatedUserUtil.getCurrentUser()).getInstrumentationPermission().getEditRead().booleanValue()) {
            throw new UnauthorizedException("Usu\u00e1rio n\u00e3o autorizado a excluir leituras!");
        }
        ReadingEntity reading = (ReadingEntity)this.readingRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("Leitura n\u00e3o encontrada com ID: " + id));
        HashSet inputValues = new HashSet(reading.getInputValues());
        reading.getInputValues().clear();
        this.readingRepository.save((Object)reading);
        for (ReadingInputValueEntity inputValue : inputValues) {
            inputValue.getReadings().remove(reading);
            if (inputValue.getReadings().isEmpty()) {
                this.readingInputValueRepository.delete((Object)inputValue);
                continue;
            }
            this.readingInputValueRepository.save((Object)inputValue);
        }
        this.readingRepository.delete((Object)reading);
        log.info("Leitura exclu\u00edda: ID {}", (Object)id);
    }

    private LimitStatusEnum determineLimitStatus(InstrumentEntity instrument, Double value, OutputEntity output) {
        if (Boolean.TRUE.equals(instrument.getNoLimit())) {
            return LimitStatusEnum.NORMAL;
        }
        StatisticalLimitEntity statisticalLimit = output.getStatisticalLimit();
        if (statisticalLimit != null) {
            if (statisticalLimit.getLowerValue() != null && value < statisticalLimit.getLowerValue()) {
                return LimitStatusEnum.INFERIOR;
            }
            if (statisticalLimit.getUpperValue() != null && value > statisticalLimit.getUpperValue()) {
                return LimitStatusEnum.SUPERIOR;
            }
            return LimitStatusEnum.NORMAL;
        }
        DeterministicLimitEntity deterministicLimit = output.getDeterministicLimit();
        if (deterministicLimit != null) {
            if (deterministicLimit.getEmergencyValue() != null && value >= deterministicLimit.getEmergencyValue()) {
                return LimitStatusEnum.EMERGENCIA;
            }
            if (deterministicLimit.getAlertValue() != null && value >= deterministicLimit.getAlertValue()) {
                return LimitStatusEnum.ALERTA;
            }
            if (deterministicLimit.getAttentionValue() != null && value >= deterministicLimit.getAttentionValue()) {
                return LimitStatusEnum.ATENCAO;
            }
            return LimitStatusEnum.NORMAL;
        }
        return LimitStatusEnum.NORMAL;
    }

    @Cacheable(value={"readingResponseDTO"}, key="#reading.id", cacheManager="readingCacheManager")
    public ReadingResponseDTO mapToResponseDTO(ReadingEntity reading) {
        ReadingResponseDTO dto = new ReadingResponseDTO();
        dto.setId(reading.getId());
        dto.setDate(reading.getDate());
        dto.setHour(reading.getHour());
        dto.setCalculatedValue(reading.getCalculatedValue());
        dto.setLimitStatus(reading.getLimitStatus());
        dto.setInstrumentId(reading.getInstrument().getId());
        dto.setInstrumentName(reading.getInstrument().getName());
        dto.setOutputId(reading.getOutput().getId());
        dto.setOutputName(reading.getOutput().getName());
        dto.setOutputAcronym(reading.getOutput().getAcronym());
        dto.setComment(reading.getComment());
        dto.setActive(reading.getActive());
        if (reading.getUser() != null) {
            dto.setCreatedBy(new ReadingResponseDTO.UserInfoDTO(reading.getUser().getId(), reading.getUser().getName(), reading.getUser().getEmail()));
        }
        dto.setInputValues(this.getInputValuesForReading(reading));
        return dto;
    }

    @Cacheable(value={"groupedReadings"}, key="#instrumentId + '_' + #active + '_' + #pageable.pageNumber + '_' + #pageable.pageSize", cacheManager="readingCacheManager")
    public PagedReadingResponseDTO<ReadingResponseDTO> findGroupedReadingsFlatByInstrument(Long instrumentId, Boolean active, Pageable pageable) {
        UserEntity userLogged;
        if (!AuthenticatedUserUtil.isAdmin() && !(userLogged = AuthenticatedUserUtil.getCurrentUser()).getInstrumentationPermission().getViewRead().booleanValue()) {
            throw new UnauthorizedException("Usu\u00e1rio n\u00e3o tem permiss\u00e3o para visualizar leituras");
        }
        Page dateHourPage = this.readingRepository.findDistinctDateHourByInstrumentIdAndActive(instrumentId, active, pageable);
        ArrayList allReadings = new ArrayList();
        for (Object[] dh : dateHourPage.getContent()) {
            LocalDate date = (LocalDate)dh[0];
            LocalTime hour = (LocalTime)dh[1];
            List readings = this.readingRepository.findByInstrumentIdAndDateAndHourAndActive(instrumentId, date, hour, active);
            List dtos = readings.stream().map(arg_0 -> this.mapToResponseDTOOptimized(arg_0)).collect(Collectors.toList());
            allReadings.addAll(dtos);
        }
        return new PagedReadingResponseDTO(allReadings, dateHourPage.getNumber(), dateHourPage.getSize(), dateHourPage.getTotalElements(), dateHourPage.getTotalPages(), dateHourPage.isLast(), dateHourPage.isFirst());
    }

    private ReadingResponseDTO mapToResponseDTOOptimized(ReadingEntity reading) {
        ReadingResponseDTO dto = new ReadingResponseDTO();
        dto.setId(reading.getId());
        dto.setDate(reading.getDate());
        dto.setHour(reading.getHour());
        dto.setCalculatedValue(reading.getCalculatedValue());
        dto.setLimitStatus(reading.getLimitStatus());
        dto.setInstrumentId(reading.getInstrument().getId());
        dto.setInstrumentName(reading.getInstrument().getName());
        dto.setOutputId(reading.getOutput().getId());
        dto.setOutputName(reading.getOutput().getName());
        dto.setOutputAcronym(reading.getOutput().getAcronym());
        dto.setComment(reading.getComment());
        dto.setActive(reading.getActive());
        if (reading.getUser() != null) {
            dto.setCreatedBy(new ReadingResponseDTO.UserInfoDTO(reading.getUser().getId(), reading.getUser().getName(), reading.getUser().getEmail()));
        }
        List inputValueDTOs = reading.getInputValues().stream().map(arg_0 -> this.mapToInputValueDTO(arg_0)).collect(Collectors.toList());
        dto.setInputValues(inputValueDTOs);
        return dto;
    }

    private Double formatToSpecificPrecision(Double value, Integer precision) {
        if (value == null || precision == null) {
            return value;
        }
        BigDecimal bd = BigDecimal.valueOf(value);
        bd = bd.setScale((int)precision, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }

    @Cacheable(value={"clientInstrumentLatestGroupedReadings"}, key="#clientId + '_' + #limit", cacheManager="readingCacheManager")
    @Transactional(readOnly=true)
    public List<InstrumentGroupedReadingsDTO> findLatestGroupedReadingsByClientId(Long clientId, int limit) {
        List latestDateHours = this.readingRepository.findLatestDistinctDateHoursByClientId(clientId, limit);
        if (latestDateHours.isEmpty()) {
            return List.of();
        }
        HashMap<Long, List> instrumentDateHoursMap = new HashMap<Long, List>();
        for (Object[] row : latestDateHours) {
            Long instrumentId = ((Number)row[0]).longValue();
            Date sqlDate = (Date)row[1];
            Time sqlTime = (Time)row[2];
            LocalDate date = sqlDate.toLocalDate();
            LocalTime hour = sqlTime.toLocalTime();
            instrumentDateHoursMap.computeIfAbsent(instrumentId, k -> new ArrayList()).add(new Object[]{date, hour});
        }
        ArrayList<InstrumentGroupedReadingsDTO> result = new ArrayList<InstrumentGroupedReadingsDTO>();
        for (Map.Entry entry : instrumentDateHoursMap.entrySet()) {
            Long instrumentId = (Long)entry.getKey();
            List dateHours = (List)entry.getValue();
            InstrumentEntity instrument = (InstrumentEntity)this.instrumentRepository.findById((Object)instrumentId).orElseThrow(() -> new NotFoundException("Instrumento n\u00e3o encontrado com ID: " + instrumentId));
            InstrumentGroupedReadingsDTO instrumentDTO = new InstrumentGroupedReadingsDTO();
            instrumentDTO.setInstrumentId(instrument.getId());
            instrumentDTO.setInstrumentName(instrument.getName());
            instrumentDTO.setInstrumentType(instrument.getInstrumentType().getName());
            instrumentDTO.setDamId(instrument.getDam().getId());
            instrumentDTO.setDamName(instrument.getDam().getName());
            instrumentDTO.setGroupedReadings(new ArrayList());
            for (Object[] dateHour : dateHours) {
                LocalTime hour;
                LocalDate date = (LocalDate)dateHour[0];
                List readings = this.readingRepository.findByInstrumentIdAndDateAndHourAndActiveTrue(instrumentId, date, hour = (LocalTime)dateHour[1]);
                if (readings.isEmpty()) continue;
                String dateHourKey = date.toString() + " " + hour.toString();
                InstrumentGroupedReadingsDTO.GroupedDateHourReadingsDTO group = new InstrumentGroupedReadingsDTO.GroupedDateHourReadingsDTO();
                group.setDateTime(dateHourKey);
                List readingDTOs = readings.stream().map(arg_0 -> this.mapToResponseDTOOptimized(arg_0)).collect(Collectors.toList());
                group.setReadings(readingDTOs);
                instrumentDTO.getGroupedReadings().add(group);
            }
            result.add(instrumentDTO);
        }
        return result;
    }

    @Generated
    public ReadingService(ReadingRepository readingRepository, ReadingInputValueRepository readingInputValueRepository, InstrumentRepository instrumentRepository, OutputCalculationService outputCalculationService, ClientRepository clientRepository, UserRepository userRepository) {
        this.readingRepository = readingRepository;
        this.readingInputValueRepository = readingInputValueRepository;
        this.instrumentRepository = instrumentRepository;
        this.outputCalculationService = outputCalculationService;
        this.clientRepository = clientRepository;
        this.userRepository = userRepository;
    }
}

