/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.reading.services;

import com.geosegbar.exceptions.InvalidInputException;
import com.geosegbar.infra.reading.dtos.ImportReadingsResult;
import com.geosegbar.infra.reading.dtos.ReadingRequestDTO;
import com.geosegbar.infra.reading.services.ReadingService;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class BulkReadingImportService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BulkReadingImportService.class);
    private final ReadingService readingService;
    private static final DateTimeFormatter DATE_FMT = DateTimeFormatter.ofPattern("[yyyy-MM-dd][dd-MM-yyyy][dd/MM/yyyy]");
    private static final DateTimeFormatter TIME_FMT = DateTimeFormatter.ofPattern("[HH:mm:ss][HH:mm]");

    public ImportReadingsResult importFromExcel(Long instrumentId, MultipartFile file) {
        ImportReadingsResult result = new ImportReadingsResult();
        if (instrumentId == null) {
            throw new InvalidInputException("ID do instrumento n\u00e3o fornecido. Por favor, informe o instrumento para importa\u00e7\u00e3o das leituras.");
        }
        if (file == null || file.isEmpty()) {
            throw new InvalidInputException("Nenhum arquivo foi enviado. Por favor, selecione uma planilha Excel v\u00e1lida.");
        }
        String fileName = file.getOriginalFilename();
        if (fileName == null || !fileName.endsWith(".xlsx") && !fileName.endsWith(".xls")) {
            throw new InvalidInputException("Formato de arquivo inv\u00e1lido. Por favor, envie um arquivo Excel (.xlsx ou .xls).");
        }
        try (InputStream is = file.getInputStream();){
            Workbook wb;
            try {
                wb = WorkbookFactory.create((InputStream)is);
            }
            catch (Exception e) {
                throw new InvalidInputException("N\u00e3o foi poss\u00edvel abrir o arquivo Excel. Verifique se o arquivo est\u00e1 corrompido ou se \u00e9 uma planilha Excel v\u00e1lida.");
            }
            Sheet sheet = wb.getSheet("Leituras");
            if (sheet == null) {
                throw new InvalidInputException("Aba 'Leituras' n\u00e3o encontrada. Por favor, use o modelo de planilha correto que contenha uma aba chamada 'Leituras'.");
            }
            if (sheet.getPhysicalNumberOfRows() <= 1) {
                throw new InvalidInputException("A planilha n\u00e3o cont\u00e9m dados de leituras para importar. A aba 'Leituras' est\u00e1 vazia ou cont\u00e9m apenas o cabe\u00e7alho.");
            }
            Row header = sheet.getRow(0);
            if (header == null) {
                throw new InvalidInputException("Cabe\u00e7alho n\u00e3o encontrado na aba 'Leituras'. Verifique se a planilha est\u00e1 no formato correto.");
            }
            HashMap<String, Integer> idx = new HashMap<String, Integer>();
            for (Cell c : header) {
                String h;
                if (c.getCellType() != CellType.STRING || (h = c.getStringCellValue().trim()).isEmpty()) continue;
                idx.put(h, c.getColumnIndex());
            }
            Integer idxDate = (Integer)idx.get("Data da Leitura");
            Integer idxHour = (Integer)idx.get("Hora da Leitura");
            if (idxDate == null || idxHour == null) {
                throw new InvalidInputException("Colunas obrigat\u00f3rias n\u00e3o encontradas: 'Data da Leitura' e/ou 'Hora da Leitura'. Verifique se est\u00e1 usando o modelo de planilha correto.");
            }
            List<String> inputAcronyms = idx.keySet().stream().filter(col -> !col.equals("Data da Leitura") && !col.equals("Hora da Leitura")).toList();
            if (inputAcronyms.isEmpty()) {
                throw new InvalidInputException("Nenhuma coluna de leitura encontrada al\u00e9m de 'Data da Leitura' e 'Hora da Leitura'. A planilha deve conter ao menos uma coluna adicional com valores de leitura.");
            }
            int total = 0;
            for (int rn = 1; rn <= sheet.getLastRowNum(); ++rn) {
                Row r = sheet.getRow(rn);
                if (r == null) continue;
                Cell dCell = r.getCell(idxDate.intValue());
                Cell tCell = r.getCell(idxHour.intValue());
                if (!(dCell != null && dCell.getCellType() != CellType.BLANK || tCell != null && tCell.getCellType() != CellType.BLANK)) continue;
                ++total;
                try {
                    LocalTime hour;
                    LocalDate date;
                    if (dCell == null) {
                        throw new InvalidInputException("Data da Leitura n\u00e3o informada");
                    }
                    try {
                        if (dCell.getCellType() == CellType.NUMERIC && DateUtil.isCellDateFormatted((Cell)dCell)) {
                            date = dCell.getLocalDateTimeCellValue().toLocalDate();
                        } else {
                            String s = dCell.getStringCellValue().trim();
                            date = LocalDate.parse(s, DATE_FMT);
                        }
                    }
                    catch (IllegalStateException | DateTimeParseException e) {
                        throw new InvalidInputException("Data da Leitura em formato inv\u00e1lido. Use o formato DD/MM/YYYY.");
                    }
                    if (tCell == null) {
                        throw new InvalidInputException("Hora da Leitura n\u00e3o informada");
                    }
                    try {
                        if (tCell.getCellType() == CellType.NUMERIC && DateUtil.isCellDateFormatted((Cell)tCell)) {
                            double frac = tCell.getNumericCellValue();
                            hour = LocalTime.ofSecondOfDay((long)(frac * 24.0 * 3600.0));
                        } else {
                            String s = tCell.getStringCellValue().trim();
                            hour = LocalTime.parse(s, TIME_FMT);
                        }
                    }
                    catch (IllegalStateException | DateTimeParseException e) {
                        throw new InvalidInputException("Hora da Leitura em formato inv\u00e1lido. Use o formato HH:MM ou HH:MM:SS.");
                    }
                    HashMap<String, Double> inputValues = new HashMap<String, Double>();
                    for (String acr : inputAcronyms) {
                        double v;
                        Cell c = r.getCell(((Integer)idx.get(acr)).intValue());
                        if (c == null) {
                            throw new InvalidInputException("Coluna '" + acr + "' vazia");
                        }
                        try {
                            if (c.getCellType() == CellType.NUMERIC) {
                                v = c.getNumericCellValue();
                            } else {
                                String ss = c.getStringCellValue().trim().replace(",", ".");
                                v = Double.parseDouble(ss);
                            }
                        }
                        catch (IllegalStateException | NumberFormatException ex) {
                            throw new InvalidInputException("Valor de '" + acr + "' inv\u00e1lido: " + (c.getCellType() == CellType.STRING ? c.getStringCellValue() : "n\u00e3o \u00e9 um n\u00famero"));
                        }
                        inputValues.put(acr, v);
                    }
                    ReadingRequestDTO req = new ReadingRequestDTO(date, hour, inputValues, null);
                    this.readingService.create(instrumentId, req, false);
                    result.setSuccessCount(result.getSuccessCount() + 1);
                    continue;
                }
                catch (Exception ex) {
                    result.setFailureCount(result.getFailureCount() + 1);
                    result.getErrors().add("Linha " + (rn + 1) + ": " + ex.getMessage());
                    log.warn("Falha importando linha {}: {}", (Object)(rn + 1), (Object)ex.getMessage());
                }
            }
            result.setTotalRows(total);
            if (total == 0) {
                throw new InvalidInputException("Nenhuma leitura encontrada na planilha. Verifique se os dados est\u00e3o formatados corretamente.");
            }
        }
        catch (InvalidInputException e) {
            throw e;
        }
        catch (IOException e) {
            throw new InvalidInputException("Erro ao ler o arquivo Excel: " + e.getMessage());
        }
        catch (Exception e) {
            String detailedMessage = e.getMessage();
            Object friendlyMessage = "Erro ao processar a planilha Excel. ";
            friendlyMessage = detailedMessage != null && detailedMessage.contains("iterator()") && detailedMessage.contains("null") ? (String)friendlyMessage + "Uma ou mais abas necess\u00e1rias n\u00e3o foram encontradas. Certifique-se de usar o modelo de planilha correto com a aba 'Leituras'." : (detailedMessage != null && detailedMessage.contains("Invalid header signature") ? (String)friendlyMessage + "O arquivo n\u00e3o \u00e9 uma planilha Excel v\u00e1lida ou est\u00e1 corrompido." : (String)friendlyMessage + "Detalhes: " + detailedMessage);
            throw new InvalidInputException((String)friendlyMessage);
        }
        return result;
    }

    @Generated
    public BulkReadingImportService(ReadingService readingService) {
        this.readingService = readingService;
    }
}

