/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.instrument_tabulate_pattern_folder.web;

import com.geosegbar.common.response.WebResponseEntity;
import com.geosegbar.infra.instrument_tabulate_pattern_folder.dtos.CreateTabulateFolderRequestDTO;
import com.geosegbar.infra.instrument_tabulate_pattern_folder.dtos.DamTabulateFoldersWithPatternsDetailResponseDTO;
import com.geosegbar.infra.instrument_tabulate_pattern_folder.dtos.TabulateFolderResponseDTO;
import com.geosegbar.infra.instrument_tabulate_pattern_folder.dtos.UpdateFolderNameDTO;
import com.geosegbar.infra.instrument_tabulate_pattern_folder.services.InstrumentTabulatePatternFolderService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tabulate-pattern-folders"})
public class InstrumentTabulatePatternFolderController {
    private final InstrumentTabulatePatternFolderService folderService;

    @PostMapping
    public ResponseEntity<WebResponseEntity<TabulateFolderResponseDTO>> createFolder(@Valid @RequestBody CreateTabulateFolderRequestDTO request) {
        TabulateFolderResponseDTO dto = this.folderService.create(request);
        return new ResponseEntity((Object)WebResponseEntity.success((Object)dto, (String)"Pasta de padr\u00f5es de tabela criada com sucesso!"), (HttpStatusCode)HttpStatus.CREATED);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<Void>> deleteFolder(@PathVariable Long id) {
        this.folderService.delete(id);
        return ResponseEntity.ok((Object)WebResponseEntity.success(null, (String)"Pasta de padr\u00f5es de tabela exclu\u00edda com sucesso!"));
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<TabulateFolderResponseDTO>> updateFolderName(@PathVariable Long id, @Valid @RequestBody UpdateFolderNameDTO request) {
        TabulateFolderResponseDTO dto = this.folderService.updateFolderName(id, request.getName());
        return ResponseEntity.ok((Object)WebResponseEntity.success((Object)dto, (String)"Pasta de padr\u00f5es de tabela atualizada com sucesso!"));
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<TabulateFolderResponseDTO>> getFolderById(@PathVariable Long id) {
        TabulateFolderResponseDTO dto = this.folderService.findByIdSimple(id);
        return ResponseEntity.ok((Object)WebResponseEntity.success((Object)dto, (String)"Pasta de padr\u00f5es de tabela obtida com sucesso!"));
    }

    @GetMapping(value={"/dam/{damId}"})
    public ResponseEntity<WebResponseEntity<List<TabulateFolderResponseDTO>>> getFoldersByDam(@PathVariable Long damId) {
        List dto = this.folderService.findByDamId(damId);
        return ResponseEntity.ok((Object)WebResponseEntity.success((Object)dto, (String)"Pastas de padr\u00f5es de tabela da barragem obtidas com sucesso!"));
    }

    @GetMapping(value={"/dam/{damId}/patterns-detail"})
    public ResponseEntity<WebResponseEntity<DamTabulateFoldersWithPatternsDetailResponseDTO>> getDamFoldersWithPatternsDetail(@PathVariable Long damId) {
        DamTabulateFoldersWithPatternsDetailResponseDTO dto = this.folderService.findFoldersWithPatternsDetailsByDam(damId);
        return ResponseEntity.ok((Object)WebResponseEntity.success((Object)dto, (String)"Pastas de padr\u00f5es de tabela com detalhes obtidas com sucesso!"));
    }

    @Generated
    public InstrumentTabulatePatternFolderController(InstrumentTabulatePatternFolderService folderService) {
        this.folderService = folderService;
    }
}

