/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.instrument.persistence.jpa;

import com.geosegbar.entities.DamEntity;
import com.geosegbar.entities.InstrumentEntity;
import com.geosegbar.entities.SectionEntity;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.EntityGraph;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface InstrumentRepository
extends JpaRepository<InstrumentEntity, Long> {
    @EntityGraph(attributePaths={"dam", "section", "instrumentType"})
    public List<InstrumentEntity> findAllByOrderByNameAsc();

    @EntityGraph(attributePaths={"dam", "section", "instrumentType"})
    public List<InstrumentEntity> findByDamId(Long var1);

    public List<InstrumentEntity> findByDam(DamEntity var1);

    public List<InstrumentEntity> findBySectionId(Long var1);

    public List<InstrumentEntity> findBySection(SectionEntity var1);

    public Optional<InstrumentEntity> findByNameAndDamId(String var1, Long var2);

    public boolean existsByNameAndDamId(String var1, Long var2);

    public boolean existsByNameAndDamIdAndIdNot(String var1, Long var2, Long var3);

    @Query(value="SELECT i.id FROM InstrumentEntity i WHERE i.dam.id = :damId")
    public List<Long> findInstrumentIdsByDamId(@Param(value="damId") Long var1);

    @EntityGraph(attributePaths={"inputs", "constants", "outputs"})
    public Optional<InstrumentEntity> findWithIOCById(Long var1);

    @EntityGraph(attributePaths={"inputs", "constants", "outputs", "outputs.statisticalLimit", "outputs.deterministicLimit"})
    @Query(value="SELECT i FROM InstrumentEntity i LEFT JOIN FETCH i.outputs o WHERE i.id = :id AND (o.active = true OR o IS NULL)")
    public Optional<InstrumentEntity> findWithActiveOutputsById(@Param(value="id") Long var1);

    @Query(value="SELECT i FROM InstrumentEntity i WHERE i.dam.client.id = :clientId")
    public List<InstrumentEntity> findByClientId(@Param(value="clientId") Long var1);

    @EntityGraph(attributePaths={"inputs", "constants", "outputs", "outputs.statisticalLimit", "outputs.deterministicLimit"})
    @Query(value="SELECT i FROM InstrumentEntity i WHERE i.dam.client.id = :clientId AND (:active IS NULL OR i.active = :active)")
    public List<InstrumentEntity> findWithAllDetailsByClientId(@Param(value="clientId") Long var1, @Param(value="active") Boolean var2);

    @EntityGraph(attributePaths={"inputs", "inputs.measurementUnit", "constants", "constants.measurementUnit", "outputs", "outputs.measurementUnit", "outputs.statisticalLimit", "outputs.deterministicLimit", "dam", "dam.client", "section"})
    @Query(value="SELECT i FROM InstrumentEntity i WHERE i.id = :id")
    public Optional<InstrumentEntity> findWithCompleteDetailsById(@Param(value="id") Long var1);

    @EntityGraph(attributePaths={"inputs", "inputs.measurementUnit", "constants", "constants.measurementUnit", "outputs", "outputs.measurementUnit", "outputs.statisticalLimit", "outputs.deterministicLimit", "dam", "dam.client", "section"})
    @Query(value="SELECT i FROM InstrumentEntity i WHERE i.dam.client.id = :clientId AND (:active IS NULL OR i.active = :active)")
    public List<InstrumentEntity> findByClientIdOptimized(@Param(value="clientId") Long var1, @Param(value="active") Boolean var2);

    @EntityGraph(attributePaths={"inputs", "inputs.measurementUnit", "constants", "constants.measurementUnit", "outputs", "outputs.measurementUnit", "outputs.statisticalLimit", "outputs.deterministicLimit", "dam", "dam.client", "section"})
    @Query(value="SELECT i FROM InstrumentEntity i WHERE (:damId IS NULL OR i.dam.id = :damId) AND (:instrumentTypeId IS NULL OR i.instrumentType.id = :instrumentTypeId) AND (:sectionId IS NULL OR i.section.id = :sectionId) AND (:active IS NULL OR i.active = :active) AND (:clientId IS NULL OR i.dam.client.id = :clientId)")
    public List<InstrumentEntity> findByFiltersOptimized(@Param(value="damId") Long var1, @Param(value="instrumentTypeId") Long var2, @Param(value="sectionId") Long var3, @Param(value="active") Boolean var4, @Param(value="clientId") Long var5);

    @Query(value="SELECT i FROM InstrumentEntity i LEFT JOIN FETCH i.instrumentType LEFT JOIN FETCH i.section WHERE i.id = :id")
    public Optional<InstrumentEntity> findByIdWithBasicRelations(@Param(value="id") Long var1);

    @EntityGraph(attributePaths={"dam", "section", "instrumentType"})
    public List<InstrumentEntity> findByDamIdAndIsLinimetricRulerTrue(Long var1);

    public Optional<InstrumentEntity> findByLinimetricRulerCode(Long var1);

    public boolean existsByLinimetricRulerCodeAndIdNot(Long var1, Long var2);

    @EntityGraph(attributePaths={"dam", "section", "instrumentType", "inputs", "outputs"})
    public List<InstrumentEntity> findByIsLinimetricRulerTrue();
}

