/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.client.web;

import com.geosegbar.common.response.WebResponseEntity;
import com.geosegbar.entities.ClientEntity;
import com.geosegbar.infra.client.dtos.LogoUpdateDTO;
import com.geosegbar.infra.client.service.ClientService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/client"})
public class ClientController {
    private final ClientService clientService;

    @GetMapping
    public ResponseEntity<WebResponseEntity<List<ClientEntity>>> getAllClients() {
        List clients = this.clientService.findAll();
        WebResponseEntity response = WebResponseEntity.success((Object)clients, (String)"Clientes obtidos com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<ClientEntity>> getClientById(@PathVariable Long id) {
        ClientEntity client = this.clientService.findById(id);
        WebResponseEntity response = WebResponseEntity.success((Object)client, (String)"Cliente obtido com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/filter"})
    public ResponseEntity<WebResponseEntity<List<ClientEntity>>> getClientsByStatus(@RequestParam(required=false) Long statusId) {
        List clients = this.clientService.findByStatus(statusId);
        WebResponseEntity response = WebResponseEntity.success((Object)clients, (String)"Clientes filtrados obtidos com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @PostMapping
    public ResponseEntity<WebResponseEntity<ClientEntity>> createClient(@Valid @RequestBody ClientEntity client) {
        ClientEntity createdClient = this.clientService.save(client);
        WebResponseEntity response = WebResponseEntity.success((Object)createdClient, (String)"Cliente criado com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<ClientEntity>> updateClient(@PathVariable Long id, @Valid @RequestBody ClientEntity client) {
        client.setId(id);
        ClientEntity updatedClient = this.clientService.update(client);
        WebResponseEntity response = WebResponseEntity.success((Object)updatedClient, (String)"Cliente atualizado com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @PutMapping(value={"/{id}/logo"})
    public ResponseEntity<WebResponseEntity<ClientEntity>> updateLogo(@PathVariable Long id, @RequestBody LogoUpdateDTO logoUpdateDTO) {
        ClientEntity updatedClient = this.clientService.updateLogo(id, logoUpdateDTO);
        WebResponseEntity response = WebResponseEntity.success((Object)updatedClient, (String)"Logo do cliente atualizado com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @DeleteMapping(value={"/{id}/logo"})
    public ResponseEntity<WebResponseEntity<ClientEntity>> removeLogo(@PathVariable Long id) {
        ClientEntity updatedClient = this.clientService.updateLogo(id, null);
        WebResponseEntity response = WebResponseEntity.success((Object)updatedClient, (String)"Logo do cliente removido com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<Void>> deleteClient(@PathVariable Long id) {
        this.clientService.deleteById(id);
        WebResponseEntity response = WebResponseEntity.success(null, (String)"Cliente deletado com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @Generated
    public ClientController(ClientService clientService) {
        this.clientService = clientService;
    }
}

