/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.classification_dam.services;

import com.geosegbar.entities.ClassificationDamEntity;
import com.geosegbar.exceptions.DuplicateResourceException;
import com.geosegbar.exceptions.NotFoundException;
import com.geosegbar.infra.classification_dam.peristence.ClassificationDamRepository;
import jakarta.annotation.PostConstruct;
import jakarta.transaction.Transactional;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class ClassificationDamService {
    private final ClassificationDamRepository classificationDamRepository;

    @PostConstruct
    @Transactional
    public void initializeDefaultClassifications() {
        this.createIfNotExists("A");
        this.createIfNotExists("B");
        this.createIfNotExists("C");
        this.createIfNotExists("D");
        this.createIfNotExists("E");
    }

    private void createIfNotExists(String classification) {
        if (!this.classificationDamRepository.existsByClassification(classification)) {
            ClassificationDamEntity classificationDam = new ClassificationDamEntity();
            classificationDam.setClassification(classification);
            this.classificationDamRepository.save((Object)classificationDam);
        }
    }

    @Transactional
    public void deleteById(Long id) {
        this.classificationDamRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("Classifica\u00e7\u00e3o de barragem n\u00e3o encontrada para exclus\u00e3o!"));
        this.classificationDamRepository.deleteById((Object)id);
    }

    @Transactional
    public ClassificationDamEntity save(ClassificationDamEntity classificationDamEntity) {
        if (this.classificationDamRepository.existsByClassification(classificationDamEntity.getClassification())) {
            throw new DuplicateResourceException("J\u00e1 existe uma classifica\u00e7\u00e3o de barragem com este nome!");
        }
        return (ClassificationDamEntity)this.classificationDamRepository.save((Object)classificationDamEntity);
    }

    @Transactional
    public ClassificationDamEntity update(ClassificationDamEntity classificationDamEntity) {
        this.classificationDamRepository.findById((Object)classificationDamEntity.getId()).orElseThrow(() -> new NotFoundException("Classifica\u00e7\u00e3o de barragem n\u00e3o encontrada para atualiza\u00e7\u00e3o!"));
        if (this.classificationDamRepository.existsByClassificationAndIdNot(classificationDamEntity.getClassification(), classificationDamEntity.getId())) {
            throw new DuplicateResourceException("J\u00e1 existe uma classifica\u00e7\u00e3o de barragem com este nome!");
        }
        return (ClassificationDamEntity)this.classificationDamRepository.save((Object)classificationDamEntity);
    }

    public ClassificationDamEntity findById(Long id) {
        return (ClassificationDamEntity)this.classificationDamRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("Classifica\u00e7\u00e3o de barragem n\u00e3o encontrada!"));
    }

    public List<ClassificationDamEntity> findAll() {
        return this.classificationDamRepository.findAllByOrderByIdAsc();
    }

    @Generated
    public ClassificationDamService(ClassificationDamRepository classificationDamRepository) {
        this.classificationDamRepository = classificationDamRepository;
    }
}

