/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.checklist_response.web;

import com.geosegbar.common.response.WebResponseEntity;
import com.geosegbar.entities.ChecklistResponseEntity;
import com.geosegbar.infra.checklist_response.dtos.ChecklistResponseDetailDTO;
import com.geosegbar.infra.checklist_response.dtos.ClientDetailedChecklistResponsesDTO;
import com.geosegbar.infra.checklist_response.dtos.DamLastChecklistDTO;
import com.geosegbar.infra.checklist_response.dtos.PagedChecklistResponseDTO;
import com.geosegbar.infra.checklist_response.services.ChecklistResponseService;
import jakarta.validation.Valid;
import java.time.LocalDateTime;
import java.util.List;
import lombok.Generated;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/checklist-responses"})
public class ChecklistResponseController {
    private final ChecklistResponseService checklistResponseService;

    @GetMapping
    public ResponseEntity<WebResponseEntity<List<ChecklistResponseEntity>>> getAllChecklistResponses() {
        List responses = this.checklistResponseService.findAll();
        WebResponseEntity response = WebResponseEntity.success((Object)responses, (String)"Respostas de checklist obtidas com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<ChecklistResponseEntity>> getChecklistResponseById(@PathVariable Long id) {
        ChecklistResponseEntity checklistResponse = this.checklistResponseService.findById(id);
        WebResponseEntity response = WebResponseEntity.success((Object)checklistResponse, (String)"Resposta de checklist obtida com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/dam/{damId}"})
    public ResponseEntity<WebResponseEntity<List<ChecklistResponseEntity>>> getChecklistResponsesByDamId(@PathVariable Long damId) {
        List responses = this.checklistResponseService.findByDamId(damId);
        WebResponseEntity response = WebResponseEntity.success((Object)responses, (String)"Respostas de checklist da barragem obtidas com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/client/{clientId}/last-checklist"})
    public ResponseEntity<WebResponseEntity<List<DamLastChecklistDTO>>> getLastChecklistDateByClient(@PathVariable Long clientId) {
        List result = this.checklistResponseService.getLastChecklistDateByClient(clientId);
        WebResponseEntity response = WebResponseEntity.success((Object)result, (String)"\u00daltima inspe\u00e7\u00e3o de cada barragem do cliente obtida com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @PostMapping
    public ResponseEntity<WebResponseEntity<ChecklistResponseEntity>> createChecklistResponse(@Valid @RequestBody ChecklistResponseEntity checklistResponse) {
        ChecklistResponseEntity created = this.checklistResponseService.save(checklistResponse);
        WebResponseEntity response = WebResponseEntity.success((Object)created, (String)"Resposta de checklist criada com sucesso!");
        return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.CREATED);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<ChecklistResponseEntity>> updateChecklistResponse(@PathVariable Long id, @Valid @RequestBody ChecklistResponseEntity checklistResponse) {
        checklistResponse.setId(id);
        ChecklistResponseEntity updated = this.checklistResponseService.update(checklistResponse);
        WebResponseEntity response = WebResponseEntity.success((Object)updated, (String)"Resposta de checklist atualizada com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<Void>> deleteChecklistResponse(@PathVariable Long id) {
        this.checklistResponseService.deleteById(id);
        WebResponseEntity response = WebResponseEntity.success(null, (String)"Resposta de checklist exclu\u00edda com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/dam/{damId}/detail"})
    public ResponseEntity<WebResponseEntity<List<ChecklistResponseDetailDTO>>> getDetailedDamChecklistResponses(@PathVariable Long damId) {
        List responses = this.checklistResponseService.findChecklistResponsesByDamId(damId);
        WebResponseEntity response = WebResponseEntity.success((Object)responses, (String)"Respostas de checklist da barragem obtidas com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/{id}/detail"})
    public ResponseEntity<WebResponseEntity<ChecklistResponseDetailDTO>> getDetailedChecklistResponse(@PathVariable Long id) {
        ChecklistResponseDetailDTO response = this.checklistResponseService.findChecklistResponseById(id);
        WebResponseEntity webResponse = WebResponseEntity.success((Object)response, (String)"Detalhes da resposta de checklist obtidos com sucesso!");
        return ResponseEntity.ok((Object)webResponse);
    }

    @GetMapping(value={"/user/{userId}/detail"})
    public ResponseEntity<WebResponseEntity<List<ChecklistResponseDetailDTO>>> getDetailedUserChecklistResponses(@PathVariable Long userId) {
        List responses = this.checklistResponseService.findChecklistResponsesByUserId(userId);
        WebResponseEntity response = WebResponseEntity.success((Object)responses, (String)"Respostas de checklist do usu\u00e1rio obtidas com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/date-range/detail"})
    public ResponseEntity<WebResponseEntity<List<ChecklistResponseDetailDTO>>> getDetailedChecklistResponsesByDateRange(@RequestParam @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime startDate, @RequestParam @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime endDate) {
        List responses = this.checklistResponseService.findChecklistResponsesByDateRange(startDate, endDate);
        WebResponseEntity response = WebResponseEntity.success((Object)responses, (String)"Respostas de checklist no per\u00edodo especificado obtidas com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/paged"})
    public ResponseEntity<WebResponseEntity<PagedChecklistResponseDTO<ChecklistResponseDetailDTO>>> getAllChecklistResponsesPaged(@RequestParam(defaultValue="0") int page, @RequestParam(defaultValue="10") int size, @RequestParam(defaultValue="createdAt") String sortBy, @RequestParam(defaultValue="desc") String sortDirection) {
        Sort.Direction direction = sortDirection.equalsIgnoreCase("asc") ? Sort.Direction.ASC : Sort.Direction.DESC;
        PageRequest pageable = PageRequest.of((int)page, (int)size, (Sort)Sort.by((Sort.Direction)direction, (String[])new String[]{sortBy}));
        PagedChecklistResponseDTO responses = this.checklistResponseService.findAllChecklistResponsesPaged((Pageable)pageable);
        WebResponseEntity response = WebResponseEntity.success((Object)responses, (String)"Respostas de checklist paginadas obtidas com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/dam/{damId}/paged"})
    public ResponseEntity<WebResponseEntity<PagedChecklistResponseDTO<ChecklistResponseDetailDTO>>> getDetailedDamChecklistResponsesPaged(@PathVariable Long damId, @RequestParam(defaultValue="0") int page, @RequestParam(defaultValue="10") int size, @RequestParam(defaultValue="createdAt") String sortBy, @RequestParam(defaultValue="desc") String sortDirection) {
        Sort.Direction direction = sortDirection.equalsIgnoreCase("asc") ? Sort.Direction.ASC : Sort.Direction.DESC;
        PageRequest pageable = PageRequest.of((int)page, (int)size, (Sort)Sort.by((Sort.Direction)direction, (String[])new String[]{sortBy}));
        PagedChecklistResponseDTO responses = this.checklistResponseService.findChecklistResponsesByDamIdPaged(damId, (Pageable)pageable);
        WebResponseEntity response = WebResponseEntity.success((Object)responses, (String)"Respostas de checklist da barragem paginadas obtidas com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/client/{clientId}/paged"})
    public ResponseEntity<WebResponseEntity<PagedChecklistResponseDTO<ChecklistResponseDetailDTO>>> getDetailedClientChecklistResponsesPaged(@PathVariable Long clientId, @RequestParam(defaultValue="0") int page, @RequestParam(defaultValue="10") int size, @RequestParam(defaultValue="createdAt") String sortBy, @RequestParam(defaultValue="desc") String sortDirection) {
        Sort.Direction direction = sortDirection.equalsIgnoreCase("asc") ? Sort.Direction.ASC : Sort.Direction.DESC;
        PageRequest pageable = PageRequest.of((int)page, (int)size, (Sort)Sort.by((Sort.Direction)direction, (String[])new String[]{sortBy}));
        PagedChecklistResponseDTO responses = this.checklistResponseService.findChecklistResponsesByClientIdPaged(clientId, (Pageable)pageable);
        WebResponseEntity response = WebResponseEntity.success((Object)responses, (String)"Respostas de checklist para barragens do cliente paginadas obtidas com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/user/{userId}/paged"})
    public ResponseEntity<WebResponseEntity<PagedChecklistResponseDTO<ChecklistResponseDetailDTO>>> getDetailedUserChecklistResponsesPaged(@PathVariable Long userId, @RequestParam(defaultValue="0") int page, @RequestParam(defaultValue="10") int size, @RequestParam(defaultValue="createdAt") String sortBy, @RequestParam(defaultValue="desc") String sortDirection) {
        Sort.Direction direction = sortDirection.equalsIgnoreCase("asc") ? Sort.Direction.ASC : Sort.Direction.DESC;
        PageRequest pageable = PageRequest.of((int)page, (int)size, (Sort)Sort.by((Sort.Direction)direction, (String[])new String[]{sortBy}));
        PagedChecklistResponseDTO responses = this.checklistResponseService.findChecklistResponsesByUserIdPaged(userId, (Pageable)pageable);
        WebResponseEntity response = WebResponseEntity.success((Object)responses, (String)"Respostas de checklist do usu\u00e1rio paginadas obtidas com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/date-range/paged"})
    public ResponseEntity<WebResponseEntity<PagedChecklistResponseDTO<ChecklistResponseDetailDTO>>> getDetailedChecklistResponsesByDateRangePaged(@RequestParam @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime startDate, @RequestParam @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime endDate, @RequestParam(defaultValue="0") int page, @RequestParam(defaultValue="10") int size, @RequestParam(defaultValue="createdAt") String sortBy, @RequestParam(defaultValue="desc") String sortDirection) {
        Sort.Direction direction = sortDirection.equalsIgnoreCase("asc") ? Sort.Direction.ASC : Sort.Direction.DESC;
        PageRequest pageable = PageRequest.of((int)page, (int)size, (Sort)Sort.by((Sort.Direction)direction, (String[])new String[]{sortBy}));
        PagedChecklistResponseDTO responses = this.checklistResponseService.findChecklistResponsesByDateRangePaged(startDate, endDate, (Pageable)pageable);
        WebResponseEntity response = WebResponseEntity.success((Object)responses, (String)"Respostas de checklist no per\u00edodo especificado paginadas obtidas com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/client/{clientId}/latest-detailed-responses"})
    public ResponseEntity<WebResponseEntity<ClientDetailedChecklistResponsesDTO>> getLatestDetailedChecklistResponsesByClientId(@PathVariable Long clientId, @RequestParam(defaultValue="3") int limit) {
        if (limit <= 0 || limit > 10) {
            return ResponseEntity.badRequest().body((Object)WebResponseEntity.error((String)"O n\u00famero de respostas por checklist deve estar entre 1 e 10"));
        }
        ClientDetailedChecklistResponsesDTO result = this.checklistResponseService.findLatestDetailedChecklistResponsesByClientId(clientId, limit);
        return ResponseEntity.ok((Object)WebResponseEntity.success((Object)result, (String)String.format("\u00daltimas %d respostas detalhadas obtidas com sucesso para os checklists do cliente", limit)));
    }

    @Generated
    public ChecklistResponseController(ChecklistResponseService checklistResponseService) {
        this.checklistResponseService = checklistResponseService;
    }
}

