/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.checklist.web;

import com.geosegbar.common.response.WebResponseEntity;
import com.geosegbar.entities.ChecklistEntity;
import com.geosegbar.infra.checklist.dtos.ChecklistWithLastAnswersAndDamDTO;
import com.geosegbar.infra.checklist.dtos.ChecklistWithLastAnswersDTO;
import com.geosegbar.infra.checklist.services.ChecklistService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/checklists"})
public class ChecklistController {
    private final ChecklistService checklistService;

    @GetMapping
    public ResponseEntity<WebResponseEntity<List<ChecklistEntity>>> getAllChecklists() {
        List checklists = this.checklistService.findAll();
        WebResponseEntity response = WebResponseEntity.success((Object)checklists, (String)"Checklists obtidas com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/dam/{damId}"})
    public ResponseEntity<WebResponseEntity<List<ChecklistEntity>>> getChecklistsByDam(@PathVariable Long damId) {
        List checklists = this.checklistService.findByDamId(damId);
        WebResponseEntity response = WebResponseEntity.success((Object)checklists, (String)"Checklists para a Barragem obtidas com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<ChecklistEntity>> getChecklistById(@PathVariable Long id) {
        ChecklistEntity checklist = this.checklistService.findById(id);
        WebResponseEntity response = WebResponseEntity.success((Object)checklist, (String)"Checklist obtida com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/client/{clientId}/with-last-answers"})
    public ResponseEntity<WebResponseEntity<List<ChecklistWithLastAnswersAndDamDTO>>> getAllChecklistsWithLastAnswersByClientId(@PathVariable Long clientId) {
        List checklists = this.checklistService.findAllChecklistsWithLastAnswersByClientId(clientId);
        WebResponseEntity response = WebResponseEntity.success((Object)checklists, (String)"Todos os checklists com \u00faltimas respostas do cliente obtidos com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/dam/{damId}/checklist/{checklistId}"})
    public ResponseEntity<WebResponseEntity<ChecklistEntity>> getChecklistForDam(@PathVariable Long damId, @PathVariable Long checklistId) {
        ChecklistEntity checklist = this.checklistService.findChecklistForDam(damId, checklistId);
        WebResponseEntity response = WebResponseEntity.success((Object)checklist, (String)"Checklist encontrado para a barragem especificada!");
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/dam/{damId}/with-last-answers"})
    public ResponseEntity<WebResponseEntity<List<ChecklistWithLastAnswersDTO>>> getChecklistsWithLastAnswersForDam(@PathVariable Long damId) {
        List checklists = this.checklistService.findChecklistsWithLastAnswersForDam(damId);
        WebResponseEntity response = WebResponseEntity.success((Object)checklists, (String)"Checklists com \u00faltimas respostas n\u00e3o-NI obtidos com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @PostMapping
    public ResponseEntity<WebResponseEntity<ChecklistEntity>> createChecklist(@Valid @RequestBody ChecklistEntity checklist) {
        ChecklistEntity created = this.checklistService.save(checklist);
        WebResponseEntity response = WebResponseEntity.success((Object)created, (String)"Checklist criada com sucesso!");
        return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.CREATED);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<ChecklistEntity>> updateChecklist(@PathVariable Long id, @Valid @RequestBody ChecklistEntity checklist) {
        checklist.setId(id);
        ChecklistEntity updated = this.checklistService.update(checklist);
        WebResponseEntity response = WebResponseEntity.success((Object)updated, (String)"Checklist atualizada com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<Void>> deleteChecklist(@PathVariable Long id) {
        this.checklistService.deleteById(id);
        WebResponseEntity response = WebResponseEntity.success(null, (String)"Checklist exclu\u00edda com sucesso!");
        return ResponseEntity.ok((Object)response);
    }

    @Generated
    public ChecklistController(ChecklistService checklistService) {
        this.checklistService = checklistService;
    }
}

