/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.exceptions.exception_handler;

import com.geosegbar.common.response.WebResponseEntity;
import com.geosegbar.exceptions.BusinessRuleException;
import com.geosegbar.exceptions.DatabaseException;
import com.geosegbar.exceptions.DuplicateResourceException;
import com.geosegbar.exceptions.FileStorageException;
import com.geosegbar.exceptions.ForbiddenException;
import com.geosegbar.exceptions.InvalidInputException;
import com.geosegbar.exceptions.InvalidTokenException;
import com.geosegbar.exceptions.NotFoundException;
import com.geosegbar.exceptions.TokenExpiredException;
import com.geosegbar.exceptions.UnauthorizedException;
import com.geosegbar.exceptions.UnsupportedFileTypeException;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import java.util.HashMap;
import java.util.Map;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class RestExceptionHandler {
    @ExceptionHandler(value={NotFoundException.class})
    public ResponseEntity<WebResponseEntity<String>> handleNotFoundException(NotFoundException ex) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)WebResponseEntity.error((String)ex.getMessage()));
    }

    @ExceptionHandler(value={DuplicateResourceException.class})
    public ResponseEntity<WebResponseEntity<String>> handleDuplicateResourceException(DuplicateResourceException ex) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).body((Object)WebResponseEntity.error((String)ex.getMessage()));
    }

    @ExceptionHandler(value={InvalidInputException.class})
    public ResponseEntity<WebResponseEntity<String>> handleInvalidInputException(InvalidInputException ex) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)WebResponseEntity.error((String)ex.getMessage()));
    }

    @ExceptionHandler(value={UnauthorizedException.class})
    public ResponseEntity<WebResponseEntity<String>> handleUnauthorizedException(UnauthorizedException ex) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)WebResponseEntity.error((String)ex.getMessage()));
    }

    @ExceptionHandler(value={ForbiddenException.class})
    public ResponseEntity<WebResponseEntity<String>> handleForbiddenException(ForbiddenException ex) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).body((Object)WebResponseEntity.error((String)ex.getMessage()));
    }

    @ExceptionHandler(value={DatabaseException.class})
    public ResponseEntity<WebResponseEntity<String>> handleDatabaseException(DatabaseException ex) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)WebResponseEntity.error((String)("Erro no banco de dados: " + ex.getMessage())));
    }

    @ExceptionHandler(value={BusinessRuleException.class})
    public ResponseEntity<WebResponseEntity<String>> handleBusinessRuleException(BusinessRuleException ex) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)WebResponseEntity.error((String)ex.getMessage()));
    }

    @ExceptionHandler(value={FileStorageException.class})
    public ResponseEntity<WebResponseEntity<String>> handleFileStorageException(FileStorageException ex) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)WebResponseEntity.error((String)ex.getMessage()));
    }

    @ExceptionHandler(value={InvalidTokenException.class})
    public ResponseEntity<WebResponseEntity<String>> handleInvalidTokenException(InvalidTokenException ex) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)WebResponseEntity.error((String)ex.getMessage()));
    }

    @ExceptionHandler(value={TokenExpiredException.class})
    public ResponseEntity<WebResponseEntity<String>> handleTokenException(TokenExpiredException ex) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)WebResponseEntity.error((String)ex.getMessage()));
    }

    @ExceptionHandler(value={UnsupportedFileTypeException.class})
    public ResponseEntity<WebResponseEntity<String>> handleUnsupportedFileTypeException(UnsupportedFileTypeException ex) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.UNSUPPORTED_MEDIA_TYPE).body((Object)WebResponseEntity.error((String)ex.getMessage()));
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResponseEntity<WebResponseEntity<Map<String, String>>> handleValidationExceptions(MethodArgumentNotValidException ex) {
        HashMap<String, String> errors = new HashMap<String, String>();
        for (FieldError error : ex.getBindingResult().getFieldErrors()) {
            errors.put(error.getField(), error.getDefaultMessage());
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)WebResponseEntity.errorValidation((String)"Erro de valida\u00e7\u00e3o", errors));
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public ResponseEntity<WebResponseEntity<Map<String, String>>> handleConstraintViolationException(ConstraintViolationException ex) {
        HashMap<String, String> errors = new HashMap<String, String>();
        for (ConstraintViolation violation : ex.getConstraintViolations()) {
            String propertyPath = violation.getPropertyPath().toString();
            String field = propertyPath.contains(".") ? propertyPath.substring(propertyPath.lastIndexOf(46) + 1) : propertyPath;
            errors.put(field, violation.getMessage());
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)WebResponseEntity.errorValidation((String)"Inv\u00e1lido!", errors));
    }

    @ExceptionHandler(value={TransactionSystemException.class})
    public ResponseEntity<WebResponseEntity<?>> handleTransactionSystemException(TransactionSystemException ex) {
        Throwable cause = ex.getRootCause();
        if (cause instanceof ConstraintViolationException) {
            ConstraintViolationException violationException = (ConstraintViolationException)cause;
            HashMap<String, String> errors = new HashMap<String, String>();
            for (ConstraintViolation violation : violationException.getConstraintViolations()) {
                String propertyPath = violation.getPropertyPath().toString();
                String field = propertyPath.contains(".") ? propertyPath.substring(propertyPath.lastIndexOf(46) + 1) : propertyPath;
                errors.put(field, violation.getMessage());
            }
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)WebResponseEntity.errorValidation((String)"Inv\u00e1lido!", errors));
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)WebResponseEntity.error((String)("Erro na transa\u00e7\u00e3o: " + (cause != null ? cause.getMessage() : ex.getMessage()))));
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<WebResponseEntity<String>> handleGeneralException(Exception ex) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)WebResponseEntity.error((String)"Erro inesperado. Tente novamente mais tarde."));
    }
}

