/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.entities;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.geosegbar.common.enums.TypeQuestionEnum;
import com.geosegbar.entities.OptionEntity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotBlank;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;

@Entity
@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler"})
@Table(name="questions", indexes={@Index(name="idx_question_type", columnList="type")})
public class QuestionEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="question_text", nullable=false)
    @NotBlank(message="Texto da pergunta \u00e9 obrigat\u00f3rio!")
    private @NotBlank(message="Texto da pergunta \u00e9 obrigat\u00f3rio!") String questionText;
    @Enumerated(value=EnumType.STRING)
    @Column(name="type", nullable=false)
    private TypeQuestionEnum type;
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="question_option", joinColumns={@JoinColumn(name="question_id")}, inverseJoinColumns={@JoinColumn(name="option_id")})
    private Set<OptionEntity> options = new HashSet();

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getQuestionText() {
        return this.questionText;
    }

    @Generated
    public TypeQuestionEnum getType() {
        return this.type;
    }

    @Generated
    public Set<OptionEntity> getOptions() {
        return this.options;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setQuestionText(String questionText) {
        this.questionText = questionText;
    }

    @Generated
    public void setType(TypeQuestionEnum type) {
        this.type = type;
    }

    @Generated
    public void setOptions(Set<OptionEntity> options) {
        this.options = options;
    }

    @Generated
    public QuestionEntity() {
    }

    @Generated
    public QuestionEntity(Long id, String questionText, TypeQuestionEnum type, Set<OptionEntity> options) {
        this.id = id;
        this.questionText = questionText;
        this.type = type;
        this.options = options;
    }
}

