/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.entities;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.geosegbar.common.enums.AnomalyOriginEnum;
import com.geosegbar.entities.AnomalyPhotoEntity;
import com.geosegbar.entities.AnomalyStatusEntity;
import com.geosegbar.entities.DamEntity;
import com.geosegbar.entities.DangerLevelEntity;
import com.geosegbar.entities.UserEntity;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedAttributeNode;
import jakarta.persistence.NamedEntityGraph;
import jakarta.persistence.NamedEntityGraphs;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.hibernate.annotations.CreationTimestamp;

@Entity
@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler"})
@Table(name="anomalies", indexes={@Index(name="idx_anomaly_dam_id", columnList="dam_id"), @Index(name="idx_anomaly_user_id", columnList="user_id"), @Index(name="idx_anomaly_status_id", columnList="status_id"), @Index(name="idx_anomaly_danger_level_id", columnList="danger_level_id"), @Index(name="idx_anomaly_created_at", columnList="created_at"), @Index(name="idx_anomaly_created_desc", columnList="created_at DESC"), @Index(name="idx_anomaly_coordinates", columnList="latitude, longitude"), @Index(name="idx_anomaly_dam_coordinates", columnList="dam_id, latitude, longitude"), @Index(name="idx_anomaly_dam_status", columnList="dam_id, status_id"), @Index(name="idx_anomaly_dam_created", columnList="dam_id, created_at DESC"), @Index(name="idx_anomaly_user_created", columnList="user_id, created_at DESC"), @Index(name="idx_anomaly_status_created", columnList="status_id, created_at DESC"), @Index(name="idx_anomaly_danger_created", columnList="danger_level_id, created_at DESC"), @Index(name="idx_anomaly_origin", columnList="origin"), @Index(name="idx_anomaly_questionnaire_id", columnList="questionnaire_id"), @Index(name="idx_anomaly_question_id", columnList="question_id"), @Index(name="idx_anomaly_origin_dam", columnList="origin, dam_id"), @Index(name="idx_anomaly_dam_danger_status", columnList="dam_id, danger_level_id, status_id"), @Index(name="idx_anomaly_complete_filter", columnList="dam_id, status_id, danger_level_id, created_at DESC")})
@NamedEntityGraphs(value={@NamedEntityGraph(name="anomaly.complete", attributeNodes={@NamedAttributeNode(value="photos"), @NamedAttributeNode(value="user"), @NamedAttributeNode(value="dam"), @NamedAttributeNode(value="dangerLevel"), @NamedAttributeNode(value="status")})})
public class AnomalyEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="user_id", nullable=false)
    @JsonIgnoreProperties(value={"damPermissions", "createdUsers", "psbFoldersCreated", "psbFilesUploaded", "sharedFolders"})
    @NotNull(message="Usu\u00e1rio \u00e9 obrigat\u00f3rio!")
    private @NotNull(message="Usu\u00e1rio \u00e9 obrigat\u00f3rio!") UserEntity user;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="dam_id", nullable=false)
    @JsonIgnoreProperties(value={"checklists", "checklistResponses", "damPermissions", "reservoirs", "psbFolders"})
    @NotNull(message="Barragem \u00e9 obrigat\u00f3ria!")
    private @NotNull(message="Barragem \u00e9 obrigat\u00f3ria!") DamEntity dam;
    @Column(name="created_at", nullable=false, updatable=false)
    @CreationTimestamp
    private LocalDateTime createdAt;
    @Column(nullable=false)
    @NotNull(message="Latitude \u00e9 obrigat\u00f3ria!")
    private @NotNull(message="Latitude \u00e9 obrigat\u00f3ria!") Double latitude;
    @Column(nullable=false)
    @NotNull(message="Longitude \u00e9 obrigat\u00f3ria!")
    private @NotNull(message="Longitude \u00e9 obrigat\u00f3ria!") Double longitude;
    @Column(name="questionnaire_id")
    private Long questionnaireId;
    @Column(name="question_id")
    private Long questionId;
    @Enumerated(value=EnumType.STRING)
    @Column(name="origin", nullable=false)
    private AnomalyOriginEnum origin;
    @Column(name="observation", columnDefinition="TEXT")
    private String observation;
    @Column(name="recommendation", columnDefinition="TEXT")
    private String recommendation;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="danger_level_id", nullable=false)
    @NotNull(message="N\u00edvel de Perigo \u00e9 obrigat\u00f3rio!")
    private @NotNull(message="N\u00edvel de Perigo \u00e9 obrigat\u00f3rio!") DangerLevelEntity dangerLevel;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="status_id", nullable=false)
    @NotNull(message="Status \u00e9 obrigat\u00f3rio!")
    private @NotNull(message="Status \u00e9 obrigat\u00f3rio!") AnomalyStatusEntity status;
    @OneToMany(mappedBy="anomaly", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @JsonManagedReference(value="anomaly-photos")
    private Set<AnomalyPhotoEntity> photos = new HashSet();

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public UserEntity getUser() {
        return this.user;
    }

    @Generated
    public DamEntity getDam() {
        return this.dam;
    }

    @Generated
    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public Double getLatitude() {
        return this.latitude;
    }

    @Generated
    public Double getLongitude() {
        return this.longitude;
    }

    @Generated
    public Long getQuestionnaireId() {
        return this.questionnaireId;
    }

    @Generated
    public Long getQuestionId() {
        return this.questionId;
    }

    @Generated
    public AnomalyOriginEnum getOrigin() {
        return this.origin;
    }

    @Generated
    public String getObservation() {
        return this.observation;
    }

    @Generated
    public String getRecommendation() {
        return this.recommendation;
    }

    @Generated
    public DangerLevelEntity getDangerLevel() {
        return this.dangerLevel;
    }

    @Generated
    public AnomalyStatusEntity getStatus() {
        return this.status;
    }

    @Generated
    public Set<AnomalyPhotoEntity> getPhotos() {
        return this.photos;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @JsonIgnoreProperties(value={"damPermissions", "createdUsers", "psbFoldersCreated", "psbFilesUploaded", "sharedFolders"})
    @Generated
    public void setUser(UserEntity user) {
        this.user = user;
    }

    @JsonIgnoreProperties(value={"checklists", "checklistResponses", "damPermissions", "reservoirs", "psbFolders"})
    @Generated
    public void setDam(DamEntity dam) {
        this.dam = dam;
    }

    @Generated
    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    @Generated
    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    @Generated
    public void setQuestionnaireId(Long questionnaireId) {
        this.questionnaireId = questionnaireId;
    }

    @Generated
    public void setQuestionId(Long questionId) {
        this.questionId = questionId;
    }

    @Generated
    public void setOrigin(AnomalyOriginEnum origin) {
        this.origin = origin;
    }

    @Generated
    public void setObservation(String observation) {
        this.observation = observation;
    }

    @Generated
    public void setRecommendation(String recommendation) {
        this.recommendation = recommendation;
    }

    @Generated
    public void setDangerLevel(DangerLevelEntity dangerLevel) {
        this.dangerLevel = dangerLevel;
    }

    @Generated
    public void setStatus(AnomalyStatusEntity status) {
        this.status = status;
    }

    @Generated
    public void setPhotos(Set<AnomalyPhotoEntity> photos) {
        this.photos = photos;
    }

    @Generated
    public AnomalyEntity() {
    }

    @Generated
    public AnomalyEntity(Long id, UserEntity user, DamEntity dam, LocalDateTime createdAt, Double latitude, Double longitude, Long questionnaireId, Long questionId, AnomalyOriginEnum origin, String observation, String recommendation, DangerLevelEntity dangerLevel, AnomalyStatusEntity status, Set<AnomalyPhotoEntity> photos) {
        this.id = id;
        this.user = user;
        this.dam = dam;
        this.createdAt = createdAt;
        this.latitude = latitude;
        this.longitude = longitude;
        this.questionnaireId = questionnaireId;
        this.questionId = questionId;
        this.origin = origin;
        this.observation = observation;
        this.recommendation = recommendation;
        this.dangerLevel = dangerLevel;
        this.status = status;
        this.photos = photos;
    }
}

