/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.template_questionnaire_question.services;

import com.geosegbar.entities.TemplateQuestionnaireEntity;
import com.geosegbar.entities.TemplateQuestionnaireQuestionEntity;
import com.geosegbar.exceptions.InvalidInputException;
import com.geosegbar.exceptions.NotFoundException;
import com.geosegbar.infra.question.persistence.jpa.QuestionRepository;
import com.geosegbar.infra.questionnaire_response.persistence.jpa.QuestionnaireResponseRepository;
import com.geosegbar.infra.template_questionnaire.persistence.jpa.TemplateQuestionnaireRepository;
import com.geosegbar.infra.template_questionnaire_question.dtos.QuestionOrderDTO;
import com.geosegbar.infra.template_questionnaire_question.dtos.QuestionReorderDTO;
import com.geosegbar.infra.template_questionnaire_question.persistence.jpa.TemplateQuestionnaireQuestionRepository;
import jakarta.transaction.Transactional;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class TemplateQuestionnaireQuestionService {
    private final TemplateQuestionnaireQuestionRepository tqQuestionRepository;
    private final TemplateQuestionnaireRepository templateQuestionnaireRepository;
    private final QuestionRepository questionRepository;
    private final QuestionnaireResponseRepository questionnaireResponseRepository;

    @Transactional
    public void deleteById(Long id) {
        TemplateQuestionnaireQuestionEntity questionToDelete = (TemplateQuestionnaireQuestionEntity)this.tqQuestionRepository.findById(id).orElseThrow(() -> new NotFoundException("Quest\u00e3o do template n\u00e3o encontrada para exclus\u00e3o!"));
        Long templateId = questionToDelete.getTemplateQuestionnaire().getId();
        if (this.questionnaireResponseRepository.existsByTemplateQuestionnaireId(templateId)) {
            throw new InvalidInputException("N\u00e3o \u00e9 poss\u00edvel excluir esta quest\u00e3o pois existem question\u00e1rios respondidos usando este template. Crie um novo template para aplicar as altera\u00e7\u00f5es desejadas.");
        }
        int deletedIndex = questionToDelete.getOrderIndex();
        this.tqQuestionRepository.deleteById(id);
        List<TemplateQuestionnaireQuestionEntity> remainingQuestions = this.tqQuestionRepository.findByTemplateQuestionnaireIdOrderByOrderIndex(templateId);
        for (TemplateQuestionnaireQuestionEntity question : remainingQuestions) {
            if (question.getOrderIndex() <= deletedIndex) continue;
            question.setOrderIndex(question.getOrderIndex() - 1);
            this.tqQuestionRepository.save(question);
        }
    }

    @Transactional
    public TemplateQuestionnaireQuestionEntity save(TemplateQuestionnaireQuestionEntity tqQuestion) {
        this.questionRepository.findById(tqQuestion.getQuestion().getId()).orElseThrow(() -> new NotFoundException("Quest\u00e3o n\u00e3o encontrada!"));
        TemplateQuestionnaireEntity template = (TemplateQuestionnaireEntity)this.templateQuestionnaireRepository.findById(tqQuestion.getTemplateQuestionnaire().getId()).orElseThrow(() -> new NotFoundException("Template n\u00e3o encontrado!"));
        tqQuestion.setTemplateQuestionnaire(template);
        int currentQuestionCount = this.tqQuestionRepository.countQuestionsByTemplateId(template.getId());
        Integer requestedIndex = tqQuestion.getOrderIndex();
        if (requestedIndex == null) {
            tqQuestion.setOrderIndex(currentQuestionCount + 1);
        } else {
            if (requestedIndex <= 0) {
                throw new InvalidInputException("O \u00edndice de ordem deve ser um n\u00famero positivo!");
            }
            if (requestedIndex > currentQuestionCount + 1) {
                tqQuestion.setOrderIndex(currentQuestionCount + 1);
            } else {
                List<TemplateQuestionnaireQuestionEntity> existingQuestions = this.tqQuestionRepository.findByTemplateQuestionnaireIdOrderByOrderIndex(template.getId());
                for (TemplateQuestionnaireQuestionEntity existing : existingQuestions) {
                    if (existing.getOrderIndex() < requestedIndex) continue;
                    existing.setOrderIndex(existing.getOrderIndex() + 1);
                    this.tqQuestionRepository.save(existing);
                }
            }
        }
        return (TemplateQuestionnaireQuestionEntity)this.tqQuestionRepository.save(tqQuestion);
    }

    @Transactional
    public TemplateQuestionnaireQuestionEntity update(TemplateQuestionnaireQuestionEntity tqQuestion) {
        TemplateQuestionnaireQuestionEntity existingQuestion = (TemplateQuestionnaireQuestionEntity)this.tqQuestionRepository.findById(tqQuestion.getId()).orElseThrow(() -> new NotFoundException("Quest\u00e3o do template n\u00e3o encontrada!"));
        Long templateId = existingQuestion.getTemplateQuestionnaire().getId();
        if (this.questionnaireResponseRepository.existsByTemplateQuestionnaireId(templateId)) {
            throw new InvalidInputException("N\u00e3o \u00e9 poss\u00edvel modificar esta quest\u00e3o pois existem question\u00e1rios respondidos usando este template. Crie um novo template para aplicar as altera\u00e7\u00f5es desejadas.");
        }
        if (tqQuestion.getOrderIndex() != null && !tqQuestion.getOrderIndex().equals(existingQuestion.getOrderIndex())) {
            int currentCount = this.tqQuestionRepository.countQuestionsByTemplateId(templateId);
            if (tqQuestion.getOrderIndex() <= 0) {
                throw new InvalidInputException("O \u00edndice de ordem deve ser um n\u00famero positivo!");
            }
            if (tqQuestion.getOrderIndex() > currentCount) {
                throw new InvalidInputException("O \u00edndice de ordem n\u00e3o pode ser maior que o total de quest\u00f5es: " + currentCount);
            }
            List<TemplateQuestionnaireQuestionEntity> questions = this.tqQuestionRepository.findByTemplateQuestionnaireIdOrderByOrderIndex(templateId);
            int oldIndex = existingQuestion.getOrderIndex();
            int newIndex = tqQuestion.getOrderIndex();
            for (TemplateQuestionnaireQuestionEntity q : questions) {
                if (q.getId().equals(tqQuestion.getId())) continue;
                if (oldIndex < newIndex) {
                    if (q.getOrderIndex() <= oldIndex || q.getOrderIndex() > newIndex) continue;
                    q.setOrderIndex(q.getOrderIndex() - 1);
                    this.tqQuestionRepository.save(q);
                    continue;
                }
                if (q.getOrderIndex() < newIndex || q.getOrderIndex() >= oldIndex) continue;
                q.setOrderIndex(q.getOrderIndex() + 1);
                this.tqQuestionRepository.save(q);
            }
            existingQuestion.setOrderIndex(tqQuestion.getOrderIndex());
            return (TemplateQuestionnaireQuestionEntity)this.tqQuestionRepository.save(existingQuestion);
        }
        throw new InvalidInputException("Apenas o \u00edndice de ordem pode ser atualizado. Nenhuma altera\u00e7\u00e3o foi detectada ou solicitada.");
    }

    public TemplateQuestionnaireQuestionEntity findById(Long id) {
        return (TemplateQuestionnaireQuestionEntity)this.tqQuestionRepository.findById(id).orElseThrow(() -> new NotFoundException("Quest\u00e3o do template n\u00e3o encontrada!"));
    }

    public List<TemplateQuestionnaireQuestionEntity> findAll() {
        return this.tqQuestionRepository.findAll();
    }

    @Transactional
    public List<TemplateQuestionnaireQuestionEntity> reorderQuestions(QuestionReorderDTO reorderDTO) {
        int maxIndex;
        Set requestQuestionIds;
        Long templateId = reorderDTO.getTemplateQuestionnaireId();
        if (!this.templateQuestionnaireRepository.existsById(templateId)) {
            throw new NotFoundException("Template de question\u00e1rio n\u00e3o encontrado com ID: " + templateId);
        }
        List<TemplateQuestionnaireQuestionEntity> existingQuestions = this.tqQuestionRepository.findByTemplateQuestionnaireIdOrderByOrderIndex(templateId);
        if (existingQuestions.isEmpty()) {
            throw new NotFoundException("O template de question\u00e1rio n\u00e3o cont\u00e9m quest\u00f5es para reordenar");
        }
        if (existingQuestions.size() != reorderDTO.getQuestions().size()) {
            throw new InvalidInputException("O n\u00famero de quest\u00f5es informadas (" + reorderDTO.getQuestions().size() + ") n\u00e3o corresponde ao n\u00famero de quest\u00f5es do template (" + existingQuestions.size() + ")!");
        }
        Set existingQuestionIds = existingQuestions.stream().map(TemplateQuestionnaireQuestionEntity::getId).collect(Collectors.toSet());
        if (!existingQuestionIds.containsAll(requestQuestionIds = reorderDTO.getQuestions().stream().map(QuestionOrderDTO::getTemplateQuestionId).collect(Collectors.toSet()))) {
            HashSet invalidIds = new HashSet(requestQuestionIds);
            invalidIds.removeAll(existingQuestionIds);
            throw new InvalidInputException("As seguintes quest\u00f5es n\u00e3o pertencem a este template: " + String.valueOf(invalidIds));
        }
        if (!requestQuestionIds.containsAll(existingQuestionIds)) {
            HashSet missingIds = new HashSet(existingQuestionIds);
            missingIds.removeAll(requestQuestionIds);
            throw new InvalidInputException("As seguintes quest\u00f5es do template n\u00e3o foram inclu\u00eddas: " + String.valueOf(missingIds));
        }
        Set requestIndices = reorderDTO.getQuestions().stream().map(QuestionOrderDTO::getOrderIndex).collect(Collectors.toSet());
        if (requestIndices.size() != reorderDTO.getQuestions().size()) {
            throw new InvalidInputException("Existem \u00edndices duplicados na requisi\u00e7\u00e3o");
        }
        int expectedSize = maxIndex = requestIndices.stream().max(Integer::compare).orElse(0).intValue();
        if (requestIndices.size() != expectedSize) {
            throw new InvalidInputException("A sequ\u00eancia de \u00edndices n\u00e3o \u00e9 cont\u00ednua. Deve come\u00e7ar em 1 e n\u00e3o ter lacunas.");
        }
        Map<Long, Integer> reorderMap = reorderDTO.getQuestions().stream().collect(Collectors.toMap(QuestionOrderDTO::getTemplateQuestionId, QuestionOrderDTO::getOrderIndex));
        for (TemplateQuestionnaireQuestionEntity question : existingQuestions) {
            question.setOrderIndex(reorderMap.get(question.getId()));
        }
        return this.tqQuestionRepository.saveAll(existingQuestions);
    }

    public List<TemplateQuestionnaireQuestionEntity> findAllByTemplateIdOrdered(Long templateId) {
        return this.tqQuestionRepository.findByTemplateQuestionnaireIdOrderByOrderIndex(templateId);
    }

    @Generated
    public TemplateQuestionnaireQuestionService(TemplateQuestionnaireQuestionRepository tqQuestionRepository, TemplateQuestionnaireRepository templateQuestionnaireRepository, QuestionRepository questionRepository, QuestionnaireResponseRepository questionnaireResponseRepository) {
        this.tqQuestionRepository = tqQuestionRepository;
        this.templateQuestionnaireRepository = templateQuestionnaireRepository;
        this.questionRepository = questionRepository;
        this.questionnaireResponseRepository = questionnaireResponseRepository;
    }
}

