/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.section.web;

import com.geosegbar.common.response.WebResponseEntity;
import com.geosegbar.entities.SectionEntity;
import com.geosegbar.infra.dam.services.DamService;
import com.geosegbar.infra.section.dtos.CreateSectionDTO;
import com.geosegbar.infra.section.services.SectionService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/sections"})
public class SectionController {
    private final SectionService sectionService;
    private final DamService damService;

    @GetMapping
    public ResponseEntity<WebResponseEntity<List<SectionEntity>>> getAllSections() {
        List<SectionEntity> sections = this.sectionService.findAll();
        return ResponseEntity.ok(WebResponseEntity.success(sections, "Se\u00e7\u00f5es obtidas com sucesso!"));
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<SectionEntity>> getSectionById(@PathVariable Long id) {
        SectionEntity section = this.sectionService.findById(id);
        return ResponseEntity.ok(WebResponseEntity.success(section, "Se\u00e7\u00e3o obtida com sucesso!"));
    }

    @GetMapping(value={"/dam/{damId}"})
    public ResponseEntity<WebResponseEntity<List<SectionEntity>>> getSectionsByDamId(@PathVariable Long damId) {
        List<SectionEntity> sections = this.sectionService.findAllByDamId(damId);
        return ResponseEntity.ok(WebResponseEntity.success(sections, "Se\u00e7\u00f5es da barragem obtidas com sucesso!"));
    }

    @PostMapping(consumes={"multipart/form-data"})
    public ResponseEntity<WebResponseEntity<SectionEntity>> createSection(@RequestPart(value="section") @Valid CreateSectionDTO sectionDTO, @RequestPart(value="file", required=false) MultipartFile file) {
        SectionEntity createdSection;
        if (file != null && !file.isEmpty()) {
            createdSection = this.sectionService.createWithFile(sectionDTO, file);
        } else {
            SectionEntity section = new SectionEntity();
            section.setName(sectionDTO.getName());
            section.setFirstVertexLatitude(sectionDTO.getFirstVertexLatitude());
            section.setSecondVertexLatitude(sectionDTO.getSecondVertexLatitude());
            section.setFirstVertexLongitude(sectionDTO.getFirstVertexLongitude());
            section.setSecondVertexLongitude(sectionDTO.getSecondVertexLongitude());
            section.setDam(this.damService.findById(sectionDTO.getDamId()));
            createdSection = this.sectionService.create(section);
        }
        return new ResponseEntity(WebResponseEntity.success(createdSection, "Se\u00e7\u00e3o criada com sucesso!"), (HttpStatusCode)HttpStatus.CREATED);
    }

    @PutMapping(value={"/{id}"}, consumes={"multipart/form-data"})
    public ResponseEntity<WebResponseEntity<SectionEntity>> updateSection(@PathVariable Long id, @RequestPart(value="section") @Valid CreateSectionDTO sectionDTO, @RequestPart(value="file", required=false) MultipartFile file) {
        SectionEntity updatedSection;
        if (file != null && !file.isEmpty()) {
            updatedSection = this.sectionService.updateWithFile(id, sectionDTO, file);
        } else {
            SectionEntity section = new SectionEntity();
            section.setName(sectionDTO.getName());
            section.setFirstVertexLatitude(sectionDTO.getFirstVertexLatitude());
            section.setSecondVertexLatitude(sectionDTO.getSecondVertexLatitude());
            section.setFirstVertexLongitude(sectionDTO.getFirstVertexLongitude());
            section.setSecondVertexLongitude(sectionDTO.getSecondVertexLongitude());
            section.setDam(this.damService.findById(sectionDTO.getDamId()));
            updatedSection = this.sectionService.update(id, section);
        }
        return ResponseEntity.ok(WebResponseEntity.success(updatedSection, "Se\u00e7\u00e3o atualizada com sucesso!"));
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<Void>> deleteSection(@PathVariable Long id) {
        this.sectionService.delete(id);
        return ResponseEntity.ok(WebResponseEntity.success(null, "Se\u00e7\u00e3o exclu\u00edda com sucesso!"));
    }

    @Generated
    public SectionController(SectionService sectionService, DamService damService) {
        this.sectionService = sectionService;
        this.damService = damService;
    }
}

