/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.reading.services;

import com.geosegbar.common.utils.ExpressionEvaluator;
import com.geosegbar.entities.ConstantEntity;
import com.geosegbar.entities.InstrumentEntity;
import com.geosegbar.entities.OutputEntity;
import com.geosegbar.infra.reading.dtos.ReadingRequestDTO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class OutputCalculationService {
    public Double calculateOutput(OutputEntity output, ReadingRequestDTO reading, Map<String, Double> inputValues) {
        InstrumentEntity instrument = output.getInstrument();
        HashMap<String, Double> variables = new HashMap<String, Double>(inputValues);
        for (ConstantEntity constant : instrument.getConstants()) {
            variables.put(constant.getAcronym(), constant.getValue());
        }
        Double result = ExpressionEvaluator.evaluate(output.getEquation(), variables);
        return this.formatToSpecificPrecision(result, output.getPrecision());
    }

    public Map<String, Double> calculateAllOutputs(InstrumentEntity instrument, ReadingRequestDTO reading, Map<String, Double> inputValues) {
        HashMap<String, Double> results = new HashMap<String, Double>();
        for (OutputEntity output : instrument.getOutputs()) {
            Double value = this.calculateOutput(output, reading, inputValues);
            results.put(output.getAcronym(), value);
        }
        return results;
    }

    private Double formatToSpecificPrecision(Double value, Integer precision) {
        if (value == null || precision == null) {
            return value;
        }
        BigDecimal bd = BigDecimal.valueOf(value);
        bd = bd.setScale((int)precision, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }

    @Generated
    public OutputCalculationService() {
    }
}

