/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.permissions.dam_permissions.web;

import com.geosegbar.common.response.WebResponseEntity;
import com.geosegbar.entities.DamPermissionEntity;
import com.geosegbar.infra.permissions.dam_permissions.dtos.UserDamPermissionsRequestDTO;
import com.geosegbar.infra.permissions.dam_permissions.services.DamPermissionService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dam-permission"})
public class DamPermissionController {
    private final DamPermissionService damPermissionService;

    @GetMapping(value={"/user/{userId}/all-client-dams"})
    public ResponseEntity<WebResponseEntity<List<DamPermissionEntity>>> getAllDamPermissionsForUserClients(@PathVariable Long userId) {
        List<DamPermissionEntity> permissions = this.damPermissionService.findAllDamPermissionsForUserClients(userId);
        WebResponseEntity<List<DamPermissionEntity>> response = WebResponseEntity.success(permissions, "Permiss\u00f5es de todas as barragens dos clientes do usu\u00e1rio obtidas com sucesso!");
        return ResponseEntity.ok(response);
    }

    @GetMapping(value={"/check-access/{userId}/{damId}"})
    public ResponseEntity<WebResponseEntity<Boolean>> checkUserHasAccessToDam(@PathVariable Long userId, @PathVariable Long damId) {
        boolean hasAccess = this.damPermissionService.checkUserHasAccessToDam(userId, damId);
        WebResponseEntity<Boolean> response = WebResponseEntity.success(hasAccess, "Verifica\u00e7\u00e3o de acesso realizada com sucesso!");
        return ResponseEntity.ok(response);
    }

    @PostMapping(value={"/setup-for-user/{userId}"})
    public ResponseEntity<WebResponseEntity<List<DamPermissionEntity>>> setupPermissionsForUser(@PathVariable Long userId, @Valid @RequestBody UserDamPermissionsRequestDTO requestDTO) {
        List<DamPermissionEntity> permissions = this.damPermissionService.setupPermissionsForUser(userId, requestDTO);
        WebResponseEntity<List<DamPermissionEntity>> response = WebResponseEntity.success(permissions, "Permiss\u00f5es de barragem configuradas com sucesso para o usu\u00e1rio!");
        return new ResponseEntity(response, (HttpStatusCode)HttpStatus.CREATED);
    }

    @PutMapping(value={"/update-for-user/{userId}"})
    public ResponseEntity<WebResponseEntity<List<DamPermissionEntity>>> updatePermissionsForUser(@PathVariable Long userId, @Valid @RequestBody UserDamPermissionsRequestDTO requestDTO) {
        List<DamPermissionEntity> permissions = this.damPermissionService.updatePermissionsForUser(userId, requestDTO);
        WebResponseEntity<List<DamPermissionEntity>> response = WebResponseEntity.success(permissions, "Permiss\u00f5es de barragem atualizadas com sucesso para o usu\u00e1rio!");
        return ResponseEntity.ok(response);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<Void>> deleteDamPermission(@PathVariable Long id) {
        this.damPermissionService.delete(id);
        WebResponseEntity<Object> response = WebResponseEntity.success(null, "Permiss\u00e3o de barragem exclu\u00edda com sucesso!");
        return ResponseEntity.ok(response);
    }

    @Generated
    public DamPermissionController(DamPermissionService damPermissionService) {
        this.damPermissionService = damPermissionService;
    }
}

