/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.instrument_tabulate_pattern.persistence.jpa;

import com.geosegbar.entities.InstrumentTabulatePatternEntity;
import jakarta.persistence.QueryHint;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.jpa.repository.QueryHints;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface InstrumentTabulatePatternRepository
extends JpaRepository<InstrumentTabulatePatternEntity, Long> {
    public List<InstrumentTabulatePatternEntity> findByDamId(Long var1);

    public List<InstrumentTabulatePatternEntity> findByFolderId(Long var1);

    public List<InstrumentTabulatePatternEntity> findByDamIdOrderByNameAsc(Long var1);

    public boolean existsByNameAndDamId(String var1, Long var2);

    public boolean existsByNameAndDamIdAndIdNot(String var1, Long var2, Long var3);

    @Query(value="SELECT p FROM InstrumentTabulatePatternEntity p WHERE p.dam.id = :damId AND p.folder IS NULL ORDER BY p.name ASC")
    public List<InstrumentTabulatePatternEntity> findByDamIdWithoutFolder(@Param(value="damId") Long var1);

    @QueryHints(value={@QueryHint(name="org.hibernate.cacheable", value="true")})
    @Query(value="SELECT DISTINCT p FROM InstrumentTabulatePatternEntity p LEFT JOIN FETCH p.dam LEFT JOIN FETCH p.folder LEFT JOIN FETCH p.associations a LEFT JOIN FETCH a.instrument i LEFT JOIN FETCH a.outputAssociations oa LEFT JOIN FETCH oa.output o LEFT JOIN FETCH o.measurementUnit WHERE p.folder.dam.id = :damId ORDER BY p.name ASC")
    public List<InstrumentTabulatePatternEntity> findByFolderDamIdWithAllDetails(@Param(value="damId") Long var1);

    @QueryHints(value={@QueryHint(name="org.hibernate.cacheable", value="true")})
    @Query(value="SELECT DISTINCT p FROM InstrumentTabulatePatternEntity p LEFT JOIN FETCH p.dam LEFT JOIN FETCH p.associations a LEFT JOIN FETCH a.instrument i LEFT JOIN FETCH a.outputAssociations oa LEFT JOIN FETCH oa.output o LEFT JOIN FETCH o.measurementUnit WHERE p.dam.id = :damId AND p.folder IS NULL ORDER BY p.name ASC")
    public List<InstrumentTabulatePatternEntity> findByDamIdWithoutFolderWithAllDetails(@Param(value="damId") Long var1);

    @QueryHints(value={@QueryHint(name="org.hibernate.cacheable", value="true")})
    @Query(value="SELECT DISTINCT p FROM InstrumentTabulatePatternEntity p LEFT JOIN FETCH p.dam LEFT JOIN FETCH p.folder LEFT JOIN FETCH p.associations a LEFT JOIN FETCH a.instrument i LEFT JOIN FETCH a.outputAssociations oa LEFT JOIN FETCH oa.output o LEFT JOIN FETCH o.measurementUnit WHERE p.id = :patternId")
    public Optional<InstrumentTabulatePatternEntity> findByIdWithAllDetails(@Param(value="patternId") Long var1);

    @QueryHints(value={@QueryHint(name="org.hibernate.cacheable", value="true")})
    @Query(value="SELECT DISTINCT p FROM InstrumentTabulatePatternEntity p LEFT JOIN FETCH p.dam LEFT JOIN FETCH p.folder WHERE p.id = :patternId")
    public Optional<InstrumentTabulatePatternEntity> findByIdWithBasicDetails(@Param(value="patternId") Long var1);

    @QueryHints(value={@QueryHint(name="org.hibernate.cacheable", value="true")})
    @Query(value="SELECT DISTINCT p FROM InstrumentTabulatePatternEntity p LEFT JOIN FETCH p.dam LEFT JOIN FETCH p.folder LEFT JOIN FETCH p.associations a LEFT JOIN FETCH a.instrument i LEFT JOIN FETCH a.outputAssociations oa LEFT JOIN FETCH oa.output o LEFT JOIN FETCH o.measurementUnit WHERE p.dam.id = :damId ORDER BY p.name ASC")
    public List<InstrumentTabulatePatternEntity> findByDamIdWithAllDetails(@Param(value="damId") Long var1);

    @QueryHints(value={@QueryHint(name="org.hibernate.cacheable", value="true")})
    @Query(value="SELECT DISTINCT p FROM InstrumentTabulatePatternEntity p LEFT JOIN FETCH p.dam LEFT JOIN FETCH p.folder LEFT JOIN FETCH p.associations a LEFT JOIN FETCH a.instrument i LEFT JOIN FETCH a.outputAssociations oa LEFT JOIN FETCH oa.output o LEFT JOIN FETCH o.measurementUnit WHERE p.folder.id = :folderId ORDER BY p.name ASC")
    public List<InstrumentTabulatePatternEntity> findByFolderIdWithAllDetails(@Param(value="folderId") Long var1);
}

