/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.instrument_graph_pattern.web;

import com.geosegbar.common.response.WebResponseEntity;
import com.geosegbar.infra.instrument_graph_pattern.dtos.CreateGraphPatternRequest;
import com.geosegbar.infra.instrument_graph_pattern.dtos.GraphPatternDetailResponseDTO;
import com.geosegbar.infra.instrument_graph_pattern.dtos.GraphPatternResponseDTO;
import com.geosegbar.infra.instrument_graph_pattern.dtos.UpdateNameGraphPatternDTO;
import com.geosegbar.infra.instrument_graph_pattern.services.InstrumentGraphPatternService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/graph-patterns"})
public class InstrumentGraphPatternController {
    private final InstrumentGraphPatternService patternService;

    @PostMapping
    public ResponseEntity<WebResponseEntity<GraphPatternResponseDTO>> createPattern(@Valid @RequestBody CreateGraphPatternRequest request) {
        GraphPatternResponseDTO dto = this.patternService.create(request);
        return new ResponseEntity(WebResponseEntity.success(dto, "Padr\u00e3o de Gr\u00e1fico criado com sucesso!"), (HttpStatusCode)HttpStatus.CREATED);
    }

    @PatchMapping(value={"/name/{id}"})
    public ResponseEntity<WebResponseEntity<GraphPatternDetailResponseDTO>> updateNameGraphPattern(@Valid @RequestBody UpdateNameGraphPatternDTO request, @PathVariable Long id) {
        GraphPatternDetailResponseDTO dto = this.patternService.updateNameGraphPattern(id, request.getName());
        return ResponseEntity.ok(WebResponseEntity.success(dto, "Nome do Padr\u00e3o de Gr\u00e1fico atualizado com sucesso!"));
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<Void>> deletePattern(@PathVariable Long id) {
        this.patternService.deleteById(id);
        return ResponseEntity.ok(WebResponseEntity.success(null, "Padr\u00e3o de Gr\u00e1fico exclu\u00eddo com sucesso!"));
    }

    @GetMapping(value={"/dam/{damId}"})
    public ResponseEntity<WebResponseEntity<List<GraphPatternDetailResponseDTO>>> getPatternsByDam(@PathVariable Long damId) {
        List<GraphPatternDetailResponseDTO> list = this.patternService.findAllPatternsByDam(damId);
        return ResponseEntity.ok(WebResponseEntity.success(list, "Padr\u00f5es de Gr\u00e1fico da barragem obtidos com sucesso!"));
    }

    @GetMapping(value={"/simple/instrument/{instrumentId}"})
    public ResponseEntity<WebResponseEntity<List<GraphPatternResponseDTO>>> getSimpleByInstrument(@PathVariable Long instrumentId) {
        List<GraphPatternResponseDTO> list = this.patternService.findByInstrument(instrumentId);
        return ResponseEntity.ok(WebResponseEntity.success(list, "Padr\u00f5es de Gr\u00e1fico obtidos com sucesso!"));
    }

    @GetMapping(value={"/instrument/{instrumentId}"})
    public ResponseEntity<WebResponseEntity<List<GraphPatternDetailResponseDTO>>> getByInstrument(@PathVariable Long instrumentId) {
        List<GraphPatternDetailResponseDTO> list = this.patternService.findByInstrumentWithDetails(instrumentId);
        return ResponseEntity.ok(WebResponseEntity.success(list, "Padr\u00f5es de Gr\u00e1fico completos obtidos com sucesso!"));
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<GraphPatternDetailResponseDTO>> getById(@PathVariable Long id) {
        GraphPatternDetailResponseDTO dto = this.patternService.findByIdWithDetails(id);
        return ResponseEntity.ok(WebResponseEntity.success(dto, "Padr\u00e3o de Gr\u00e1fico completo obtido com sucesso!"));
    }

    @GetMapping(value={"/simple/{id}"})
    public ResponseEntity<WebResponseEntity<GraphPatternResponseDTO>> getSimpleById(@PathVariable Long id) {
        GraphPatternResponseDTO dto = this.patternService.mapToResponseDTO(this.patternService.findById(id));
        return ResponseEntity.ok(WebResponseEntity.success(dto, "Padr\u00e3o de Gr\u00e1fico obtido com sucesso!"));
    }

    @Generated
    public InstrumentGraphPatternController(InstrumentGraphPatternService patternService) {
        this.patternService = patternService;
    }
}

