/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.deterministic_limit.web;

import com.geosegbar.common.response.WebResponseEntity;
import com.geosegbar.entities.DeterministicLimitEntity;
import com.geosegbar.infra.deterministic_limit.services.DeterministicLimitService;
import jakarta.validation.Valid;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/deterministic-limits"})
public class DeterministicLimitController {
    private final DeterministicLimitService deterministicLimitService;

    @GetMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<DeterministicLimitEntity>> getById(@PathVariable Long id) {
        DeterministicLimitEntity limit = this.deterministicLimitService.findById(id);
        return ResponseEntity.ok(WebResponseEntity.success(limit, "Limite determin\u00edstico obtido com sucesso!"));
    }

    @PostMapping(value={"/instrument/{instrumentId}"})
    public ResponseEntity<WebResponseEntity<DeterministicLimitEntity>> create(@PathVariable Long instrumentId, @Valid @RequestBody DeterministicLimitEntity limit) {
        DeterministicLimitEntity created = this.deterministicLimitService.createOrUpdate(instrumentId, limit);
        return new ResponseEntity(WebResponseEntity.success(created, "Limite determin\u00edstico criado com sucesso!"), (HttpStatusCode)HttpStatus.CREATED);
    }

    @PutMapping(value={"/instrument/{instrumentId}"})
    public ResponseEntity<WebResponseEntity<DeterministicLimitEntity>> update(@PathVariable Long instrumentId, @Valid @RequestBody DeterministicLimitEntity limit) {
        DeterministicLimitEntity updated = this.deterministicLimitService.createOrUpdate(instrumentId, limit);
        return ResponseEntity.ok(WebResponseEntity.success(updated, "Limite determin\u00edstico atualizado com sucesso!"));
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<Void>> delete(@PathVariable Long id) {
        this.deterministicLimitService.deleteById(id);
        return ResponseEntity.ok(WebResponseEntity.success(null, "Limite determin\u00edstico exclu\u00eddo com sucesso!"));
    }

    @Generated
    public DeterministicLimitController(DeterministicLimitService deterministicLimitService) {
        this.deterministicLimitService = deterministicLimitService;
    }
}

