/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.answer.web;

import com.geosegbar.common.response.WebResponseEntity;
import com.geosegbar.entities.AnswerEntity;
import com.geosegbar.infra.answer.services.AnswerService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/answers"})
public class AnswerController {
    private final AnswerService answerService;

    @GetMapping
    public ResponseEntity<WebResponseEntity<List<AnswerEntity>>> getAllAnswers() {
        List<AnswerEntity> answers = this.answerService.findAll();
        WebResponseEntity<List<AnswerEntity>> response = WebResponseEntity.success(answers, "Respostas obtidas com sucesso!");
        return ResponseEntity.ok(response);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<AnswerEntity>> getAnswerById(@PathVariable Long id) {
        AnswerEntity answer = this.answerService.findById(id);
        WebResponseEntity<AnswerEntity> response = WebResponseEntity.success(answer, "Resposta obtida com sucesso!");
        return ResponseEntity.ok(response);
    }

    @PostMapping
    public ResponseEntity<WebResponseEntity<AnswerEntity>> createAnswer(@Valid @RequestBody AnswerEntity answer) {
        AnswerEntity created = this.answerService.save(answer);
        WebResponseEntity<AnswerEntity> response = WebResponseEntity.success(created, "Resposta criada com sucesso!");
        return new ResponseEntity(response, (HttpStatusCode)HttpStatus.CREATED);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<AnswerEntity>> updateAnswer(@PathVariable Long id, @Valid @RequestBody AnswerEntity answer) {
        answer.setId(id);
        AnswerEntity updated = this.answerService.update(answer);
        WebResponseEntity<AnswerEntity> response = WebResponseEntity.success(updated, "Resposta atualizada com sucesso!");
        return ResponseEntity.ok(response);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<Void>> deleteAnswer(@PathVariable Long id) {
        this.answerService.deleteById(id);
        WebResponseEntity<Object> response = WebResponseEntity.success(null, "Resposta exclu\u00edda com sucesso!");
        return ResponseEntity.ok(response);
    }

    @Generated
    public AnswerController(AnswerService answerService) {
        this.answerService = answerService;
    }
}

