/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.anomaly_status.web;

import com.geosegbar.common.response.WebResponseEntity;
import com.geosegbar.entities.AnomalyStatusEntity;
import com.geosegbar.infra.anomaly_status.services.AnomalyStatusService;
import java.util.List;
import lombok.Generated;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/anomaly-status"})
public class AnomalyStatusController {
    private final AnomalyStatusService anomalyStatusService;

    @GetMapping
    public ResponseEntity<WebResponseEntity<List<AnomalyStatusEntity>>> getAllAnomalyStatuses() {
        List<AnomalyStatusEntity> anomalyStatuses = this.anomalyStatusService.findAll();
        WebResponseEntity<List<AnomalyStatusEntity>> response = WebResponseEntity.success(anomalyStatuses, "Anomaly statuses retrieved successfully!");
        return ResponseEntity.ok(response);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<AnomalyStatusEntity>> getAnomalyStatusById(@PathVariable Long id) {
        AnomalyStatusEntity anomalyStatus = this.anomalyStatusService.findById(id);
        WebResponseEntity<AnomalyStatusEntity> response = WebResponseEntity.success(anomalyStatus, "Anomaly status retrieved successfully!");
        return ResponseEntity.ok(response);
    }

    @GetMapping(value={"/name/{name}"})
    public ResponseEntity<WebResponseEntity<AnomalyStatusEntity>> getAnomalyStatusByName(@PathVariable String name) {
        AnomalyStatusEntity anomalyStatus = this.anomalyStatusService.findByName(name);
        WebResponseEntity<AnomalyStatusEntity> response = WebResponseEntity.success(anomalyStatus, "Anomaly status retrieved successfully!");
        return ResponseEntity.ok(response);
    }

    @Generated
    public AnomalyStatusController(AnomalyStatusService anomalyStatusService) {
        this.anomalyStatusService = anomalyStatusService;
    }
}

