/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.entities;

import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.geosegbar.entities.AnswerEntity;
import com.geosegbar.entities.ChecklistResponseEntity;
import com.geosegbar.entities.DamEntity;
import com.geosegbar.entities.TemplateQuestionnaireEntity;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.hibernate.annotations.CreationTimestamp;

@Entity
@Table(name="questionnaire_responses", indexes={@Index(name="idx_questionnaire_response_checklist_id", columnList="checklist_response_id"), @Index(name="idx_questionnaire_response_dam_id", columnList="dam_id"), @Index(name="idx_questionnaire_response_dam_created", columnList="dam_id, created_at"), @Index(name="idx_questionnaire_response_template_id", columnList="template_questionnaire_id")})
@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler"})
public class QuestionnaireResponseEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @NotNull(message="Informe o modelo de question\u00e1rio que esta sendo respondido!")
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="template_questionnaire_id", nullable=false)
    private @NotNull(message="Informe o modelo de question\u00e1rio que esta sendo respondido!") TemplateQuestionnaireEntity templateQuestionnaire;
    @NotNull(message="Informe a barragem que corresponde a esse checklist!")
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="dam_id", nullable=false)
    private @NotNull(message="Informe a barragem que corresponde a esse checklist!") DamEntity dam;
    @NotNull(message="Informe a resposta de checklist \u00e0 qual este question\u00e1rio pertence!")
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="checklist_response_id", nullable=false)
    @JsonBackReference(value="checklist-questionnaire-responses")
    private @NotNull(message="Informe a resposta de checklist \u00e0 qual este question\u00e1rio pertence!") ChecklistResponseEntity checklistResponse;
    @Column(name="created_at", updatable=false, nullable=false)
    @CreationTimestamp
    private LocalDateTime createdAt;
    @OneToMany(mappedBy="questionnaireResponse", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @JsonManagedReference(value="questionnaire-response-answers")
    private Set<AnswerEntity> answers = new HashSet<AnswerEntity>();

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public TemplateQuestionnaireEntity getTemplateQuestionnaire() {
        return this.templateQuestionnaire;
    }

    @Generated
    public DamEntity getDam() {
        return this.dam;
    }

    @Generated
    public ChecklistResponseEntity getChecklistResponse() {
        return this.checklistResponse;
    }

    @Generated
    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public Set<AnswerEntity> getAnswers() {
        return this.answers;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setTemplateQuestionnaire(TemplateQuestionnaireEntity templateQuestionnaire) {
        this.templateQuestionnaire = templateQuestionnaire;
    }

    @Generated
    public void setDam(DamEntity dam) {
        this.dam = dam;
    }

    @Generated
    public void setChecklistResponse(ChecklistResponseEntity checklistResponse) {
        this.checklistResponse = checklistResponse;
    }

    @Generated
    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setAnswers(Set<AnswerEntity> answers) {
        this.answers = answers;
    }

    @Generated
    public QuestionnaireResponseEntity() {
    }

    @Generated
    public QuestionnaireResponseEntity(Long id, TemplateQuestionnaireEntity templateQuestionnaire, DamEntity dam, ChecklistResponseEntity checklistResponse, LocalDateTime createdAt, Set<AnswerEntity> answers) {
        this.id = id;
        this.templateQuestionnaire = templateQuestionnaire;
        this.dam = dam;
        this.checklistResponse = checklistResponse;
        this.createdAt = createdAt;
        this.answers = answers;
    }
}

