/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.entities;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.geosegbar.entities.DamEntity;
import com.geosegbar.entities.QuestionnaireResponseEntity;
import com.geosegbar.entities.UserEntity;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.hibernate.annotations.CreationTimestamp;

@Entity
@Table(name="checklist_responses", indexes={@Index(name="idx_checklist_response_dam_id", columnList="dam_id"), @Index(name="idx_checklist_response_user_id", columnList="user_id"), @Index(name="idx_checklist_response_checklist_id", columnList="checklist_id"), @Index(name="idx_checklist_response_created_at", columnList="created_at"), @Index(name="idx_checklist_response_dam_created_desc", columnList="dam_id, created_at"), @Index(name="idx_checklist_response_dam_checklist_created", columnList="dam_id, checklist_id, created_at"), @Index(name="idx_checklist_response_dam_period", columnList="dam_id, created_at"), @Index(name="idx_checklist_response_user_created", columnList="user_id, created_at")})
@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler"})
public class ChecklistResponseEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @NotBlank(message="Nome do checklist \u00e9 obrigat\u00f3rio!")
    @Column(name="checklist_name", nullable=false)
    private @NotBlank(message="Nome do checklist \u00e9 obrigat\u00f3rio!") String checklistName;
    @NotNull(message="ID do checklist \u00e9 obrigat\u00f3rio!")
    @Column(name="checklist_id", nullable=false)
    private @NotNull(message="ID do checklist \u00e9 obrigat\u00f3rio!") Long checklistId;
    @Column(name="created_at", updatable=false)
    @CreationTimestamp
    private LocalDateTime createdAt;
    @NotNull(message="Informe a barragem que corresponde a essa resposta de checklist!")
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="dam_id", nullable=false)
    private @NotNull(message="Informe a barragem que corresponde a essa resposta de checklist!") DamEntity dam;
    @NotNull(message="Informe o usu\u00e1rio que respondeu esse checklist!")
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="user_id", nullable=false)
    private @NotNull(message="Informe o usu\u00e1rio que respondeu esse checklist!") UserEntity user;
    @OneToMany(mappedBy="checklistResponse", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @JsonManagedReference(value="checklist-questionnaire-responses")
    private Set<QuestionnaireResponseEntity> questionnaireResponses = new HashSet<QuestionnaireResponseEntity>();

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getChecklistName() {
        return this.checklistName;
    }

    @Generated
    public Long getChecklistId() {
        return this.checklistId;
    }

    @Generated
    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public DamEntity getDam() {
        return this.dam;
    }

    @Generated
    public UserEntity getUser() {
        return this.user;
    }

    @Generated
    public Set<QuestionnaireResponseEntity> getQuestionnaireResponses() {
        return this.questionnaireResponses;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setChecklistName(String checklistName) {
        this.checklistName = checklistName;
    }

    @Generated
    public void setChecklistId(Long checklistId) {
        this.checklistId = checklistId;
    }

    @Generated
    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setDam(DamEntity dam) {
        this.dam = dam;
    }

    @Generated
    public void setUser(UserEntity user) {
        this.user = user;
    }

    @Generated
    public void setQuestionnaireResponses(Set<QuestionnaireResponseEntity> questionnaireResponses) {
        this.questionnaireResponses = questionnaireResponses;
    }

    @Generated
    public ChecklistResponseEntity() {
    }

    @Generated
    public ChecklistResponseEntity(Long id, String checklistName, Long checklistId, LocalDateTime createdAt, DamEntity dam, UserEntity user, Set<QuestionnaireResponseEntity> questionnaireResponses) {
        this.id = id;
        this.checklistName = checklistName;
        this.checklistId = checklistId;
        this.createdAt = createdAt;
        this.dam = dam;
        this.user = user;
        this.questionnaireResponses = questionnaireResponses;
    }
}

