/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.share_folder.services;

import com.geosegbar.common.email.EmailService;
import com.geosegbar.common.utils.AuthenticatedUserUtil;
import com.geosegbar.entities.PSBFolderEntity;
import com.geosegbar.entities.ShareFolderEntity;
import com.geosegbar.entities.UserEntity;
import com.geosegbar.exceptions.NotFoundException;
import com.geosegbar.exceptions.ShareFolderException;
import com.geosegbar.infra.dam.persistence.jpa.DamRepository;
import com.geosegbar.infra.psb.persistence.PSBFolderRepository;
import com.geosegbar.infra.share_folder.dtos.CreateShareFolderRequest;
import com.geosegbar.infra.share_folder.persistence.ShareFolderRepository;
import com.geosegbar.infra.user.persistence.jpa.UserRepository;
import java.time.LocalDateTime;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ShareFolderService {
    private final ShareFolderRepository shareFolderRepository;
    private final PSBFolderRepository psbFolderRepository;
    private final UserRepository userRepository;
    private final DamRepository damRepository;
    private final EmailService emailService;

    @Transactional(readOnly=true)
    public List<ShareFolderEntity> findAllByUser(Long userId) {
        UserEntity user = (UserEntity)this.userRepository.findById((Object)userId).orElseThrow(() -> new NotFoundException("Usu\u00e1rio n\u00e3o encontrado"));
        return this.shareFolderRepository.findBySharedBy(user);
    }

    @Transactional(readOnly=true)
    public List<ShareFolderEntity> findAllByFolder(Long folderId) {
        PSBFolderEntity folder = (PSBFolderEntity)this.psbFolderRepository.findById((Object)folderId).orElseThrow(() -> new NotFoundException("Pasta PSB n\u00e3o encontrada"));
        return this.shareFolderRepository.findByPsbFolder(folder);
    }

    @Transactional(readOnly=true)
    public ShareFolderEntity findByToken(String token) {
        return (ShareFolderEntity)this.shareFolderRepository.findByToken(token).orElseThrow(() -> new NotFoundException("Link de compartilhamento n\u00e3o encontrado"));
    }

    @Transactional
    public ShareFolderEntity create(CreateShareFolderRequest request) {
        if (!AuthenticatedUserUtil.isAdmin() && !AuthenticatedUserUtil.getCurrentUser().getDocumentationPermission().getSharePSB().booleanValue()) {
            throw new NotFoundException("Usu\u00e1rio n\u00e3o tem permiss\u00e3o para compartilhar pastas PSB");
        }
        PSBFolderEntity folder = (PSBFolderEntity)this.psbFolderRepository.findById((Object)request.getPsbFolderId()).orElseThrow(() -> new NotFoundException("Pasta PSB n\u00e3o encontrada"));
        UserEntity sharedBy = (UserEntity)this.userRepository.findById((Object)request.getSharedById()).orElseThrow(() -> new NotFoundException("Usu\u00e1rio n\u00e3o encontrado"));
        boolean alreadyShared = this.shareFolderRepository.existsByPsbFolderIdAndSharedWithEmail(folder.getId(), request.getSharedWithEmail());
        if (alreadyShared) {
            throw new ShareFolderException("Esta pasta j\u00e1 foi compartilhada com este email");
        }
        ShareFolderEntity shareFolder = new ShareFolderEntity();
        shareFolder.setPsbFolder(folder);
        shareFolder.setSharedBy(sharedBy);
        shareFolder.setSharedWithEmail(request.getSharedWithEmail());
        shareFolder.setExpiresAt(request.getExpiresAt());
        ShareFolderEntity savedShare = (ShareFolderEntity)this.shareFolderRepository.save((Object)shareFolder);
        this.emailService.sendShareFolderEmail(request.getSharedWithEmail(), sharedBy.getName(), folder.getName(), savedShare.getToken());
        return savedShare;
    }

    @Transactional
    public ShareFolderEntity registerAccess(String token) {
        ShareFolderEntity shareFolder = (ShareFolderEntity)this.shareFolderRepository.findByToken(token).orElseThrow(() -> new NotFoundException("Link de compartilhamento n\u00e3o encontrado!"));
        if (shareFolder.getExpiresAt() != null && LocalDateTime.now().isAfter(shareFolder.getExpiresAt())) {
            this.shareFolderRepository.save((Object)shareFolder);
            throw new ShareFolderException("Este link de compartilhamento expirou!");
        }
        shareFolder.incrementAccessCount();
        return (ShareFolderEntity)this.shareFolderRepository.save((Object)shareFolder);
    }

    @Transactional
    public void deleteShare(Long shareId) {
        if (!AuthenticatedUserUtil.isAdmin() && !AuthenticatedUserUtil.getCurrentUser().getDocumentationPermission().getSharePSB().booleanValue()) {
            throw new NotFoundException("Usu\u00e1rio n\u00e3o tem permiss\u00e3o para excluir compartilhamentos de pastas PSB");
        }
        ShareFolderEntity shareFolder = (ShareFolderEntity)this.shareFolderRepository.findById((Object)shareId).orElseThrow(() -> new NotFoundException("Link de compartilhamento n\u00e3o encontrado"));
        this.shareFolderRepository.delete((Object)shareFolder);
    }

    @Transactional(readOnly=true)
    public List<ShareFolderEntity> findAllByDamId(Long damId) {
        if (!this.damRepository.existsById((Object)damId)) {
            throw new NotFoundException("Barragem n\u00e3o encontrada!");
        }
        return this.shareFolderRepository.findByPsbFolderDamIdOrderByCreatedAtDesc(damId);
    }

    @Generated
    public ShareFolderService(ShareFolderRepository shareFolderRepository, PSBFolderRepository psbFolderRepository, UserRepository userRepository, DamRepository damRepository, EmailService emailService) {
        this.shareFolderRepository = shareFolderRepository;
        this.psbFolderRepository = psbFolderRepository;
        this.userRepository = userRepository;
        this.damRepository = damRepository;
        this.emailService = emailService;
    }
}

