/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.roles.initializer;

import com.geosegbar.common.enums.RoleEnum;
import com.geosegbar.entities.RoleEntity;
import com.geosegbar.infra.roles.persistence.RoleRepository;
import jakarta.annotation.PostConstruct;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RoleInitializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RoleInitializer.class);
    private final RoleRepository roleRepository;

    @PostConstruct
    public void init() {
        log.info("Initializing roles...");
        if (!this.roleRepository.existsByName(RoleEnum.ADMIN)) {
            this.roleRepository.save((Object)new RoleEntity(RoleEnum.ADMIN, "Administrador: possui acesso total ao sistema."));
            log.info("ADMIN role created");
        }
        if (!this.roleRepository.existsByName(RoleEnum.COLLABORATOR)) {
            this.roleRepository.save((Object)new RoleEntity(RoleEnum.COLLABORATOR, "Colaborador: possui acesso limitado ao sistema."));
            log.info("COLLABORATOR role created");
        }
        log.info("Roles initialization completed");
    }

    @Generated
    public RoleInitializer(RoleRepository roleRepository) {
        this.roleRepository = roleRepository;
    }
}

